/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@BugPattern(name="MissingRuntimeRetention", altNames={"InjectScopeOrQualifierAnnotationRetention"}, summary="Scoping and qualifier annotations must have runtime retention.", severity=BugPattern.SeverityLevel.ERROR)
public class MissingRuntimeRetention
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String RETENTION_ANNOTATION = "java.lang.annotation.Retention";
    private static final Supplier<ImmutableSet<Name>> INJECT_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)state -> (ImmutableSet)Stream.of("com.google.inject.ScopeAnnotation", "javax.inject.Scope", "com.google.inject.BindingAnnotation", "javax.inject.Qualifier", "com.google.inject.multibindings.MapKey", "dagger.MapKey").map(arg_0 -> ((VisitorState)state).binaryNameFromClassname(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final Supplier<ImmutableSet<Name>> ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)state -> {
        Stream[] streamArray = new Stream[2];
        streamArray[0] = Stream.of("com.google.apps.framework.annotations.ProcessorAnnotation").map(arg_0 -> ((VisitorState)state).binaryNameFromClassname(arg_0));
        streamArray[1] = ((ImmutableSet)INJECT_ANNOTATIONS.get(state)).stream();
        return (ImmutableSet)Streams.concat((Stream[])streamArray).collect(ImmutableSet.toImmutableSet());
    });
    private static final Supplier<Symbol> JAVA_LANG_ANNOTATION_RETENTION = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString(RETENTION_ANNOTATION));

    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (!classTree.getKind().equals((Object)Tree.Kind.ANNOTATION_TYPE)) {
            return Description.NO_MATCH;
        }
        Set annotations = ASTHelpers.annotationsAmong((Symbol)ASTHelpers.getDeclaredSymbol((Tree)classTree), (Set)((Set)ANNOTATIONS.get(state)), (VisitorState)state);
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (!ElementPredicates.doesNotHaveRuntimeRetention(classSymbol)) {
            return Description.NO_MATCH;
        }
        if (!Collections.disjoint(annotations, (Collection)INJECT_ANNOTATIONS.get(state)) && MissingRuntimeRetention.exemptInjectAnnotation(state, classSymbol)) {
            return Description.NO_MATCH;
        }
        return this.describe(classTree, state, (Retention)ASTHelpers.getAnnotation((Symbol)classSymbol, Retention.class));
    }

    private static boolean exemptInjectAnnotation(VisitorState state, Symbol.ClassSymbol classSymbol) {
        if (ElementPredicates.hasSourceRetention(classSymbol)) {
            return false;
        }
        if (state.isAndroidCompatible()) {
            return true;
        }
        ClassTree outer = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        return outer != null && Matchers.allOf((Matcher[])new Matcher[]{InjectMatchers.IS_DAGGER_COMPONENT_OR_MODULE}).matches((Tree)outer, state);
    }

    private Description describe(ClassTree classTree, VisitorState state, @Nullable Retention retention) {
        if (retention == null) {
            AnnotationTree annotation = (AnnotationTree)Iterables.getLast(classTree.getModifiers().getAnnotations());
            return this.describeMatch(classTree, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").postfixWith((Tree)annotation, "@Retention(RUNTIME)").build());
        }
        AnnotationTree retentionNode = null;
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol((Tree)annotationTree).equals(JAVA_LANG_ANNOTATION_RETENTION.get(state))) continue;
            retentionNode = annotationTree;
        }
        return this.describeMatch(retentionNode, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").replace(retentionNode, "@Retention(RUNTIME)").build());
    }
}

