/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.LenientFormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="The number of arguments provided to lenient format methods should match the positional specifiers.")
public final class LenientFormatStringValidation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(tree, tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.match(tree, tree.getArguments(), state);
    }

    private Description match(ExpressionTree tree, List<? extends ExpressionTree> args, VisitorState state) {
        int formatStringPosition = LenientFormatStringUtils.getLenientFormatStringPosition(tree, state);
        if (formatStringPosition < 0) {
            return Description.NO_MATCH;
        }
        if (args.size() <= formatStringPosition) {
            return Description.NO_MATCH;
        }
        ExpressionTree formatStringArgument = args.get(formatStringPosition);
        Object formatString = ASTHelpers.constValue((Tree)formatStringArgument);
        if (!(formatString instanceof String)) {
            return Description.NO_MATCH;
        }
        String string = (String)formatString;
        int expected = LenientFormatStringValidation.occurrences(string, "%s");
        int actual = args.size() - formatStringPosition - 1;
        if (expected == actual) {
            return Description.NO_MATCH;
        }
        String replacedNumericPlaceholders = string.replace("%d", "%s");
        Description.Builder builder = this.buildDescription(tree).setMessage(String.format("Expected %s positional arguments, but saw %s. Note that lenient format strings only support %%s placeholders.", expected, actual));
        if (LenientFormatStringValidation.occurrences(replacedNumericPlaceholders, "%s") == actual && formatStringArgument instanceof LiteralTree) {
            builder.addFix((Fix)SuggestedFix.replace((Tree)formatStringArgument, (String)("\"" + SourceCodeEscapers.javaCharEscaper().escape(replacedNumericPlaceholders) + "\"")));
            return builder.build();
        }
        if (expected < actual) {
            String extraArgs = Collections.nCopies(actual - expected, "%s").stream().collect(Collectors.joining(", ", " (", ")"));
            int endPos = state.getEndPosition((Tree)formatStringArgument);
            builder.addFix((Fix)(formatStringArgument instanceof LiteralTree ? SuggestedFix.replace((int)(endPos - 1), (int)endPos, (String)(extraArgs + "\"")) : SuggestedFix.postfixWith((Tree)formatStringArgument, (String)String.format("+ \"%s\"", extraArgs))));
        }
        return builder.build();
    }

    private static int occurrences(String haystack, String needle) {
        int count = 0;
        int start = 0;
        while ((start = haystack.indexOf(needle, start)) != -1) {
            ++count;
            start += needle.length();
        }
        return count;
    }
}

