/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.bugpatterns.formatstring.LenientFormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Prefer to create format strings inline, instead of extracting them to a single-use constant", severity=BugPattern.SeverityLevel.WARNING)
public class InlineFormatString
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static @Nullable ExpressionTree formatString(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodArguments(tree, state);
        if (!args.isEmpty()) {
            return (ExpressionTree)args.get(0);
        }
        int index = LenientFormatStringUtils.getLenientFormatStringPosition(tree, state);
        return index != -1 ? tree.getArguments().get(index) : null;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final SetMultimap uses = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        final LinkedHashMap declarations = new LinkedHashMap();
        tree.accept(new TreeScanner<Void, Void>(this){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private void handle(MethodInvocationTree tree) {
                ExpressionTree arg = InlineFormatString.formatString(tree, state);
                if (arg == null) {
                    return;
                }
                Symbol variable = ASTHelpers.getSymbol((Tree)arg);
                if (variable == null || !this.isConstant(variable, arg)) {
                    return;
                }
                uses.put((Object)variable, (Object)arg);
            }

            private boolean isConstant(Symbol variable, ExpressionTree arg) {
                return switch (variable.getKind()) {
                    case ElementKind.FIELD -> {
                        if (variable.isPrivate() && ASTHelpers.constValue((Tree)arg, String.class) != null) {
                            yield true;
                        }
                        yield false;
                    }
                    case ElementKind.LOCAL_VARIABLE -> ASTHelpers.isConsideredFinal((Symbol)variable);
                    default -> false;
                };
            }
        }, null);
        tree.accept(new TreeScanner<Void, Void>(this){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitIdentifier(tree, null);
            }

            private void handle(Tree tree) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                if (sym == null) {
                    return;
                }
                if (uses.containsKey((Object)sym) && !uses.containsValue((Object)tree)) {
                    uses.removeAll((Object)sym);
                }
            }
        }, null);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){

            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
                if (uses.containsKey((Object)sym)) {
                    declarations.put(sym, tree);
                }
                return (Void)super.visitVariable(tree, null);
            }
        }.scan(state.getPath(), null);
        for (Map.Entry e : uses.asMap().entrySet()) {
            Symbol sym = (Symbol)e.getKey();
            Collection use = (Collection)e.getValue();
            VariableTree def = (VariableTree)declarations.get(sym);
            if (def == null || !(def.getInitializer() instanceof LiteralTree)) continue;
            String constValue = state.getSourceForNode((Tree)def.getInitializer());
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (use.size() > 1) continue;
            fix.delete((Tree)def);
            for (Tree u : use) {
                fix.replace(u, constValue);
            }
            state.reportMatch(this.describeMatch(def, (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }
}

