/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Locale;

public final class FormatStringUtils {
    private static final Matcher<ExpressionTree> FORMAT_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"java.io.PrintStream", "java.io.PrintWriter", "java.util.Formatter", "java.io.Console"}).namedAnyOf(new String[]{"format", "printf"}), MethodMatchers.staticMethod().onClass("java.lang.String").named("format"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readPassword(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readLine(java.lang.String,java.lang.Object...)")});
    private static final Matcher<ExpressionTree> FORMATTED_METHOD = MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("formatted");

    public static ImmutableList<ExpressionTree> formatMethodAnnotationArguments(MethodInvocationTree tree, VisitorState state) {
        return FormatStringUtils.formatMethodAnnotationArguments(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public static ImmutableList<ExpressionTree> formatMethodAnnotationArguments(Tree tree, Symbol.MethodSymbol symbol, java.util.List<? extends ExpressionTree> args, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Symbol)symbol, (String)"com.google.errorprone.annotations.FormatMethod", (VisitorState)state)) {
            return ImmutableList.of();
        }
        int formatStringIndex = FormatStringUtils.formatStringIndex(symbol, state);
        if (formatStringIndex == -1) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(args.subList(formatStringIndex, args.size()));
    }

    private static int formatStringIndex(Symbol.MethodSymbol symbol, VisitorState state) {
        Type stringType = state.getSymtab().stringType;
        java.util.List params = symbol.getParameters();
        int firstStringIndex = -1;
        for (int i = 0; i < ((List)params).size(); ++i) {
            Symbol.VarSymbol param = (Symbol.VarSymbol)((List)params).get(i);
            if (ASTHelpers.hasAnnotation((Symbol)param, (String)"com.google.errorprone.annotations.FormatString", (VisitorState)state)) {
                return i;
            }
            if (firstStringIndex >= 0 || !ASTHelpers.isSameType((Type)param.type, (Type)stringType, (VisitorState)state)) continue;
            firstStringIndex = i;
        }
        return firstStringIndex;
    }

    public static ImmutableList<ExpressionTree> formatMethodArguments(MethodInvocationTree tree, VisitorState state) {
        if (FORMATTED_METHOD.matches((Tree)tree, state)) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver == null) {
                return ImmutableList.of();
            }
            return ImmutableList.builder().add((Object)receiver).addAll(tree.getArguments()).build();
        }
        if (FORMAT_METHOD.matches((Tree)tree, state)) {
            ImmutableList args = ImmutableList.copyOf(tree.getArguments());
            if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)args.getFirst())), (Type)state.getTypeFromString(Locale.class.getName()), (VisitorState)state)) {
                args = args.subList(1, args.size());
            }
            return args;
        }
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodAnnotationArguments(tree, state);
        if (!args.isEmpty()) {
            return args;
        }
        return ImmutableList.of();
    }

    private FormatStringUtils() {
    }
}

