/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.bugpatterns.formatstring.FormatStringValidation;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Invalid printf-style format string", severity=BugPattern.SeverityLevel.ERROR)
public class FormatString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodArguments(tree, state);
        if (args.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        FormatStringValidation.ValidationResult result = FormatStringValidation.validate(sym, args, state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(result.message()).build();
    }
}

