/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(summary="Invalid message format-style format specifier ({0}), expected printf-style (%s)", explanation="Flogger uses printf-style format specifiers, such as %s and %d. Message format-style specifiers like {0} don't work.", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerMessageFormat
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Pattern MESSAGE_FORMAT_SPECIFIER = Pattern.compile("\\{[0-9]\\}");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String fixed;
        if (!LOG_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        ExpressionTree formatArg = arguments.getFirst();
        String formatString = (String)ASTHelpers.constValue((Tree)formatArg, String.class);
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        if (!MESSAGE_FORMAT_SPECIFIER.matcher(formatString).find()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        String source = state.getSourceForNode((Tree)formatArg);
        if (!source.equals(fixed = MESSAGE_FORMAT_SPECIFIER.matcher(source).replaceAll("%s"))) {
            description.addFix((Fix)SuggestedFix.replace((Tree)formatArg, (String)fixed));
        }
        return description.build();
    }
}

