/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringValidation;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import org.jspecify.annotations.Nullable;

@BugPattern(altNames={"FormatString"}, summary="Invalid printf-style format string", severity=BugPattern.SeverityLevel.ERROR)
public class FloggerFormatString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FORMAT_METHOD = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Matcher<ExpressionTree> WITH_CAUSE = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("withCause");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FORMAT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() <= 1) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        FormatStringValidation.ValidationResult result = FormatStringValidation.validate(sym, tree.getArguments(), state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree).setMessage(result.message());
        Fix fix = this.withCauseFix(result, tree, state);
        if (fix != null) {
            description.addFix(fix);
        }
        return description.build();
    }

    private @Nullable Fix withCauseFix(FormatStringValidation.ValidationResult result, MethodInvocationTree tree, final VisitorState state) {
        if (!result.message().startsWith("extra format arguments")) {
            return null;
        }
        ExpressionTree last = (ExpressionTree)Iterables.getLast(tree.getArguments());
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)last), (Type)state.getSymtab().throwableType, (VisitorState)state)) {
            return null;
        }
        final boolean[] withCause = new boolean[]{false};
        tree.accept(new TreeScanner<Void, Void>(this){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (WITH_CAUSE.matches((Tree)tree, state)) {
                    withCause[0] = true;
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }, null);
        if (withCause[0]) {
            return null;
        }
        return SuggestedFix.builder().replace(state.getEndPosition((Tree)tree.getArguments().get(tree.getArguments().size() - 2)), state.getEndPosition((Tree)last), "").postfixWith((Tree)ASTHelpers.getReceiver((ExpressionTree)tree), String.format(".withCause(%s)", state.getSourceForNode((Tree)last))).build();
    }
}

