/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibility;
import com.google.errorprone.bugpatterns.collectionincompatibletype.IgnoringCasts;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.List;
import javax.inject.Inject;

@BugPattern(summary="The types passed to this assertion are incompatible.", severity=BugPattern.SeverityLevel.WARNING)
public final class JUnitIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).namedAnyOf(new String[]{"assertEquals", "assertNotEquals"}), Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().withAnyName().withParameters("java.lang.Object", new String[]{"java.lang.Object"}), MethodMatchers.staticMethod().anyClass().withAnyName().withParameters("java.lang.String", new String[]{"java.lang.Object", "java.lang.Object"})})});
    private static final Matcher<ExpressionTree> ASSERT_ARRAY_EQUALS = MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).namedAnyOf(new String[]{"assertArrayEquals"});
    private final TypeCompatibility typeCompatibility;

    @Inject
    JUnitIncompatibleType(TypeCompatibility typeCompatibility) {
        this.typeCompatibility = typeCompatibility;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        block4: {
            Type.ArrayType expectedArray;
            Type actual;
            block6: {
                block5: {
                    List<? extends ExpressionTree> arguments = tree.getArguments();
                    if (ASSERT_EQUALS.matches((Tree)tree, state)) {
                        int skip = JUnitIncompatibleType.argumentsToSkip(tree, state);
                        Type typeA = IgnoringCasts.ignoringCasts(arguments.get(skip), state);
                        Type typeB = IgnoringCasts.ignoringCasts(arguments.get(skip + 1), state);
                        return this.checkCompatibility(tree, typeA, typeB, state);
                    }
                    if (!ASSERT_ARRAY_EQUALS.matches((Tree)tree, state)) break block4;
                    int skip = JUnitIncompatibleType.argumentsToSkip(tree, state);
                    Type expected = ASTHelpers.getUpperBound((Type)IgnoringCasts.ignoringCasts(arguments.get(skip), state), (Types)state.getTypes());
                    actual = ASTHelpers.getUpperBound((Type)IgnoringCasts.ignoringCasts(arguments.get(skip + 1), state), (Types)state.getTypes());
                    if (!(expected instanceof Type.ArrayType)) break block5;
                    expectedArray = (Type.ArrayType)expected;
                    if (actual instanceof Type.ArrayType) break block6;
                }
                return Description.NO_MATCH;
            }
            Type.ArrayType actualArray = (Type.ArrayType)actual;
            return this.checkCompatibility(tree, expectedArray.elemtype, actualArray.elemtype, state);
        }
        return Description.NO_MATCH;
    }

    private static int argumentsToSkip(MethodInvocationTree tree, VisitorState state) {
        return ASTHelpers.isSameType((Type)((Symbol.VarSymbol)ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters().getFirst()).type, (Type)state.getSymtab().stringType, (VisitorState)state) ? 1 : 0;
    }

    private Description checkCompatibility(ExpressionTree tree, Type targetType, Type sourceType, VisitorState state) {
        String targetTypeName;
        TypeCompatibility.TypeCompatibilityReport compatibilityReport = this.typeCompatibility.compatibilityOfTypes(targetType, sourceType, state);
        if (compatibilityReport.isCompatible()) {
            return Description.NO_MATCH;
        }
        String sourceTypeName = Signatures.prettyType((Type)sourceType);
        if (sourceTypeName.equals(targetTypeName = Signatures.prettyType((Type)targetType))) {
            sourceTypeName = sourceType.toString();
            targetTypeName = targetType.toString();
        }
        return this.buildDescription(tree).setMessage(String.format("The types of this assertion are mismatched: type `%s` is not compatible with `%s`%s", sourceTypeName, targetTypeName, compatibilityReport.extraReason())).build();
    }
}

