/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.List;

@BugPattern(summary="The types passed to this assertion are incompatible.", severity=BugPattern.SeverityLevel.WARNING)
public final class AssertSameIncompatible
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> JUNIT_MATCHER = Matchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).namedAnyOf(new String[]{"assertSame", "assertNotSame"});
    private static final Matcher<ExpressionTree> TRUTH_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isSameInstanceAs", "isNotSameInstanceAs"});
    private static final ImmutableSet<String> NEGATIVE_ASSERTIONS = ImmutableSet.of((Object)"assertNotSame", (Object)"isNotSameInstanceAs");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (JUNIT_MATCHER.matches((Tree)tree, state)) {
            return this.handleJUnit(tree, state);
        }
        if (TRUTH_MATCHER.matches((Tree)tree, state)) {
            return this.handleTruth(tree, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleJUnit(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        Type expected = ASTHelpers.getType((Tree)((Tree)arguments.reversed().get(1)));
        Type actual = ASTHelpers.getType((Tree)((Tree)arguments.reversed().get(0)));
        return this.handle(tree, actual, expected, NEGATIVE_ASSERTIONS.contains((Object)((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString()), state);
    }

    private Description handleTruth(MethodInvocationTree tree, VisitorState state) {
        MethodInvocationTree mit;
        Type expected = ASTHelpers.getType((Tree)tree.getArguments().get(0));
        ExpressionTree assertThat = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!(assertThat instanceof MethodInvocationTree) || !((Name)ASTHelpers.getSymbol((MethodInvocationTree)(mit = (MethodInvocationTree)assertThat)).getSimpleName()).contentEquals("assertThat") || mit.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Type actual = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(mit.getArguments())));
        return this.handle(tree, actual, expected, ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString().contains("Not"), state);
    }

    private Description handle(Tree tree, Type actual, Type expected, boolean inverted, VisitorState state) {
        if (AssertSameIncompatible.compatible(actual, expected, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("The types passed to this assertion are incompatible (this check will always %s): type `%s` is not compatible with `%s`", inverted ? "pass" : "fail", Signatures.prettyType((Type)actual), Signatures.prettyType((Type)expected))).build();
    }

    private static boolean compatible(Type typeA, Type typeB, VisitorState state) {
        Type erasedB;
        Type erasedA;
        Types types = state.getTypes();
        return types.isCastable(erasedA = types.erasure(typeA), erasedB = types.erasure(typeB)) || types.isCastable(erasedB, erasedA);
    }
}

