/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.stream.Collectors;

record Changes(ImmutableList<Double> originalCost, ImmutableList<Double> assignmentCost, ImmutableList<ParameterPair> changedPairs) {
    boolean isEmpty() {
        return this.changedPairs().isEmpty();
    }

    double totalAssignmentCost() {
        return this.assignmentCost().stream().mapToDouble(d -> d).sum();
    }

    double totalOriginalCost() {
        return this.originalCost().stream().mapToDouble(d -> d).sum();
    }

    static Changes create(ImmutableList<Double> originalCost, ImmutableList<Double> assignmentCost, ImmutableList<ParameterPair> changedPairs) {
        return new Changes(originalCost, assignmentCost, changedPairs);
    }

    static Changes empty() {
        return new Changes((ImmutableList<Double>)ImmutableList.of(), (ImmutableList<Double>)ImmutableList.of(), (ImmutableList<ParameterPair>)ImmutableList.of());
    }

    SuggestedFix buildCommentArgumentsFix(InvocationInfo info) {
        SuggestedFix.Builder commentArgumentsFixBuilder = SuggestedFix.builder();
        for (ParameterPair change : this.changedPairs()) {
            int index = change.formal().index();
            Tree actual = (Tree)info.actualParameters().get(index);
            int startPosition = ASTHelpers.getStartPosition((Tree)actual);
            String formal = ((Name)((Symbol.VarSymbol)info.formalParameters().get(index)).getSimpleName()).toString();
            commentArgumentsFixBuilder.replace(startPosition, startPosition, NamedParameterComment.toCommentText(formal));
        }
        return commentArgumentsFixBuilder.build();
    }

    SuggestedFix buildPermuteArgumentsFix(InvocationInfo info) {
        SuggestedFix.Builder permuteArgumentsFixBuilder = SuggestedFix.builder();
        for (ParameterPair pair : this.changedPairs()) {
            permuteArgumentsFixBuilder.replace((Tree)info.actualParameters().get(pair.formal().index()), info.state().getSourceForNode((Tree)info.actualParameters().get(pair.actual().index())));
        }
        return permuteArgumentsFixBuilder.build();
    }

    public String describe(InvocationInfo info) {
        return "The following arguments may have been swapped: " + this.changedPairs().stream().map(p -> String.format("'%s' for formal parameter '%s'", info.state().getSourceForNode((Tree)info.actualParameters().get(p.formal().index())), p.formal().name())).collect(Collectors.joining(", ")) + ". Either add clarifying `/* paramName= */` comments, or swap the arguments if that is what was intended";
    }
}

