/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="The `^` operator is binary XOR, not a power operator.", severity=BugPattern.SeverityLevel.ERROR)
public class XorPower
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!tree.getKind().equals((Object)Tree.Kind.XOR)) {
            return Description.NO_MATCH;
        }
        ExpressionTree lhsTree = tree.getLeftOperand();
        while (lhsTree instanceof BinaryTree) {
            lhsTree = ((BinaryTree)lhsTree).getRightOperand();
        }
        Number lhs = (Number)ASTHelpers.constValue((Tree)lhsTree, Number.class);
        if (lhs == null) {
            return Description.NO_MATCH;
        }
        if (lhs.longValue() != (long)lhs.intValue()) {
            return Description.NO_MATCH;
        }
        switch (lhs.intValue()) {
            case 2: 
            case 10: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Number rhs = (Number)ASTHelpers.constValue((Tree)tree.getRightOperand(), Number.class);
        if (rhs == null) {
            return Description.NO_MATCH;
        }
        if (rhs.longValue() != (long)rhs.intValue()) {
            return Description.NO_MATCH;
        }
        if (state.getSourceForNode((Tree)tree.getRightOperand()).startsWith("0")) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree).setMessage(String.format("The ^ operator is binary XOR, not a power operator, so '%s' will always evaluate to %d.", state.getSourceForNode((Tree)tree), lhs.intValue() ^ rhs.intValue()));
        String suffix = lhs instanceof Long ? "L" : "";
        int start = ASTHelpers.getStartPosition((Tree)lhsTree);
        int end = state.getEndPosition((Tree)tree);
        switch (lhs.intValue()) {
            case 2: {
                if (rhs.intValue() > (lhs instanceof Long ? 63 : 31)) break;
                Object replacement = String.format("1%s << %d", suffix, rhs);
                if (start != ASTHelpers.getStartPosition((Tree)tree)) {
                    replacement = "(" + (String)replacement + ")";
                }
                description.addFix((Fix)SuggestedFix.replace((int)start, (int)end, (String)replacement));
                break;
            }
            case 10: {
                if (rhs.intValue() > (lhs instanceof Long ? 18 : 9)) break;
                description.addFix((Fix)SuggestedFix.replace((int)start, (int)end, (String)("1" + "0".repeat(rhs.intValue()) + suffix)));
                break;
            }
            default: {
                throw new AssertionError(lhs);
            }
        }
        return description.build();
    }
}

