/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.WaitMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(summary="Because of spurious wakeups, Object.wait() and Condition.await() must always be called in a loop", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class WaitNotInLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{WaitMatchers.WAIT_METHOD, Matchers.not((Matcher)Matchers.inLoop())});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        JCTree.JCIf enclosingIf;
        if (!matcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        description.setMessage(String.format("Because of spurious wakeups, %s must always be called in a loop", sym));
        if (!WaitMatchers.WAIT_METHOD_WITH_TIMEOUT.matches((Tree)tree, state) && (enclosingIf = (JCTree.JCIf)ASTHelpers.findEnclosingNode((TreePath)state.getPath().getParentPath(), JCTree.JCIf.class)) != null && enclosingIf.getElseStatement() == null) {
            String ifSource = state.getSourceForNode((Tree)enclosingIf);
            if (ifSource == null) {
                return description.build();
            }
            String replacement = ifSource.toString().replaceFirst("if", "while");
            return description.addFix((Fix)SuggestedFix.replace((Tree)enclosingIf, (String)replacement)).build();
        }
        return description.build();
    }
}

