/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.NullType;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;

@BugPattern(altNames={"unused", "UnusedParameters"}, summary="Unused.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedVariable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final ImmutableSet<String> exemptPrefixes;
    private final ImmutableSet<String> exemptNames;
    private static final ImmutableSet<String> ANNOTATIONS_INDICATING_PARAMETERS_SHOULD_BE_CHECKED = ImmutableSet.of((Object)"com.google.errorprone.refaster.annotation.AfterTemplate", (Object)"com.google.errorprone.refaster.annotation.BeforeTemplate", (Object)"com.google.inject.Inject", (Object)"com.google.inject.Provides", (Object)"com.google.inject.multibindings.ProvidesIntoMap", (Object)"com.google.inject.multibindings.ProvidesIntoSet", (Object[])new String[]{"dagger.Provides", "jakarta.inject.Inject", "javax.inject.Inject", "org.junit.Test"});
    private final ImmutableSet<String> methodAnnotationsExemptingParameters;
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private static final ImmutableSet<String> EXEMPTING_FIELD_SUPER_TYPES = ImmutableSet.of((Object)"org.junit.rules.TestRule");
    private static final ImmutableSet<String> SPECIAL_FIELDS = ImmutableSet.of((Object)"serialVersionUID", (Object)"TAG");
    private static final ImmutableSet<String> FUNCTIONAL_INTERFACE_TYPES_TO_CHECK = ImmutableSet.of((Object)"java.util.Comparator");
    private final boolean reportInjectedFields;
    private final WellKnownKeep wellKnownKeep;
    private static final ImmutableSet<Tree.Kind> TOP_LEVEL_EXPRESSIONS = ImmutableSet.of((Object)((Object)Tree.Kind.ASSIGNMENT), (Object)((Object)Tree.Kind.PREFIX_INCREMENT), (Object)((Object)Tree.Kind.PREFIX_DECREMENT), (Object)((Object)Tree.Kind.POSTFIX_INCREMENT), (Object)((Object)Tree.Kind.POSTFIX_DECREMENT), (Object)((Object)Tree.Kind.METHOD_INVOCATION), (Object[])new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    private static final Supplier<Type> PARCELABLE_CREATOR = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("android.os.Parcelable.Creator"));

    @Inject
    UnusedVariable(ErrorProneFlags flags, WellKnownKeep wellKnownKeep) {
        this.methodAnnotationsExemptingParameters = ImmutableSet.builder().add((Object)"com.google.common.eventbus.Subscribe").add((Object)"org.robolectric.annotation.Implementation").addAll((Iterable)flags.getListOrEmpty("Unused:methodAnnotationsExemptingParameters")).build();
        this.reportInjectedFields = flags.getBoolean("Unused:ReportInjectedFields").orElse(false);
        this.exemptNames = ImmutableSet.builder().add((Object)"ignored").add((Object)"").addAll((Iterable)flags.getListOrEmpty("Unused:exemptNames")).build();
        this.exemptPrefixes = ImmutableSet.builder().add((Object)"unused").addAll((Iterable)flags.getSetOrEmpty("Unused:exemptPrefixes")).build();
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (UnusedVariable.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        ImmutableMultimap<Symbol.MethodSymbol, Symbol.MethodSymbol> superMethodsToOverrides = UnusedVariable.getSuperMethodsToOverrides(tree, state);
        VariableFinder variableFinder = new VariableFinder(state, superMethodsToOverrides);
        variableFinder.scan(state.getPath(), null);
        Map<Symbol, TreePath> unusedElements = variableFinder.unusedElements;
        Set<Symbol> onlyCheckForReassignments = variableFinder.onlyCheckForReassignments;
        ListMultimap<Symbol, TreePath> usageSites = variableFinder.usageSites;
        FilterUsedVariables filterUsedVariables = new FilterUsedVariables(unusedElements, usageSites);
        filterUsedVariables.scan(state.getPath(), null);
        Set<Symbol> isEverUsed = filterUsedVariables.isEverUsed;
        List<UnusedSpec> unusedSpecs = filterUsedVariables.unusedSpecs;
        for (Map.Entry<Symbol, TreePath> entry : unusedElements.entrySet()) {
            unusedSpecs.add(UnusedSpec.of(entry.getKey(), entry.getValue(), usageSites.get((Object)entry.getKey()), null));
        }
        ImmutableListMultimap unusedSpecsBySymbol = Multimaps.index(unusedSpecs, UnusedSpec::symbol);
        for (Map.Entry entry : unusedSpecsBySymbol.asMap().entrySet()) {
            Symbol unusedSymbol = (Symbol)entry.getKey();
            Collection specs = (Collection)entry.getValue();
            ImmutableList allUsageSites = (ImmutableList)specs.stream().flatMap(u -> u.usageSites().stream()).collect(ImmutableList.toImmutableList());
            if (!unusedElements.containsKey(unusedSymbol)) {
                isEverUsed.add(unusedSymbol);
            }
            SuggestedFix makeFirstAssignmentDeclaration = UnusedVariable.makeAssignmentDeclaration(unusedSymbol, specs, (ImmutableList<TreePath>)allUsageSites, state);
            if (onlyCheckForReassignments.contains(unusedSymbol) && specs.size() <= 1) continue;
            Tree unused = ((UnusedSpec)specs.iterator().next()).assignmentPath().getLeaf();
            Symbol.VarSymbol symbol = (Symbol.VarSymbol)unusedSymbol;
            ImmutableList<SuggestedFix> fixes = symbol.getKind() == ElementKind.PARAMETER && !onlyCheckForReassignments.contains(unusedSymbol) && !isEverUsed.contains(unusedSymbol) ? UnusedVariable.buildUnusedParameterFixes(symbol, (List<TreePath>)allUsageSites, state) : UnusedVariable.buildUnusedVarFixes(symbol, (List<TreePath>)allUsageSites, state);
            state.reportMatch(this.buildDescription(unused).setMessage(String.format("%s %s '%s' is never read.", isEverUsed.contains(symbol) ? "This assignment to the" : "The", UnusedVariable.describeVariable(symbol), symbol.name)).addAllFixes((List)fixes.stream().map(f -> SuggestedFix.merge((SuggestedFix)makeFirstAssignmentDeclaration, (SuggestedFix)f, (SuggestedFix[])new SuggestedFix[0])).collect(ImmutableList.toImmutableList())).build());
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix makeAssignmentDeclaration(Symbol unusedSymbol, Collection<UnusedSpec> specs, ImmutableList<TreePath> allUsageSites, VisitorState state) {
        if (unusedSymbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return SuggestedFix.emptyFix();
        }
        Optional<VariableTree> removedVariableTree = allUsageSites.stream().filter(tp -> tp.getLeaf() instanceof VariableTree).findFirst().map(tp -> (VariableTree)tp.getLeaf());
        Optional<AssignmentTree> reassignment = specs.stream().map(UnusedSpec::terminatingAssignment).flatMap(Streams::stream).filter(a -> allUsageSites.stream().noneMatch(tp -> {
            ExpressionStatementTree expressionStatementTree;
            Tree patt0$temp = tp.getLeaf();
            return patt0$temp instanceof ExpressionStatementTree && (expressionStatementTree = (ExpressionStatementTree)patt0$temp).getExpression().equals(a);
        })).findFirst();
        if (removedVariableTree.isPresent() && reassignment.isPresent()) {
            return SuggestedFix.prefixWith((Tree)reassignment.get(), (String)(state.getSourceForNode(removedVariableTree.get().getType()) + " "));
        }
        return SuggestedFix.emptyFix();
    }

    private static String describeVariable(Symbol.VarSymbol symbol) {
        return switch (symbol.getKind()) {
            case ElementKind.FIELD -> "field";
            case ElementKind.LOCAL_VARIABLE -> "local variable";
            case ElementKind.PARAMETER -> "parameter";
            case ElementKind.BINDING_VARIABLE -> "binding variable";
            default -> "variable";
        };
    }

    private static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private static ImmutableMultimap<Symbol.MethodSymbol, Symbol.MethodSymbol> getSuperMethodsToOverrides(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableMultimap.Builder overrides = ImmutableMultimap.builder();
        final JavaFileObject sourceFile = tree.getSourceFile();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
                ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)state.getTypes()).stream().filter(m -> sourceFile.equals(m.enclClass().sourcefile)).forEach(m -> overrides.put(m, (Object)sym));
                return null;
            }
        }.scan(tree, null);
        return overrides.build();
    }

    private static boolean needsBlock(TreePath path) {
        Tree leaf = path.getLeaf();
        class Visitor
        extends SimpleTreeVisitor<Boolean, Void> {
            final /* synthetic */ Tree val$leaf;

            Visitor(Tree tree) {
                this.val$leaf = tree;
            }

            @Override
            public Boolean visitIf(IfTree tree, Void unused) {
                return tree.getThenStatement() == this.val$leaf || tree.getElseStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitDoWhileLoop(DoWhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitWhileLoop(WhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitForLoop(ForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }
        }
        return (Boolean)MoreObjects.firstNonNull((Object)path.getParentPath().getLeaf().accept(new Visitor(leaf), null), (Object)false);
    }

    private static ImmutableList<SuggestedFix> buildUnusedVarFixes(Symbol varSymbol, List<TreePath> usagePaths, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)varSymbol, (String)"Inject")) {
            return ImmutableList.of();
        }
        ElementKind varKind = varSymbol.getKind();
        boolean encounteredSideEffects = false;
        SuggestedFix.Builder keepSideEffectsFix = SuggestedFix.builder().setShortDescription("remove unused variable");
        SuggestedFix.Builder removeSideEffectsFix = SuggestedFix.builder().setShortDescription("remove unused variable and any side effects");
        block3: for (TreePath usagePath : usagePaths) {
            StatementTree statement = (StatementTree)usagePath.getLeaf();
            if (statement instanceof VariableTree) {
                VariableTree variableTree = (VariableTree)statement;
                if (ASTHelpers.getSymbol((Tree)statement).getKind() == ElementKind.PARAMETER) continue;
                ExpressionTree initializer = variableTree.getInitializer();
                if (SideEffectAnalysis.hasSideEffect((ExpressionTree)initializer) && TOP_LEVEL_EXPRESSIONS.contains((Object)initializer.getKind())) {
                    encounteredSideEffects = true;
                    switch (varKind) {
                        case FIELD: {
                            String newContent = String.format("%s{ %s; }", ASTHelpers.isStatic((Symbol)varSymbol) ? "static " : "", state.getSourceForNode((Tree)initializer));
                            keepSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments((TreePath)usagePath, (String)newContent, (VisitorState)state));
                            removeSideEffectsFix.replace((Tree)statement, "");
                            continue block3;
                        }
                    }
                    keepSideEffectsFix.replace((Tree)statement, String.format("%s;", state.getSourceForNode((Tree)initializer)));
                    removeSideEffectsFix.replace((Tree)statement, "");
                    continue;
                }
                if (UnusedVariable.isEnhancedForLoopVar(usagePath)) {
                    String modifiers = Strings.nullToEmpty(variableTree.getModifiers() == null ? null : state.getSourceForNode((Tree)variableTree.getModifiers()));
                    String newContent = String.format("%s%s unused", modifiers.isEmpty() ? "" : modifiers + " ", state.getSourceForNode(variableTree.getType()));
                    keepSideEffectsFix.replace((Tree)variableTree, newContent);
                    removeSideEffectsFix.replace((Tree)variableTree, newContent);
                    continue;
                }
                if (varKind == ElementKind.BINDING_VARIABLE) {
                    removeSideEffectsFix.replace((Tree)variableTree, state.getSourceForNode(variableTree.getType()));
                    keepSideEffectsFix.replace((Tree)variableTree, state.getSourceForNode(variableTree.getType()));
                    continue;
                }
                String replacement = UnusedVariable.needsBlock(usagePath) ? "{}" : "";
                keepSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments((TreePath)usagePath, (String)replacement, (VisitorState)state));
                removeSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments((TreePath)usagePath, (String)replacement, (VisitorState)state));
                continue;
            }
            if (statement instanceof ExpressionStatementTree) {
                AssignmentTree assignmentTree;
                ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statement;
                ExpressionTree tree = expressionStatementTree.getExpression();
                if (tree instanceof CompoundAssignmentTree) {
                    CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)tree;
                    if (SideEffectAnalysis.hasSideEffect((ExpressionTree)compoundAssignmentTree.getExpression())) {
                        SuggestedFix replacement = SuggestedFix.replace((int)ASTHelpers.getStartPosition((Tree)tree), (int)ASTHelpers.getStartPosition((Tree)compoundAssignmentTree.getExpression()), (String)"");
                        keepSideEffectsFix.merge(replacement);
                        removeSideEffectsFix.merge(replacement);
                        continue;
                    }
                } else if (tree instanceof AssignmentTree && SideEffectAnalysis.hasSideEffect((ExpressionTree)(assignmentTree = (AssignmentTree)tree).getExpression())) {
                    encounteredSideEffects = true;
                    keepSideEffectsFix.replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)assignmentTree.getExpression()), "");
                    removeSideEffectsFix.replace((Tree)statement, "");
                    continue;
                }
            }
            String replacement = UnusedVariable.needsBlock(usagePath) ? "{}" : "";
            keepSideEffectsFix.replace((Tree)statement, replacement);
            removeSideEffectsFix.replace((Tree)statement, replacement);
        }
        return encounteredSideEffects ? ImmutableList.of((Object)removeSideEffectsFix.build(), (Object)keepSideEffectsFix.build()) : ImmutableList.of((Object)keepSideEffectsFix.build());
    }

    private static ImmutableList<SuggestedFix> buildUnusedParameterFixes(Symbol varSymbol, List<TreePath> usagePaths, final VisitorState state) {
        Symbol.MethodSymbol methodSymbol;
        Symbol symbol = varSymbol.owner;
        if (!(symbol instanceof Symbol.MethodSymbol && (methodSymbol = (Symbol.MethodSymbol)symbol).params().contains(varSymbol) && ASTHelpers.canBeRemoved((Symbol)varSymbol.owner, (VisitorState)state))) {
            return ImmutableList.of();
        }
        final int index = methodSymbol.params.indexOf(varSymbol);
        TreeRangeSet deletions = TreeRangeSet.create();
        for (TreePath path : usagePaths) {
            deletions.add(Range.closed((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)path.getLeaf())), (Comparable)Integer.valueOf(state.getEndPosition(path.getLeaf()))));
        }
        new TreePathScanner<Void, Void>((RangeSet)deletions){
            final /* synthetic */ RangeSet val$deletions;
            {
                this.val$deletions = rangeSet;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (ASTHelpers.getSymbol((MethodInvocationTree)tree).equals(methodSymbol)) {
                    this.removeByIndex(tree.getArguments());
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (ASTHelpers.getSymbol((MethodTree)tree).equals(methodSymbol)) {
                    this.removeByIndex(tree.getParameters());
                }
                return (Void)super.visitMethod(tree, null);
            }

            private void removeByIndex(List<? extends Tree> trees) {
                int endPos;
                int startPos;
                if (index >= trees.size()) {
                    return;
                }
                if (trees.size() == 1) {
                    Tree tree = (Tree)Iterables.getOnlyElement(trees);
                    if (!ASTHelpers.hasExplicitSource((Tree)tree, (VisitorState)state)) {
                        return;
                    }
                    this.val$deletions.add(Range.closed((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)tree)), (Comparable)Integer.valueOf(state.getEndPosition(tree))));
                    return;
                }
                if (index >= 1) {
                    startPos = state.getEndPosition(trees.get(index - 1));
                    endPos = state.getEndPosition(trees.get(index));
                } else {
                    startPos = ASTHelpers.getStartPosition((Tree)trees.get(index));
                    endPos = ASTHelpers.getStartPosition((Tree)trees.get(index + 1));
                }
                if (index == methodSymbol.params().size() - 1 && methodSymbol.isVarArgs()) {
                    endPos = state.getEndPosition((Tree)Iterables.getLast(trees));
                }
                if (startPos == -1 || endPos == -1) {
                    return;
                }
                this.val$deletions.add(Range.closed((Comparable)Integer.valueOf(startPos), (Comparable)Integer.valueOf(endPos)));
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        deletions.asRanges().forEach(x -> fix.replace(((Integer)x.lowerEndpoint()).intValue(), ((Integer)x.upperEndpoint()).intValue(), ""));
        return ImmutableList.of((Object)fix.build());
    }

    private static boolean isEnhancedForLoopVar(TreePath variablePath) {
        EnhancedForLoopTree enhancedForLoopTree;
        Tree tree = variablePath.getLeaf();
        Tree parent = variablePath.getParentPath().getLeaf();
        return parent instanceof EnhancedForLoopTree && (enhancedForLoopTree = (EnhancedForLoopTree)parent).getVariable() == tree;
    }

    private boolean exemptedByName(javax.lang.model.element.Name name) {
        String nameString = name.toString();
        String nameStringLower = Ascii.toLowerCase((String)nameString);
        return this.exemptPrefixes.stream().anyMatch(nameStringLower::startsWith) || this.exemptNames.contains((Object)nameString);
    }

    private class VariableFinder
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, TreePath> unusedElements = new HashMap<Symbol, TreePath>();
        private final Set<Symbol> onlyCheckForReassignments = new HashSet<Symbol>();
        private final ListMultimap<Symbol, TreePath> usageSites = ArrayListMultimap.create();
        private final VisitorState state;
        private final ImmutableMultimap<Symbol.MethodSymbol, Symbol.MethodSymbol> superMethodsToOverrides;
        private static final long RECORD_FLAG = 0x2000000000000000L;

        private VariableFinder(VisitorState state, ImmutableMultimap<Symbol.MethodSymbol, Symbol.MethodSymbol> superMethodsToOverrides) {
            this.state = state;
            this.superMethodsToOverrides = superMethodsToOverrides;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            this.handleVariable(variableTree);
            return (Void)super.visitVariable(variableTree, null);
        }

        private void handleVariable(VariableTree variableTree) {
            if (UnusedVariable.this.exemptedByName(variableTree.getName())) {
                return;
            }
            if (UnusedVariable.this.isSuppressed(variableTree, this.state)) {
                return;
            }
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (parent instanceof LambdaExpressionTree) {
                if (FUNCTIONAL_INTERFACE_TYPES_TO_CHECK.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)parent), (Type)this.state.getTypeFromString(t), (VisitorState)this.state))) {
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                }
                return;
            }
            if (symbol.getKind() == ElementKind.FIELD && ((Name)symbol.getSimpleName()).contentEquals("CREATOR") && ASTHelpers.isSubtype((Type)symbol.type, (Type)((Type)PARCELABLE_CREATOR.get(this.state)), (VisitorState)this.state)) {
                return;
            }
            if (symbol.getKind() == ElementKind.FIELD && this.exemptedFieldBySuperType(ASTHelpers.getType((Tree)variableTree), this.state)) {
                return;
            }
            if (UnusedVariable.this.wellKnownKeep.shouldKeep(variableTree)) {
                return;
            }
            switch (symbol.getKind()) {
                case FIELD: {
                    if (!this.isFieldEligibleForChecking(variableTree, symbol)) break;
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                    break;
                }
                case LOCAL_VARIABLE: {
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                    break;
                }
                case BINDING_VARIABLE: {
                    if (!(parent instanceof BindingPatternTree) || !(this.getCurrentPath().getParentPath().getParentPath().getLeaf() instanceof InstanceOfTree)) break;
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                    break;
                }
                case PARAMETER: {
                    if (variableTree.getName().contentEquals("this")) {
                        return;
                    }
                    if (this.hasRecordFlag(symbol.owner)) {
                        return;
                    }
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    if (this.isParameterSubjectToAnalysis(symbol)) break;
                    this.onlyCheckForReassignments.add(symbol);
                    break;
                }
            }
        }

        private boolean exemptedFieldBySuperType(Type type, VisitorState state) {
            return EXEMPTING_FIELD_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)state.getTypeFromString(t), (VisitorState)state));
        }

        private boolean isFieldEligibleForChecking(VariableTree variableTree, Symbol.VarSymbol symbol) {
            if (UnusedVariable.this.reportInjectedFields && variableTree.getModifiers().getFlags().isEmpty() && ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)variableTree, (String)"Inject")) {
                return true;
            }
            if (this.hasRecordFlag(symbol)) {
                return false;
            }
            return ASTHelpers.canBeRemoved((Symbol.VarSymbol)symbol) && !SPECIAL_FIELDS.contains((Object)((Name)symbol.getSimpleName()).toString());
        }

        private boolean hasRecordFlag(Symbol symbol) {
            return (symbol.flags() & 0x2000000000000000L) == 0x2000000000000000L;
        }

        private boolean isParameterSubjectToAnalysis(Symbol sym) {
            Symbol.MethodSymbol methodSymbol;
            Preconditions.checkArgument((sym.getKind() == ElementKind.PARAMETER ? 1 : 0) != 0);
            Symbol enclosingMethod = sym.owner;
            if (!(enclosingMethod instanceof Symbol.MethodSymbol) || ASTHelpers.isAbstract((Symbol.MethodSymbol)(methodSymbol = (Symbol.MethodSymbol)enclosingMethod)) || this.superMethodsToOverrides.containsKey((Object)enclosingMethod)) {
                return false;
            }
            if (UnusedVariable.this.methodAnnotationsExemptingParameters.stream().anyMatch(anno -> ASTHelpers.hasAnnotation((Symbol)enclosingMethod, (String)anno, (VisitorState)this.state))) {
                return false;
            }
            if (ANNOTATIONS_INDICATING_PARAMETERS_SHOULD_BE_CHECKED.stream().anyMatch(a -> ASTHelpers.hasAnnotation((Symbol)enclosingMethod, (String)a, (VisitorState)this.state))) {
                return true;
            }
            if (enclosingMethod.owner instanceof Symbol.ClassSymbol && !ASTHelpers.isAbstract((Symbol.MethodSymbol)methodSymbol)) {
                if (FUNCTIONAL_INTERFACE_TYPES_TO_CHECK.stream().map(arg_0 -> ((VisitorState)this.state).getTypeFromString(arg_0)).anyMatch(t -> ASTHelpers.isSubtype((Type)enclosingMethod.owner.type, (Type)t, (VisitorState)this.state) && this.isFunctionalInterfaceMethod((Type)t, enclosingMethod, this.state))) {
                    return true;
                }
            }
            return ASTHelpers.canBeRemoved((Symbol)enclosingMethod, (VisitorState)this.state);
        }

        private boolean isFunctionalInterfaceMethod(Type functionalInterfaceType, Symbol method, VisitorState state) {
            Symbol functionalInterfaceMethod = state.getTypes().findDescriptorSymbol(functionalInterfaceType.asElement());
            return method.getSimpleName().contentEquals(functionalInterfaceMethod.getSimpleName()) && method.overrides(functionalInterfaceMethod, method.owner.type.tsym, state.getTypes(), true);
        }

        @Override
        public Void visitTry(TryTree node, Void unused) {
            this.scan(node.getBlock(), null);
            this.scan(node.getCatches(), null);
            this.scan(node.getFinallyBlock(), null);
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void unused) {
            if (UnusedVariable.this.isSuppressed(tree, this.state)) {
                return null;
            }
            if (EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)tree), (Type)((Type)Suppliers.typeFromString((String)t).get(this.state)), (VisitorState)this.state))) {
                return null;
            }
            return (Void)super.visitClass(tree, null);
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            if (Matchers.SERIALIZATION_METHODS.matches((Tree)tree, this.state)) {
                return (Void)this.scan(tree.getBody(), null);
            }
            return UnusedVariable.this.isSuppressed(tree, this.state) ? null : (Void)super.visitMethod(tree, null);
        }
    }

    private static final class FilterUsedVariables
    extends TreePathScanner<Void, Void> {
        private boolean leftHandSideAssignment = false;
        private int inArrayAccess = 0;
        private boolean inReturnStatement = false;
        private int inMethodCall = 0;
        private final Map<Symbol, TreePath> assignmentSite = new HashMap<Symbol, TreePath>();
        private TreePath currentExpressionStatement = null;
        private final Map<Symbol, TreePath> unusedElements;
        private final ListMultimap<Symbol, TreePath> usageSites;
        private final Set<Symbol> isEverUsed = new HashSet<Symbol>();
        private final List<UnusedSpec> unusedSpecs = new ArrayList<UnusedSpec>();
        private final ImmutableMap<Symbol, TreePath> declarationSites;

        private FilterUsedVariables(Map<Symbol, TreePath> unusedElements, ListMultimap<Symbol, TreePath> usageSites) {
            this.unusedElements = unusedElements;
            this.usageSites = usageSites;
            this.declarationSites = ImmutableMap.copyOf(unusedElements);
        }

        private boolean isInExpressionStatementTree() {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            return parent instanceof ExpressionStatementTree;
        }

        private boolean isUsed(@Nullable Symbol symbol) {
            return symbol != null && (!this.leftHandSideAssignment || this.inReturnStatement || this.inArrayAccess > 0 || this.inMethodCall > 0) && this.unusedElements.containsKey(symbol);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
            if (this.hasBeenAssigned(tree, symbol)) {
                this.assignmentSite.put(symbol, this.getCurrentPath());
            }
            return (Void)super.visitVariable(tree, null);
        }

        private boolean hasBeenAssigned(VariableTree tree, Symbol.VarSymbol symbol) {
            if (symbol == null) {
                return false;
            }
            if (symbol.getKind() == ElementKind.PARAMETER) {
                return true;
            }
            if (this.getCurrentPath().getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return true;
            }
            return this.unusedElements.containsKey(symbol) && tree.getInitializer() != null;
        }

        @Override
        public Void visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
            this.currentExpressionStatement = this.getCurrentPath();
            super.visitExpressionStatement(tree, null);
            this.currentExpressionStatement = null;
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            }
            if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
            }
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, Void unused) {
            this.scan(tree.getExpression(), null);
            if (this.isInExpressionStatementTree()) {
                this.handleReassignment(tree);
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitAssignment(tree, null);
            }
            return null;
        }

        private void handleReassignment(AssignmentTree tree) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parent instanceof StatementTree)) {
                return;
            }
            if (!(tree.getVariable() instanceof IdentifierTree)) {
                return;
            }
            if (ASTHelpers.findEnclosingNode((TreePath)this.getCurrentPath(), ForLoopTree.class) != null) {
                return;
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree.getVariable());
            if (!(this.assignmentSite.containsKey(symbol) && symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.PARAMETER)) {
                return;
            }
            if (ASTHelpers.getType((Tree)tree.getExpression()) instanceof NullType) {
                return;
            }
            TreePath lastAssignmentSite = this.assignmentSite.get(symbol);
            if (lastAssignmentSite == null) {
                return;
            }
            TreePath declarationSite = (TreePath)this.declarationSites.get((Object)symbol);
            if (declarationSite == null) {
                return;
            }
            if (FilterUsedVariables.scopeDepth(declarationSite) != Iterables.size((Iterable)this.getCurrentPath().getParentPath())) {
                return;
            }
            if (this.unusedElements.containsKey(symbol)) {
                this.unusedSpecs.add(UnusedSpec.of(symbol, lastAssignmentSite, this.usageSites.get((Object)symbol), tree));
            } else {
                this.isEverUsed.add(symbol);
            }
            this.unusedElements.put(symbol, this.getCurrentPath());
            this.usageSites.removeAll((Object)symbol);
            this.usageSites.put((Object)symbol, (Object)this.getCurrentPath().getParentPath());
            this.assignmentSite.put(symbol, this.getCurrentPath().getParentPath());
        }

        private static int scopeDepth(TreePath assignmentSite) {
            VariableTree variableTree;
            Symbol.VarSymbol symbol;
            if (assignmentSite.getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return Iterables.size((Iterable)assignmentSite) + 1;
            }
            Tree tree = assignmentSite.getLeaf();
            if (tree instanceof VariableTree && (symbol = ASTHelpers.getSymbol((VariableTree)(variableTree = (VariableTree)tree))).getKind() == ElementKind.PARAMETER) {
                return Iterables.size((Iterable)assignmentSite) + 1;
            }
            return Iterables.size((Iterable)assignmentSite);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)memberSelectTree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            } else if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
            }
            boolean wasLeftHandAssignment = this.leftHandSideAssignment;
            this.leftHandSideAssignment = false;
            super.visitMemberSelect(memberSelectTree, null);
            this.leftHandSideAssignment = wasLeftHandAssignment;
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
            super.visitMemberReference(tree, null);
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
            symbol.getParameters().forEach(this.unusedElements::remove);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            if (this.isInExpressionStatementTree()) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
                this.scan(tree.getExpression(), null);
            } else {
                super.visitCompoundAssignment(tree, null);
            }
            return null;
        }

        @Override
        public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
            ++this.inArrayAccess;
            super.visitArrayAccess(node, null);
            --this.inArrayAccess;
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree node, Void unused) {
            this.inReturnStatement = true;
            this.scan(node.getExpression(), null);
            this.inReturnStatement = false;
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree tree, Void unused) {
            if (this.isInExpressionStatementTree() && (tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT || tree.getKind() == Tree.Kind.PREFIX_DECREMENT || tree.getKind() == Tree.Kind.PREFIX_INCREMENT)) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getExpression(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitUnary(tree, null);
            }
            return null;
        }

        @Override
        public Void visitErroneous(ErroneousTree tree, Void unused) {
            return (Void)this.scan(tree.getErrorTrees(), null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ++this.inMethodCall;
            super.visitMethodInvocation(tree, null);
            --this.inMethodCall;
            return null;
        }
    }

    private record UnusedSpec(Symbol symbol, TreePath assignmentPath, ImmutableList<TreePath> usageSites, Optional<AssignmentTree> terminatingAssignment) {
        private static UnusedSpec of(Symbol symbol, TreePath assignmentPath, Iterable<TreePath> treePaths, @Nullable AssignmentTree assignmentTree) {
            return new UnusedSpec(symbol, assignmentPath, (ImmutableList<TreePath>)ImmutableList.copyOf(treePaths), Optional.ofNullable(assignmentTree));
        }
    }
}

