/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

@BugPattern(summary="Instance created but never used", severity=BugPattern.SeverityLevel.ERROR)
public class UnusedAnonymousClass
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final ImmutableList<String> TYPES_WITH_SIDE_EFFECT_FREE_CONSTRUCTORS = ImmutableList.of((Object)Thread.class.getName());

    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        if (!(state.getPath().getParentPath().getLeaf() instanceof ExpressionStatementTree)) {
            return Description.NO_MATCH;
        }
        if (newClassTree.getClassBody() == null) {
            return Description.NO_MATCH;
        }
        if (!newClassTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Tree tree : newClassTree.getClassBody().getMembers()) {
            Objects.requireNonNull(tree);
            int n = 0;
            block5: while (true) {
                Tree tree2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableTree.class, BlockTree.class}, (Object)tree2, n)) {
                    case 0: {
                        VariableTree variableTree = (VariableTree)tree2;
                        if (variableTree.getInitializer() == null) {
                            n = 1;
                            continue block5;
                        }
                        return Description.NO_MATCH;
                    }
                    case 1: {
                        BlockTree blockTree = (BlockTree)tree2;
                        return Description.NO_MATCH;
                    }
                }
                break;
            }
        }
        if (!UnusedAnonymousClass.sideEffectFreeConstructor(ASTHelpers.getType((Tree)newClassTree.getIdentifier()).tsym, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(newClassTree);
    }

    private static boolean sideEffectFreeConstructor(Symbol.TypeSymbol classType, VisitorState state) {
        if (classType.isInterface()) {
            return true;
        }
        for (String typeName : TYPES_WITH_SIDE_EFFECT_FREE_CONSTRUCTORS) {
            if (!ASTHelpers.isSameType((Type)classType.type, (Type)state.getTypeFromString(typeName), (VisitorState)state)) continue;
            return true;
        }
        return false;
    }
}

