/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;

@BugPattern(summary="This break is unnecessary, fallthrough does not occur in -> switches", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryBreakInSwitch
extends BugChecker
implements BugChecker.CaseTreeMatcher {
    public Description matchCase(CaseTree tree, VisitorState state) {
        if (!tree.getCaseKind().equals((Object)CaseTree.CaseKind.RULE)) {
            return Description.NO_MATCH;
        }
        Tree body = tree.getBody();
        ImmutableList<BreakTree> unnecessaryBreaks = this.unnecessaryBreaks(body);
        if (unnecessaryBreaks.isEmpty()) {
            return Description.NO_MATCH;
        }
        unnecessaryBreaks.forEach(unnecessaryBreak -> state.reportMatch(this.describeMatch((Tree)unnecessaryBreak, (Fix)SuggestedFix.delete((Tree)unnecessaryBreak))));
        return Description.NO_MATCH;
    }

    private ImmutableList<BreakTree> unnecessaryBreaks(Tree tree) {
        final ImmutableList.Builder result = ImmutableList.builder();
        new SimpleTreeVisitor<Void, Void>(this){

            @Override
            public Void visitBreak(BreakTree node, Void unused) {
                if (node.getLabel() == null) {
                    result.add((Object)node);
                }
                return null;
            }

            @Override
            public Void visitBlock(BlockTree node, Void unused) {
                this.visit((Tree)Iterables.getLast(node.getStatements(), null), null);
                return null;
            }

            @Override
            public Void visitIf(IfTree node, Void unused) {
                this.visit(node.getThenStatement(), null);
                this.visit(node.getElseStatement(), null);
                return null;
            }
        }.visit(tree, null);
        return result.build();
    }
}

