/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.ErrorPronePosition;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.stream.Stream;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="Avoid using non-ASCII Unicode characters outside of comments and literals, as they can be confusing.")
public final class UnicodeInCode
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        TreeRangeSet violations = TreeRangeSet.create();
        String sourceCode = state.getSourceCode().toString();
        for (int i = 0; i < sourceCode.length(); ++i) {
            if (UnicodeInCode.isAcceptableAscii(sourceCode, i)) continue;
            violations.add(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)));
        }
        if (violations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableRangeSet permissibleUnicodeRegions = this.suppressedRegions(state).union(UnicodeInCode.commentsAndLiterals(state, sourceCode));
        for (Range range : violations.asDescendingSetOfRanges()) {
            if (permissibleUnicodeRegions.encloses(range)) continue;
            state.reportMatch(this.buildDescription((ErrorPronePosition)new FixedPosition((Tree)tree, ((Integer)range.lowerEndpoint()).intValue())).setMessage(String.format("Avoid using non-ASCII Unicode character (%s) outside of comments and literals, as they can be confusing.", SourceCodeEscapers.javaCharEscaper().escape(sourceCode.substring((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint())))).build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isAcceptableAscii(String sourceCode, int i) {
        char c = sourceCode.charAt(i);
        if (UnicodeInCode.isAcceptableAscii(c)) {
            return true;
        }
        return c == '\u001a' && i == sourceCode.length() - 1;
    }

    private static boolean isAcceptableAscii(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private static ImmutableRangeSet<Integer> commentsAndLiterals(VisitorState state, String source) {
        ImmutableList tokens = ErrorProneTokens.getTokens((String)source, (Context)state.context);
        return ImmutableRangeSet.unionOf((Iterable)((Iterable)Streams.concat((Stream[])new Stream[]{tokens.stream().filter(t -> t.kind().equals(Tokens.TokenKind.STRINGLITERAL) || t.kind().equals(Tokens.TokenKind.CHARLITERAL)).map(t -> Range.closed((Comparable)Integer.valueOf(t.pos()), (Comparable)Integer.valueOf(t.endPos()))), tokens.stream().flatMap(t -> t.comments().stream()).map(c -> Range.closed((Comparable)Integer.valueOf(c.getSourcePos(0)), (Comparable)Integer.valueOf(c.getSourcePos(0) + c.getText().length())))}).collect(ImmutableList.toImmutableList())));
    }
}

