/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.ErrorPronePosition;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.util.function.Supplier;

@BugPattern(summary="Using unicode escape sequences for printable ASCII characters is obfuscated, and potentially dangerous.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnicodeEscape
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        new UnicodeScanner(state.getSourceCode().toString(), state).scan();
        return Description.NO_MATCH;
    }

    private static boolean isBanned(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r';
    }

    private final class UnicodeScanner {
        private final String source;
        private final VisitorState state;
        private final Supplier<ImmutableRangeSet<Integer>> suppressedRegions = Suppliers.memoize(() -> UnicodeEscape.this.suppressedRegions(this.getState()));
        private int position = 0;
        private char currentCharacter = '\u0000';
        private boolean isUnicode = false;
        private int lastBackslash = 0;

        private UnicodeScanner(String source, VisitorState state) {
            this.source = source;
            this.state = state;
            this.currentCharacter = source.charAt(0);
        }

        void scan() {
            while (this.position < this.source.length()) {
                if (this.isUnicode && UnicodeEscape.isBanned(this.currentCharacter) && (this.currentCharacter != '\\' || this.peek() != 'u') && !this.suppressedRegions.get().contains((Comparable)Integer.valueOf(this.position))) {
                    this.state.reportMatch(UnicodeEscape.this.describeMatch((ErrorPronePosition)new FixedPosition((Tree)this.state.getPath().getCompilationUnit(), this.position), (Fix)SuggestedFix.replace((int)this.lastBackslash, (int)(this.position + 1), (String)Character.toString(this.currentCharacter))));
                }
                this.processCharacter();
            }
        }

        private void processCharacter() {
            if (this.currentCharacter == '\\') {
                this.lastBackslash = this.position;
                this.nextCharacter();
                if (this.currentCharacter == 'u' && !this.isUnicode) {
                    do {
                        this.nextCharacter();
                    } while (this.currentCharacter == 'u');
                    this.currentCharacter = (char)Integer.parseInt(this.source.substring(this.position, this.position + 4), 16);
                    this.position += 3;
                    this.isUnicode = true;
                    return;
                }
            }
            this.nextCharacter();
            this.isUnicode = false;
        }

        private void nextCharacter() {
            ++this.position;
            if (this.position < this.source.length()) {
                this.currentCharacter = this.source.charAt(this.position);
            }
        }

        private char peek() {
            return this.position + 1 < this.source.length() ? this.source.charAt(this.position + 1) : (char)'\u0000';
        }

        private VisitorState getState() {
            return this.state;
        }
    }
}

