/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Base exception classes should be treated as abstract. If the exception is intended to be caught, throw a domain-specific exception. Otherwise, prefer a more specific exception for clarity. Common alternatives include: AssertionError, IllegalArgumentException, IllegalStateException, and (Guava's) VerifyException.", explanation="1. Defensive coding: Using a generic exception would force a caller that wishes to catch it to potentially catch unrelated exceptions as well.\n\n2. Clarity: Base exception classes offer no information on the nature of the failure.", severity=BugPattern.SeverityLevel.WARNING)
public final class ThrowSpecificExceptions
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final ImmutableList<AbstractLikeException> ABSTRACT_LIKE_EXCEPTIONS = ImmutableList.of((Object)AbstractLikeException.of(RuntimeException.class, VerifyException.class), (Object)AbstractLikeException.of(Throwable.class, AssertionError.class), (Object)AbstractLikeException.of(Error.class, AssertionError.class));

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (tree.getClassBody() != null || !(state.getPath().getParentPath().getLeaf() instanceof ThrowTree) || state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        for (AbstractLikeException abstractLikeException : ABSTRACT_LIKE_EXCEPTIONS) {
            if (!abstractLikeException.matcher().matches((Tree)tree, state)) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String className = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)abstractLikeException.replacement());
            return this.describeMatch(tree, (Fix)fix.replace((Tree)tree.getIdentifier(), className).build());
        }
        return Description.NO_MATCH;
    }

    private record AbstractLikeException(Matcher<ExpressionTree> matcher, String replacement) {
        static AbstractLikeException of(Class<?> abstractLikeException, Class<?> replacement) {
            return new AbstractLikeException((Matcher<ExpressionTree>)Matchers.constructor().forClass(abstractLikeException.getName()), replacement.getName());
        }
    }
}

