/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(summary="String.join(CharSequence) performs no joining (it always returns the empty string); String.join(CharSequence, CharSequence) performs no joining (it just returns the 2nd parameter).", severity=BugPattern.SeverityLevel.ERROR)
public final class StringJoin
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.staticMethod().onClass("java.lang.String").named("join");
    private static final Supplier<Type> CHAR_SEQUENCE_TYPE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.CharSequence"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (MATCHER.matches((Tree)tree, state)) {
            ExpressionTree arg1;
            if (tree.getArguments().size() == 1) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)"\"\""));
            }
            if (tree.getArguments().size() == 2 && ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)(arg1 = tree.getArguments().get(1))), (Type)((Type)CHAR_SEQUENCE_TYPE.get(state)), (VisitorState)state)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)arg1)));
            }
        }
        return Description.NO_MATCH;
    }
}

