/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(summary="@Mock members of test classes shouldn't share state between tests and preferably be non-static", severity=BugPattern.SeverityLevel.WARNING)
public final class StaticMockMember
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<Tree> STATIC_MOCK = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.STATIC), Matchers.hasAnnotation((String)"org.mockito.Mock")});

    public Description matchVariable(VariableTree varTree, VisitorState state) {
        if (!STATIC_MOCK.matches((Tree)varTree, state)) {
            return Description.NO_MATCH;
        }
        Optional optionalFix = SuggestedFixes.removeModifiers((Tree)varTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC});
        if (optionalFix.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (SuggestedFixes.compilesWithFix((Fix)((Fix)optionalFix.get()), (VisitorState)state)) {
            return this.describeMatch(varTree, (Fix)optionalFix.get());
        }
        return this.describeMatch(varTree);
    }
}

