/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.regex.Pattern;

@BugPattern(summary="Setting a proto field to an UNRECOGNIZED value will result in an exception at runtime when building.", severity=BugPattern.SeverityLevel.ERROR)
public final class SetUnrecognized
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IS_PROTO_SETTER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").withNameMatching(Pattern.compile("(add|set).*"));
    private static final Supplier<Type> ENUM_LITE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.Internal.EnumLite"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!IS_PROTO_SETTER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        Symbol argSymbol = ASTHelpers.getSymbol((Tree)arg);
        if (argSymbol == null) {
            return Description.NO_MATCH;
        }
        if (!argSymbol.getSimpleName().contentEquals("UNRECOGNIZED")) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSubtype((Type)argSymbol.owner.type, (Type)((Type)ENUM_LITE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

