/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This type name shadows another in a way that may be confusing.", severity=BugPattern.SeverityLevel.WARNING)
public final class SameNameButDifferent
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final Boolean batchFindings;

    @Inject
    SameNameButDifferent(ErrorProneFlags flags) {
        this.batchFindings = flags.getBoolean("SameNameButDifferent:BatchFindings").orElse(false);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        HashBasedTable table = HashBasedTable.create();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state, (Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
                super((BugChecker)this$0, state);
            }

            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                if (!this.shouldIgnore()) {
                    this.handle(memberSelectTree);
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                if (this.shouldIgnore()) {
                    return null;
                }
                if (!(ASTHelpers.getSymbol((Tree)identifierTree) instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                TreePath enclosingClass = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)this.getCurrentPath(), ClassTree.class);
                if (enclosingClass != null && ASTHelpers.getSymbol((Tree)enclosingClass.getLeaf()) == ASTHelpers.getSymbol((Tree)identifierTree)) {
                    return null;
                }
                this.handle(identifierTree);
                return null;
            }

            private boolean shouldIgnore() {
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                return parentTree instanceof MemberSelectTree && ASTHelpers.getSymbol((Tree)parentTree) instanceof Symbol.ClassSymbol;
            }

            private @Nullable String qualifiedName(Tree tree) {
                if (this.state.getEndPosition(tree) == -1) {
                    return null;
                }
                ArrayDeque<Name> parts = new ArrayDeque<Name>();
                while (tree instanceof MemberSelectTree) {
                    MemberSelectTree select = (MemberSelectTree)tree;
                    parts.addFirst(select.getIdentifier());
                    tree = select.getExpression();
                }
                if (!(tree instanceof IdentifierTree)) {
                    return null;
                }
                IdentifierTree identifierTree = (IdentifierTree)tree;
                parts.addFirst(identifierTree.getName());
                return Joiner.on((char)'.').join(parts);
            }

            private void handle(Tree tree) {
                IdentifierTree identifierTree;
                if (tree instanceof IdentifierTree && (identifierTree = (IdentifierTree)tree).getName().contentEquals("Builder")) {
                    return;
                }
                String qualifiedName = this.qualifiedName(tree);
                if (qualifiedName == null) {
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.ClassSymbol) {
                    ArrayList<TreePath> treePaths = (ArrayList<TreePath>)this.val$table.get((Object)qualifiedName, (Object)symbol.type.tsym);
                    if (treePaths == null) {
                        treePaths = new ArrayList<TreePath>();
                        this.val$table.put((Object)qualifiedName, (Object)symbol.type.tsym, treePaths);
                    }
                    treePaths.add(this.getCurrentPath());
                }
            }
        }.scan(state.getPath(), null);
        HashBasedTable trimmedTable = HashBasedTable.create();
        for (Map.Entry row : table.rowMap().entrySet()) {
            Map columns = (Map)row.getValue();
            if (columns.size() <= 1) continue;
            for (Map.Entry cell : columns.entrySet()) {
                if (!((List)cell.getValue()).stream().anyMatch(treePath -> SameNameButDifferent.shadowsClass(state, treePath))) continue;
                trimmedTable.put((Object)((String)row.getKey()), (Object)((Symbol.TypeSymbol)cell.getKey()), (Object)((List)cell.getValue()));
            }
        }
        for (Map.Entry row : trimmedTable.rowMap().entrySet()) {
            String simpleName = (String)row.getKey();
            Map columns = (Map)row.getValue();
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            if (columns.size() <= 1) continue;
            for (Map.Entry cell : columns.entrySet()) {
                for (TreePath treePath2 : (List)cell.getValue()) {
                    Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)cell.getKey();
                    SameNameButDifferent.getBetterImport(typeSymbol, simpleName).ifPresent(imp -> {
                        String qualifiedName = SameNameButDifferent.qualifyType(state.withPath(treePath2), fixBuilder, imp);
                        String newSimpleName = qualifiedName + "." + simpleName;
                        fixBuilder.replace(treePath2.getLeaf(), newSimpleName);
                    });
                }
            }
            String message = String.format("The name `%s` refers to %s within this file. It may be confusing to have the same name refer to multiple types. Consider qualifying them for clarity.", simpleName, columns.keySet().stream().map(t -> t.getQualifiedName().toString()).collect(Collectors.joining(", ", "[", "]")));
            SuggestedFix fix = fixBuilder.build();
            trimmedTable.row((Object)simpleName).values().stream().flatMap(Collection::stream).limit(this.batchFindings != false ? 1L : Long.MAX_VALUE).forEach(treePath -> state.reportMatch(this.buildDescription(treePath.getLeaf()).setMessage(message).addFix((Fix)fix).build()));
        }
        return Description.NO_MATCH;
    }

    private static boolean shadowsClass(VisitorState state, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        if (!(tree instanceof IdentifierTree)) {
            return true;
        }
        IdentifierTree identifierTree = (IdentifierTree)tree;
        TreePath enclosingClass = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)treePath, ClassTree.class);
        String name = identifierTree.getName().toString();
        return FindIdentifiers.findIdent((String)name, (VisitorState)state.withPath(enclosingClass), (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP) != null;
    }

    private static Optional<Symbol> getBetterImport(Symbol.TypeSymbol classSymbol, String simpleName) {
        Symbol owner = classSymbol;
        long dots = simpleName.chars().filter(c -> c == 46).count();
        for (long i = 0L; i < dots + 1L; ++i) {
            if (owner == null) {
                return Optional.empty();
            }
            owner = owner.owner;
        }
        if (owner instanceof Symbol.ClassSymbol) {
            return Optional.of(owner);
        }
        return Optional.empty();
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, Symbol sym) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        Symbol curr = sym;
        while (curr != null) {
            names.addFirst(curr.getSimpleName().toString());
            Symbol found = FindIdentifiers.findIdent((String)curr.getSimpleName().toString(), (VisitorState)state, (Kinds.KindSelector)Kinds.KindSelector.VAL_TYP);
            if (found == curr) break;
            if (curr.getKind() == ElementKind.PACKAGE) {
                return sym.getQualifiedName().toString();
            }
            if (found == null) {
                fix.addImport(curr.getQualifiedName().toString());
                break;
            }
            curr = curr.owner;
        }
        return Joiner.on((char)'.').join(names);
    }
}

