/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="A field was set twice in the same chained expression.", severity=BugPattern.SeverityLevel.ERROR, altNames={"ProtoRedundantSet"}, tags={"FragileCode"})
public final class RedundantSetterCall
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FLUENT_SETTER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.protobuf.GeneratedMessage.Builder", "com.google.protobuf.GeneratedMessageLite.Builder"}).withNameMatching(Pattern.compile("^(set|add|clear|put).+")), (Matcher & Serializable)(tree, state) -> {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
        return ASTHelpers.isAbstract((Symbol.MethodSymbol)symbol) && RedundantSetterCall.isWithinAutoValueBuilder(symbol, state) && ASTHelpers.isSameType((Type)symbol.owner.type, (Type)symbol.getReturnType(), (VisitorState)state);
    }});
    private static final TypePredicate ONE_OF_ENUM = TypePredicates.isDescendantOf((String)"com.google.protobuf.AbstractMessageLite.InternalOneOfEnum");
    private static final Matcher<ExpressionTree> TERMINAL_FLUENT_SETTER = Matchers.allOf((Matcher[])new Matcher[]{FLUENT_SETTER, (Matcher & Serializable)(tree, state) -> !(state.getPath().getParentPath().getLeaf() instanceof MemberSelectTree) || !FLUENT_SETTER.matches((Tree)((ExpressionTree)state.getPath().getParentPath().getParentPath().getLeaf()), state)});
    private final boolean improvements;
    private static final Supplier<Type> MESSAGE_LITE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.MessageLite"));

    @Inject
    RedundantSetterCall(ErrorProneFlags flags) {
        this.improvements = flags.getBoolean("RedundantSetterCall:Improvements").orElse(true);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!TERMINAL_FLUENT_SETTER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol owner = ASTHelpers.getUpperBound((Type)ASTHelpers.getType((Tree)tree), (Types)state.getTypes()).tsym.owner;
        boolean isProto = owner != null && ASTHelpers.isSubtype((Type)owner.type, (Type)((Type)MESSAGE_LITE.get(state)), (VisitorState)state);
        ArrayListMultimap setters = ArrayListMultimap.create();
        ImmutableMap<String, OneOfField> oneOfSetters = isProto ? this.scanForOneOfSetters(owner, state) : ImmutableMap.of();
        ImmutableSet<String> fieldNames = isProto ? RedundantSetterCall.getFields(owner) : ImmutableSet.of();
        Type type = ASTHelpers.getReturnType((ExpressionTree)tree);
        ExpressionTree current = tree;
        while (FLUENT_SETTER.matches((Tree)current, state)) {
            String withoutSet;
            String methodName;
            Symbol symbol;
            MethodInvocationTree method = current;
            if (!ASTHelpers.isSameType((Type)type, (Type)ASTHelpers.getReturnType((ExpressionTree)current), (VisitorState)state) || !((symbol = ASTHelpers.getSymbol((Tree)current)) instanceof Symbol.MethodSymbol) || (methodName = symbol.getSimpleName().toString()).endsWith("Builder")) break;
            if (this.improvements && isProto && methodName.startsWith("set") && !fieldNames.contains((Object)Ascii.toUpperCase((String)(withoutSet = methodName.replaceFirst("^set", ""))))) {
                if (methodName.endsWith("Value")) {
                    methodName = methodName.replaceFirst("Value$", "");
                }
                if (methodName.endsWith("Bytes")) {
                    methodName = methodName.replaceFirst("Bytes$", "");
                }
            }
            for (FieldType fieldType : FieldType.values()) {
                FieldWithValue match = fieldType.match(methodName, method, state);
                if (match == null) continue;
                setters.put((Object)match.field(), (Object)match);
                if (!oneOfSetters.containsKey((Object)methodName)) continue;
                setters.put((Object)((Field)oneOfSetters.get((Object)methodName)), (Object)match);
            }
            current = ASTHelpers.getReceiver((ExpressionTree)current);
        }
        setters.asMap().entrySet().removeIf(entry -> ((Collection)entry.getValue()).size() <= 1);
        if (setters.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Map.Entry entry2 : setters.asMap().entrySet()) {
            Field field = (Field)entry2.getKey();
            Collection values = (Collection)entry2.getValue();
            state.reportMatch(this.describe(field, values, state));
        }
        return Description.NO_MATCH;
    }

    private ImmutableMap<String, OneOfField> scanForOneOfSetters(Symbol proto, VisitorState state) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Symbol element : ASTHelpers.getEnclosedElements((Symbol)proto)) {
            if (!ONE_OF_ENUM.apply(element.type, state)) continue;
            OneOfField oneOfField = new OneOfField(element.getSimpleName().toString().replaceFirst("Case$", ""));
            for (String enumName : ASTHelpers.enumValues((Symbol.TypeSymbol)element.type.tsym)) {
                if (enumName.equals("ONEOF_NOT_SET")) continue;
                builder.put((Object)("set" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumName)), (Object)oneOfField);
            }
        }
        return builder.buildOrThrow();
    }

    private static ImmutableSet<String> getFields(Symbol proto) {
        return (ImmutableSet)ASTHelpers.getEnclosedElements((Symbol)proto).stream().map(element -> element.getSimpleName().toString()).filter(name -> name.endsWith("_FIELD_NUMBER")).map(name -> Ascii.toUpperCase((String)name.replaceFirst("_FIELD_NUMBER$", "").replace("_", ""))).collect(ImmutableSet.toImmutableSet());
    }

    private Description describe(Field field, Collection<FieldWithValue> locations, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        long values = locations.stream().map(l -> state.getSourceForNode((Tree)l.argument())).distinct().count();
        if (field.identicalValuesShouldBeRemoved() && values == 1L) {
            for (FieldWithValue fieldWithValue : Iterables.skip(locations, (int)1)) {
                MethodInvocationTree method = fieldWithValue.methodInvocation();
                int startPos = state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)method));
                int endPos = state.getEndPosition((Tree)method);
                fix.replace(startPos, endPos, "");
            }
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = field.toString(locations);
        objectArray[1] = RedundantSetterCall.nTimes(locations.size());
        objectArray[2] = field.identicalValuesShouldBeRemoved() ? (values == 1L ? " with the same argument" : " with different arguments") : "";
        return this.buildDescription(locations.iterator().next().argument()).setMessage(String.format("%s was called %s%s. Setting the same field multiple times is redundant, and could mask a bug.", objectArray)).addFix((Fix)fix.build()).build();
    }

    private static String nTimes(int n) {
        return n == 2 ? "twice" : String.format("%d times", n);
    }

    private static boolean isWithinAutoValueBuilder(Symbol.MethodSymbol symbol, VisitorState state) {
        return ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)"com.google.auto.value.AutoValue.Builder", (VisitorState)state);
    }

    static enum FieldType {
        SINGLE{

            @Override
            @Nullable FieldWithValue match(String name, MethodInvocationTree tree, VisitorState state) {
                if ((name.startsWith("set") || RedundantSetterCall.isWithinAutoValueBuilder(ASTHelpers.getSymbol((MethodInvocationTree)tree), state)) && tree.getArguments().size() == 1) {
                    SingleField field = new SingleField(name);
                    return new FieldWithValue(field, tree, tree.getArguments().get(0));
                }
                return null;
            }
        }
        ,
        REPEATED{

            @Override
            @Nullable FieldWithValue match(String name, MethodInvocationTree tree, VisitorState state) {
                Integer index;
                if (name.startsWith("set") && tree.getArguments().size() == 2 && (index = (Integer)ASTHelpers.constValue((Tree)tree.getArguments().get(0), Integer.class)) != null) {
                    RepeatedField field = new RepeatedField(name, index);
                    return new FieldWithValue(field, tree, tree.getArguments().get(1));
                }
                return null;
            }
        }
        ,
        MAP{

            @Override
            @Nullable FieldWithValue match(String name, MethodInvocationTree tree, VisitorState state) {
                Object key;
                if (name.startsWith("put") && tree.getArguments().size() == 2 && (key = ASTHelpers.constValue((Tree)tree.getArguments().get(0), Object.class)) != null) {
                    MapField field = new MapField(name, key);
                    return new FieldWithValue(field, tree, tree.getArguments().get(1));
                }
                return null;
            }
        };


        abstract FieldWithValue match(String var1, MethodInvocationTree var2, VisitorState var3);
    }

    record FieldWithValue(Field field, MethodInvocationTree methodInvocation, ExpressionTree argument) {
    }

    static interface Field {
        public boolean equals(@Nullable Object var1);

        public int hashCode();

        public boolean identicalValuesShouldBeRemoved();

        public String toString(Iterable<FieldWithValue> var1);
    }

    record OneOfField(String oneOfName) implements Field
    {
        @Override
        public final String toString(Iterable<FieldWithValue> locations) {
            return String.format("The oneof `%s` (set via %s)", this.oneOfName(), Streams.stream(locations).map(l -> ((Name)ASTHelpers.getSymbol((MethodInvocationTree)l.methodInvocation()).getSimpleName()).toString()).distinct().sorted().collect(Collectors.joining(", ")));
        }

        @Override
        public boolean identicalValuesShouldBeRemoved() {
            return false;
        }
    }

    record MapField(String name, Object key) implements Field
    {
        @Override
        public final String toString(Iterable<FieldWithValue> locations) {
            return String.format("%s(%s, ..)", this.name(), this.key());
        }

        @Override
        public boolean identicalValuesShouldBeRemoved() {
            return true;
        }
    }

    record RepeatedField(String name, int index) implements Field
    {
        @Override
        public final String toString(Iterable<FieldWithValue> locations) {
            return String.format("%s(%s, ..)", this.name(), this.index());
        }

        @Override
        public boolean identicalValuesShouldBeRemoved() {
            return true;
        }
    }

    record SingleField(String name) implements Field
    {
        @Override
        public final String toString(Iterable<FieldWithValue> locations) {
            return String.format("%s(..)", this.name());
        }

        @Override
        public boolean identicalValuesShouldBeRemoved() {
            return true;
        }
    }
}

