/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.IdentifierNames;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.google.errorprone.util.SourceVersion;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This code can be simplified to use a pattern-matching instanceof.")
public final class PatternMatchingInstanceof
extends BugChecker
implements BugChecker.InstanceOfTreeMatcher {
    private final ConstantExpressions constantExpressions;

    @Inject
    PatternMatchingInstanceof(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchInstanceOf(InstanceOfTree instanceOfTree, VisitorState state) {
        if (!SourceVersion.supportsPatternMatchingInstanceof((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (instanceOfTree.getPattern() != null) {
            return Description.NO_MATCH;
        }
        ImmutableList<Tree> impliedStatements = PatternMatchingInstanceof.findImpliedStatements(instanceOfTree, state);
        if (impliedStatements.isEmpty()) {
            return Description.NO_MATCH;
        }
        ConstantExpressions.ConstantExpression constant = this.constantExpressions.constantExpression(instanceOfTree.getExpression(), state).orElse(null);
        if (constant == null) {
            return Description.NO_MATCH;
        }
        Type targetType = ASTHelpers.getType((Tree)instanceOfTree.getType());
        HashSet<TreePath> allCasts = new HashSet<TreePath>((Collection<TreePath>)this.findAllCasts(constant, (Iterable<Tree>)impliedStatements, targetType, state));
        String name = null;
        SuggestedFix.Builder fix = SuggestedFix.builder();
        int typeArgCount = ASTHelpers.getType((Tree)instanceOfTree.getType()).tsym.getTypeParameters().size();
        if (typeArgCount != 0 && allCasts.stream().flatMap(c -> Stream.ofNullable(TargetType.targetType((VisitorState)state.withPath(c)))).anyMatch(t -> !t.type().isRaw())) {
            return Description.NO_MATCH;
        }
        for (TreePath cast : allCasts) {
            VariableTree variableTree = PatternMatchingInstanceof.isVariableAssignedFromCast(cast, instanceOfTree, state);
            if (variableTree == null) continue;
            allCasts.remove(cast);
            fix.delete((Tree)variableTree);
            name = variableTree.getName().toString();
            break;
        }
        if (!allCasts.isEmpty() || !fix.isEmpty()) {
            if (name == null) {
                name = PatternMatchingInstanceof.generateVariableName(targetType, state);
            }
            if (typeArgCount != 0 && !(instanceOfTree.getType() instanceof ParameterizedTypeTree)) {
                fix.postfixWith(instanceOfTree.getType(), Collections.nCopies(typeArgCount, "?").stream().collect(Collectors.joining(",", "<", ">")));
            }
            String fn = name;
            return this.describeMatch(instanceOfTree, (Fix)fix.postfixWith((Tree)instanceOfTree, " " + name).merge((SuggestedFix)allCasts.stream().map(c -> SuggestedFix.replace((Tree)c.getLeaf(), (String)fn)).collect(SuggestedFix.mergeFixes())).build());
        }
        return Description.NO_MATCH;
    }

    private static @Nullable VariableTree isVariableAssignedFromCast(TreePath treePath, InstanceOfTree instanceOfTree, VisitorState state) {
        Tree parent = Streams.stream((Iterable)treePath.getParentPath()).dropWhile(t -> t.getKind() == Tree.Kind.PARENTHESIZED).findFirst().orElse(null);
        if (!(parent instanceof VariableTree)) {
            return null;
        }
        VariableTree variableTree = (VariableTree)parent;
        if (!state.getTypes().isSameType(ASTHelpers.getType((Tree)instanceOfTree.getType()), ASTHelpers.getType((Tree)variableTree.getType()))) {
            return null;
        }
        return variableTree;
    }

    private static String generateVariableName(Type targetType, VisitorState state) {
        Type unboxed = state.getTypes().unboxedType(targetType);
        String simpleName = IdentifierNames.fixInitialisms(((Name)targetType.tsym.getSimpleName()).toString());
        String lowerFirstLetter = Ascii.toLowerCase((String)String.valueOf(simpleName.charAt(0)));
        String camelCased = lowerFirstLetter + simpleName.substring(1);
        if (javax.lang.model.SourceVersion.isKeyword(camelCased) || unboxed != null && unboxed.getTag() != TypeTag.NONE) {
            return lowerFirstLetter;
        }
        return camelCased;
    }

    private static ImmutableList<Tree> findImpliedStatements(InstanceOfTree tree, VisitorState state) {
        Tree last = tree;
        boolean negated = false;
        ImmutableList.Builder impliedStatements = ImmutableList.builder();
        for (TreePath parentPath = state.getPath().getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
            Tree parent = parentPath.getLeaf();
            switch (parent.getKind()) {
                case CONDITIONAL_AND: {
                    if (negated) {
                        return impliedStatements.build();
                    }
                    if (((BinaryTree)parent).getLeftOperand() != last) break;
                    impliedStatements.add((Object)((BinaryTree)parent).getRightOperand());
                    break;
                }
                case CONDITIONAL_OR: {
                    if (!negated) {
                        return impliedStatements.build();
                    }
                    if (((BinaryTree)parent).getLeftOperand() != last) break;
                    impliedStatements.add((Object)((BinaryTree)parent).getRightOperand());
                    break;
                }
                case PARENTHESIZED: {
                    break;
                }
                case LOGICAL_COMPLEMENT: {
                    negated = !negated;
                    break;
                }
                case IF: {
                    Tree tree2;
                    StatementTree negativeBranch;
                    StatementTree positiveBranch;
                    IfTree ifTree = (IfTree)parent;
                    if (ifTree.getCondition() != last) {
                        return impliedStatements.build();
                    }
                    StatementTree statementTree = positiveBranch = negated ? ifTree.getElseStatement() : ifTree.getThenStatement();
                    if (positiveBranch != null) {
                        impliedStatements.add((Object)positiveBranch);
                    }
                    StatementTree statementTree2 = negativeBranch = negated ? ifTree.getThenStatement() : ifTree.getElseStatement();
                    if (negativeBranch != null && !Reachability.canCompleteNormally((StatementTree)negativeBranch) && (tree2 = parentPath.getParentPath().getLeaf()) instanceof BlockTree) {
                        BlockTree blockTree = (BlockTree)tree2;
                        int index = blockTree.getStatements().indexOf(ifTree);
                        impliedStatements.addAll(blockTree.getStatements().subList(index + 1, blockTree.getStatements().size()));
                    }
                    return impliedStatements.build();
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpression = (ConditionalExpressionTree)parent;
                    impliedStatements.add((Object)(negated ? conditionalExpression.getFalseExpression() : conditionalExpression.getTrueExpression()));
                    return impliedStatements.build();
                }
                default: {
                    return impliedStatements.build();
                }
            }
            last = parent;
        }
        return impliedStatements.build();
    }

    private ImmutableSet<TreePath> findAllCasts(final ConstantExpressions.ConstantExpression symbol, Iterable<Tree> trees, final Type targetType, final VisitorState state) {
        final ImmutableSet.Builder usages = ImmutableSet.builder();
        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(this){
            final /* synthetic */ PatternMatchingInstanceof this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitTypeCast(TypeCastTree node, Void unused) {
                Optional<ConstantExpressions.ConstantExpression> castee = this.this$0.constantExpressions.constantExpression(node.getExpression(), state);
                if (castee.isPresent() && castee.get().equals(symbol) && state.getTypes().isSameType(ASTHelpers.getType((Tree)node.getType()), targetType)) {
                    usages.add((Object)PatternMatchingInstanceof.getUsage(this.getCurrentPath()));
                }
                return (Void)super.visitTypeCast(node, null);
            }
        };
        for (Tree tree : trees) {
            scanner.scan(new TreePath(state.getPath(), tree), (Void)null);
        }
        return usages.build();
    }

    private static TreePath getUsage(TreePath currentPath) {
        TreePath parentPath = currentPath.getParentPath();
        return parentPath.getLeaf() instanceof ParenthesizedTree && !PatternMatchingInstanceof.requiresParentheses(parentPath) ? parentPath : currentPath;
    }

    private static boolean requiresParentheses(TreePath path) {
        return switch (path.getParentPath().getLeaf().getKind()) {
            case Tree.Kind.PARENTHESIZED, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.ARRAY_ACCESS, Tree.Kind.NEW_CLASS, Tree.Kind.MEMBER_REFERENCE -> false;
            default -> true;
        };
    }
}

