/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;

@BugPattern(summary="This Optional has been confirmed to be empty at this point, so the call to `get()` or `orElseThrow()` will always throw.", severity=BugPattern.SeverityLevel.WARNING)
public final class OptionalNotPresent
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> OPTIONAL_GET = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.base.Optional").named("get"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Optional").namedAnyOf(new String[]{"get", "orElseThrow"})});
    private final ConstantExpressions constantExpressions;

    @Inject
    OptionalNotPresent(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        new IfScanner(state).scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private final class IfScanner
    extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
        private final Multiset<ConstantExpressions.ConstantExpression> truths;
        private final Multiset<ConstantExpressions.ConstantExpression> falsehoods;
        private final VisitorState state;

        private IfScanner(VisitorState state) {
            super((BugChecker)OptionalNotPresent.this, state);
            this.truths = HashMultiset.create();
            this.falsehoods = HashMultiset.create();
            this.state = state;
        }

        public Void visitIf(IfTree tree, Void unused) {
            this.withinScope(OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), false, this.state), tree.getThenStatement());
            this.withinScope(OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), true, this.state), tree.getElseStatement());
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
            this.withinScope(OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), false, this.state), tree.getTrueExpression());
            this.withinScope(OptionalNotPresent.this.constantExpressions.truthiness(tree.getCondition(), true, this.state), tree.getFalseExpression());
            return null;
        }

        private void withinScope(ConstantExpressions.Truthiness truthiness, Tree tree) {
            this.truths.addAll(truthiness.requiredTrue());
            this.falsehoods.addAll(truthiness.requiredFalse());
            this.scan(tree, null);
            Multisets.removeOccurrences(this.truths, truthiness.requiredTrue());
            Multisets.removeOccurrences(this.falsehoods, truthiness.requiredFalse());
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ExpressionTree receiver;
            if (OPTIONAL_GET.matches((Tree)tree, this.state) && (receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) != null) {
                OptionalNotPresent.this.constantExpressions.constantExpression(receiver, this.state).ifPresent(o -> this.checkForEmptiness(tree, (ConstantExpressions.ConstantExpression)o));
            }
            return (Void)super.visitMethodInvocation(tree, null);
        }

        private void checkForEmptiness(MethodInvocationTree tree, ConstantExpressions.ConstantExpression constantExpression) {
            block3: {
                block2: {
                    if (this.getMethodInvocations(this.truths).filter(truth -> truth.symbol() instanceof Symbol.MethodSymbol && truth.symbol().getSimpleName().contentEquals("isEmpty")).flatMap(truth -> truth.receiver().stream()).anyMatch((Predicate<ConstantExpressions.ConstantExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/google/errorprone/bugpatterns/threadsafety/ConstantExpressions$ConstantExpression;)Z)((ConstantExpressions.ConstantExpression)constantExpression))) break block2;
                    if (!this.getMethodInvocations(this.falsehoods).filter(truth -> truth.symbol() instanceof Symbol.MethodSymbol && truth.symbol().getSimpleName().contentEquals("isPresent")).flatMap(truth -> truth.receiver().stream()).anyMatch((Predicate<ConstantExpressions.ConstantExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/google/errorprone/bugpatterns/threadsafety/ConstantExpressions$ConstantExpression;)Z)((ConstantExpressions.ConstantExpression)constantExpression))) break block3;
                }
                this.state.reportMatch(OptionalNotPresent.this.describeMatch(tree));
            }
        }

        private Stream<ConstantExpressions.ConstantExpression.PureMethodInvocation> getMethodInvocations(Multiset<ConstantExpressions.ConstantExpression> truths) {
            return truths.stream().flatMap(ce -> {
                Stream<Object> stream;
                if (ce instanceof ConstantExpressions.ConstantExpression.PureMethodInvocation) {
                    ConstantExpressions.ConstantExpression.PureMethodInvocation pmi = (ConstantExpressions.ConstantExpression.PureMethodInvocation)ce;
                    stream = Stream.of(pmi);
                } else {
                    stream = Stream.empty();
                }
                return stream;
            });
        }
    }
}

