/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="void-returning methods should not be annotated with nullness annotations, since they cannot return null", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class NullableVoid
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym.getReturnType().getKind() != TypeKind.VOID) {
            return Description.NO_MATCH;
        }
        ImmutableList relevantAnnos = NullnessAnnotations.annotationsRelevantToNullness(tree.getModifiers().getAnnotations());
        if (relevantAnnos.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        relevantAnnos.forEach(arg_0 -> ((SuggestedFix.Builder)fix).delete(arg_0));
        return this.describeMatch((Tree)relevantAnnos.getFirst(), (Fix)fix.build());
    }
}

