/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Visibility;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This type is referred to by a non-canonical name, which may be misleading.", severity=BugPattern.SeverityLevel.WARNING)
public final class NonCanonicalType
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final Pattern PACKAGE_CLASS_NAME_SPLITTER = Pattern.compile("(.*?)\\.([A-Z].*)");

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (state.getPath().getParentPath().getLeaf() instanceof MemberSelectTree) {
            return Description.NO_MATCH;
        }
        String canonicalName = NonCanonicalType.canonicalName(tree);
        if (canonicalName == null) {
            return Description.NO_MATCH;
        }
        if (canonicalName.contains("$")) {
            return Description.NO_MATCH;
        }
        String nonCanonicalName = NonCanonicalType.getNonCanonicalName(tree);
        if (canonicalName.equals(nonCanonicalName)) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        while (symbol != null) {
            if (!Visibility.fromModifiers(symbol.getModifiers()).shouldBeVisible((Tree)tree, state)) {
                return Description.NO_MATCH;
            }
            symbol = ASTHelpers.enclosingClass((Symbol)symbol);
        }
        if (!ASTHelpers.hasExplicitSource((Tree)tree, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFix fix = fixBuilder.replace((Tree)tree, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)canonicalName)).build();
        return this.buildDescription(tree).setMessage(NonCanonicalType.createDescription(canonicalName, nonCanonicalName)).addFix((Fix)fix).build();
    }

    private static @Nullable String canonicalName(MemberSelectTree tree) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return null;
        }
        if (!(sym instanceof Symbol.TypeSymbol)) {
            return null;
        }
        Symbol owner = sym.owner;
        if (owner == null) {
            return null;
        }
        return String.valueOf(owner.getQualifiedName()) + "." + String.valueOf(sym.getSimpleName());
    }

    private static String createDescription(String canonicalName, String nonCanonicalName) {
        Matcher canonicalNameMatcher = PACKAGE_CLASS_NAME_SPLITTER.matcher(canonicalName);
        Matcher nonCanonicalNameMatcher = PACKAGE_CLASS_NAME_SPLITTER.matcher(nonCanonicalName);
        if (canonicalNameMatcher.matches() && nonCanonicalNameMatcher.matches() && !canonicalNameMatcher.group(2).equals(nonCanonicalNameMatcher.group(2))) {
            return String.format("The type `%s` was referred to by the non-canonical name `%s`. This may be misleading.", canonicalNameMatcher.group(2), nonCanonicalNameMatcher.group(2));
        }
        return String.format("The type `%s` was referred to by the non-canonical name `%s`. This may be misleading.", canonicalName, nonCanonicalName);
    }

    private static String getNonCanonicalName(Tree tree) {
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierTree.class, MemberSelectTree.class, ParameterizedTypeTree.class, AnnotatedTypeTree.class}, (Object)tree3, n)) {
            case 0 -> {
                IdentifierTree identifierTree = (IdentifierTree)tree3;
                yield ASTHelpers.getSymbol((Tree)tree).getQualifiedName().toString();
            }
            case 1 -> {
                MemberSelectTree memberSelectTree = (MemberSelectTree)tree3;
                Symbol expressionSymbol = ASTHelpers.getSymbol((Tree)memberSelectTree.getExpression());
                if (!(expressionSymbol instanceof Symbol.TypeSymbol)) {
                    yield ASTHelpers.getSymbol((Tree)tree).getQualifiedName().toString();
                }
                yield NonCanonicalType.getNonCanonicalName(memberSelectTree.getExpression()) + "." + String.valueOf(memberSelectTree.getIdentifier());
            }
            case 2 -> {
                ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree3;
                yield NonCanonicalType.getNonCanonicalName(parameterizedTypeTree.getType());
            }
            case 3 -> {
                AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)tree3;
                yield NonCanonicalType.getNonCanonicalName(annotatedTypeTree.getUnderlyingType());
            }
            default -> throw new AssertionError((Object)tree.getKind());
        };
    }
}

