/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

@BugPattern(summary="Modifying a collection while iterating over it in a loop may cause a ConcurrentModificationException to be thrown or lead to undefined behavior.", severity=BugPattern.SeverityLevel.WARNING)
public class ModifyCollectionInEnhancedForLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").namedAnyOf(new String[]{"add", "addAll", "clear", "remove", "removeAll", "retainAll"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"put", "putAll", "putIfAbsent", "clear", "remove", "replace", "replaceAll", "merge"})});
    private static final Matcher<ExpressionTree> MAP_SET_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"entrySet", "keySet", "values"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (state.getTypes().closure(ASTHelpers.getReceiverType((ExpressionTree)tree)).stream().anyMatch(s -> ASTHelpers.enclosingPackage((Symbol)s.asElement()).getQualifiedName().toString().startsWith("java.util.concurrent"))) {
            return Description.NO_MATCH;
        }
        if (ModifyCollectionInEnhancedForLoop.blockEndsInBreakOrReturn(state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree collection = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (collection == null) {
            return Description.NO_MATCH;
        }
        if (!ModifyCollectionInEnhancedForLoop.enclosingLoop(state, collection)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean blockEndsInBreakOrReturn(VisitorState state) {
        TreePath statementPath = state.findPathToEnclosing(new Class[]{StatementTree.class});
        if (statementPath == null) {
            return false;
        }
        Tree parent = statementPath.getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return false;
        }
        BlockTree blockTree = (BlockTree)parent;
        StatementTree statement = (StatementTree)statementPath.getLeaf();
        List<? extends StatementTree> statements = blockTree.getStatements();
        int idx = statements.indexOf(statement);
        if (idx == -1 || idx == statements.size()) {
            return false;
        }
        return switch (((StatementTree)Iterables.getLast(statements)).getKind()) {
            case Tree.Kind.BREAK, Tree.Kind.RETURN -> true;
            default -> false;
        };
    }

    private static boolean enclosingLoop(VisitorState state, ExpressionTree collection) {
        for (Tree node : state.getPath()) {
            Tree tree;
            Objects.requireNonNull(node);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, ClassTree.class, LambdaExpressionTree.class, EnhancedForLoopTree.class}, (Object)tree, n)) {
                case 0: {
                    MethodTree methodTree = (MethodTree)tree;
                    return false;
                }
                case 1: {
                    ClassTree classTree = (ClassTree)tree;
                    return false;
                }
                case 2: {
                    LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
                    return false;
                }
                case 3: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                    if (!ModifyCollectionInEnhancedForLoop.sameCollection(collection, enhancedForLoopTree.getExpression(), state)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean sameCollection(ExpressionTree collection, ExpressionTree loopExpression, VisitorState state) {
        if (ASTHelpers.sameVariable((ExpressionTree)collection, (ExpressionTree)loopExpression)) {
            return true;
        }
        if (loopExpression instanceof MethodInvocationTree) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)loopExpression);
            return receiver != null && ASTHelpers.sameVariable((ExpressionTree)collection, (ExpressionTree)receiver) && MAP_SET_MATCHER.matches((Tree)loopExpression, state);
        }
        return false;
    }
}

