/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This mock is instantiated and configured, but is never passed to production code. It should be either removed or used.")
public final class MockNotUsedInProduction
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> MOCK = Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"});
    private static final Matcher<VariableTree> MOCK_OR_SPY_ANNOTATED = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"org.mockito.Mock"), Matchers.hasAnnotation((String)"org.mockito.Spy")});
    private static final Matcher<VariableTree> INJECT_MOCKS_ANNOTATED = Matchers.hasAnnotation((String)"org.mockito.InjectMocks");
    private static final Matcher<ExpressionTree> WHEN_OR_VERIFY = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().anyClass().namedAnyOf(new String[]{"when", "verify"}), Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").namedAnyOf(new String[]{"when"})});

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        ImmutableMap<Symbol.VarSymbol, Tree> mocks = this.findMocks(state);
        if (mocks.isEmpty()) {
            return Description.NO_MATCH;
        }
        final HashSet usedMocks = new HashSet();
        new TreePathScanner<Void, Void>(this){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree invocation, Void unused) {
                if (WHEN_OR_VERIFY.matches((Tree)invocation, state)) {
                    this.scan(invocation.getMethodSelect(), null);
                    return null;
                }
                return (Void)super.visitMethodInvocation(invocation, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                return (Void)this.scan(tree.getExpression(), null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelect, Void unused) {
                this.handle(memberSelect);
                return (Void)super.visitMemberSelect(memberSelect, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Void unused) {
                this.handle(identifier);
                return (Void)super.visitIdentifier(identifier, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    usedMocks.add(varSymbol);
                }
            }
        }.scan(state.getPath(), (Void)null);
        mocks.forEach((sym, mockTree) -> {
            if (usedMocks.contains(sym)) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)mockTree, (Fix)MockNotUsedInProduction.generateFix(sym, state)));
        });
        return Description.NO_MATCH;
    }

    private static SuggestedFix generateFix(final Symbol.VarSymbol sym, final VisitorState state) {
        final ImmutableList.Builder deletions = ImmutableList.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)tree), sym)) {
                    Stream.concat(Stream.of(tree), Streams.stream((Iterable)this.getCurrentPath())).filter(t -> t instanceof ExpressionStatementTree || t instanceof VariableTree).findFirst().ifPresent(t -> deletions.add((Object)Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)t)), (Comparable)Integer.valueOf(state.getEndPosition(t)))));
                }
                return (Void)super.scan(tree, null);
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (Range range : ImmutableRangeSet.unionOf((Iterable)deletions.build()).asRanges()) {
            fix.replace(((Integer)range.lowerEndpoint()).intValue(), ((Integer)range.upperEndpoint()).intValue(), "");
        }
        return fix.build();
    }

    private ImmutableMap<Symbol.VarSymbol, Tree> findMocks(VisitorState state) {
        final HashMap mocks = new HashMap();
        final AtomicBoolean injectMocks = new AtomicBoolean(false);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){

            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                if (INJECT_MOCKS_ANNOTATED.matches((Tree)tree, this.state)) {
                    injectMocks.set(true);
                }
                if (this.isEligible(symbol) && (MOCK_OR_SPY_ANNOTATED.matches((Tree)tree, this.state) || tree.getInitializer() != null && MOCK.matches((Tree)tree.getInitializer(), this.state))) {
                    mocks.put(symbol, tree);
                }
                return (Void)super.visitVariable(tree, null);
            }

            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol;
                if (MOCK.matches((Tree)tree.getExpression(), this.state) && this.isEligible(symbol = ASTHelpers.getSymbol((Tree)tree.getVariable()))) {
                    mocks.put((Symbol.VarSymbol)symbol, tree);
                }
                return (Void)super.visitAssignment(tree, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isEligible(Symbol symbol) {
                if (!(symbol instanceof Symbol.VarSymbol)) return false;
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                if (symbol.getKind().equals((Object)ElementKind.FIELD)) {
                    if (!ASTHelpers.canBeRemoved((Symbol.VarSymbol)varSymbol)) return false;
                }
                if (!this.annotatedAtMostMock(symbol)) return false;
                return true;
            }

            private boolean annotatedAtMostMock(Symbol symbol) {
                return symbol.getAnnotationMirrors().stream().allMatch(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("Mock"));
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return injectMocks.get() ? ImmutableMap.of() : ImmutableMap.copyOf(mocks);
    }
}

