/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.stream.Collectors;

@BugPattern(summary="This exception can't be thrown by the mocked method.", severity=BugPattern.SeverityLevel.WARNING)
public final class MockIllegalThrows
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> WHEN = Matchers.staticMethod().onClass("org.mockito.Mockito").named("when");
    private static final Matcher<ExpressionTree> THEN_THROW = Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.OngoingStubbing").named("thenThrow");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!THEN_THROW.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        block0: for (ExpressionTree expressionTree : tree.getArguments()) {
            Type thrownType = ASTHelpers.getType((Tree)expressionTree);
            if (!ASTHelpers.isCheckedExceptionType((Type)thrownType, (VisitorState)state) || !(expressionTree instanceof NewClassTree) && (ASTHelpers.isSameType((Type)thrownType, (Type)state.getSymtab().exceptionType, (VisitorState)state) || ASTHelpers.isSameType((Type)thrownType, (Type)state.getSymtab().throwableType, (VisitorState)state))) continue;
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            while (receiver instanceof MethodInvocationTree) {
                MethodInvocationTree mit;
                ExpressionTree expressionTree2;
                MethodInvocationTree whenMit = (MethodInvocationTree)receiver;
                if (WHEN.matches((Tree)receiver, state) && (expressionTree2 = whenMit.getArguments().getFirst()) instanceof MethodInvocationTree && ASTHelpers.getType((Tree)(mit = (MethodInvocationTree)expressionTree2).getMethodSelect()).getThrownTypes().stream().noneMatch(throwableType -> state.getTypes().isAssignable(thrownType, (Type)throwableType))) {
                    List<Type> thrownTypes = ASTHelpers.getType((Tree)mit.getMethodSelect()).getThrownTypes();
                    state.reportMatch(this.buildDescription(whenMit.getArguments().getFirst()).setMessage(thrownTypes.isEmpty() ? String.format("%s is not throwable by this method; only unchecked exceptions can be thrown.", thrownType.tsym.getSimpleName()) : String.format("%s is not throwable by this method; possible exception types are %s, or any unchecked exception.", thrownType.tsym.getSimpleName(), thrownTypes.stream().map(t -> ((Name)t.tsym.getSimpleName()).toString()).collect(Collectors.joining(", ")))).build());
                    continue block0;
                }
                receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
            }
        }
        return Description.NO_MATCH;
    }
}

