/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;

@BugPattern(summary="C-style array declarations should not be used", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
public class MixedArrayDimensions
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.checkArrayDimensions(tree, tree.getReturnType(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.checkArrayDimensions(tree, tree.getType(), state);
    }

    private Description checkArrayDimensions(Tree tree, Tree type, VisitorState state) {
        if (!(type instanceof ArrayTypeTree)) {
            return Description.NO_MATCH;
        }
        CharSequence source = state.getSourceCode();
        while (type instanceof ArrayTypeTree) {
            int nonWhitespace;
            String dim;
            int idx;
            ImmutableList tokens;
            int end;
            Tree elemType = ((ArrayTypeTree)type).getType();
            int start = state.getEndPosition(elemType);
            if (start < (end = state.getEndPosition(type)) && (tokens = state.getOffsetTokens(start, end)).size() > 2 && ((ErrorProneToken)tokens.getFirst()).kind() == Tokens.TokenKind.IDENTIFIER && (idx = (dim = source.subSequence(start, end).toString()).indexOf("[]", nonWhitespace = CharMatcher.isNot((char)' ').indexIn((CharSequence)dim))) > nonWhitespace) {
                String replacement = dim.substring(idx) + dim.substring(0, idx);
                Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((Tree)tree));
                if (enclosingClass != null && (enclosingClass.name.contentEquals("SimpleCharStream") || enclosingClass.name.contentEquals("SimpleNode"))) {
                    return Description.NO_MATCH;
                }
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)start, (int)end, (String)replacement));
            }
            type = ((ArrayTypeTree)type).getType();
        }
        return Description.NO_MATCH;
    }
}

