/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="The Google Java Style Guide requires that each switch statement includes a default statement group (even if it contains no code) unless the switch statement covers all values of an enum.", severity=BugPattern.SeverityLevel.WARNING)
public class MissingDefault
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final Field IS_EXHAUSTIVE = MissingDefault.getIsExhaustive();

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Type switchType = ASTHelpers.getType((Tree)tree.getExpression());
        if (switchType.asElement().getKind() == ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        Optional maybeDefault = ASTHelpers.getSwitchDefault((SwitchTree)tree);
        if (maybeDefault.isEmpty()) {
            if (MissingDefault.isExhaustive(tree)) {
                return Description.NO_MATCH;
            }
            Description.Builder description = this.buildDescription(tree);
            if (!tree.getCases().isEmpty()) {
                CaseTree lastCase = (CaseTree)Iterables.getLast(tree.getCases());
                List<? extends StatementTree> statements = lastCase.getStatements();
                String replacement = tree.getCases().stream().noneMatch(c -> c.getCaseKind() == CaseTree.CaseKind.STATEMENT) ? "\ndefault -> {}\n" : (statements == null || statements.isEmpty() || Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(statements))) ? "\nbreak;\ndefault: // fall out\n" : "\ndefault: // fall out\n");
                description.addFix((Fix)SuggestedFix.postfixWith((Tree)((Tree)Iterables.getLast(tree.getCases())), (String)replacement));
            }
            return description.build();
        }
        CaseTree defaultCase = (CaseTree)maybeDefault.get();
        List<? extends StatementTree> statements = defaultCase.getStatements();
        if (statements == null || !statements.isEmpty()) {
            return Description.NO_MATCH;
        }
        int idx = tree.getCases().indexOf(defaultCase);
        if (idx != tree.getCases().size() - 1) {
            return Description.NO_MATCH;
        }
        if (state.getOffsetTokens(state.getEndPosition((Tree)defaultCase), state.getEndPosition((Tree)tree)).stream().anyMatch(t -> !t.comments().isEmpty())) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(defaultCase).setMessage("Default case should be documented with a comment").addFix((Fix)SuggestedFix.postfixWith((Tree)defaultCase, (String)" // fall out")).build();
    }

    private static Field getIsExhaustive() {
        try {
            return JCTree.JCSwitch.class.getField("isExhaustive");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static boolean isExhaustive(SwitchTree tree) {
        try {
            return IS_EXHAUSTIVE != null && IS_EXHAUSTIVE.getBoolean(tree);
        }
        catch (IllegalAccessException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

