/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;

@BugPattern(summary="Using \\s anywhere except at the end of a line in a text block is potentially misleading.", severity=BugPattern.SeverityLevel.ERROR)
public final class MisleadingEscapedSpace
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (!SourceVersion.supportsTextBlocks((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (tree.getValue() instanceof Character && tree.getValue().equals(Character.valueOf(' ')) && state.getSourceForNode((Tree)tree).equals("'\\s'")) {
            return this.describeMatch(tree);
        }
        Object object = tree.getValue();
        if (object instanceof String) {
            String value = (String)object;
            if (!value.contains(" ")) {
                return Description.NO_MATCH;
            }
            String source = state.getSourceForNode((Tree)tree);
            ImmutableList tokens = ErrorProneTokens.getTokens((String)source, (Context)state.context);
            for (ErrorProneToken token : tokens) {
                if (!token.kind().equals(Tokens.TokenKind.STRINGLITERAL)) continue;
                String sourceWithQuotes = source.substring(token.pos(), token.endPos());
                boolean isBlockLiteral = sourceWithQuotes.startsWith("\"\"\"");
                int quoteSize = isBlockLiteral ? 3 : 1;
                String literal = sourceWithQuotes.substring(quoteSize, sourceWithQuotes.length() - quoteSize);
                boolean seenEscape = false;
                block5: for (int i = 0; i < literal.length(); ++i) {
                    switch (literal.charAt(i)) {
                        case '\n': {
                            seenEscape = false;
                            continue block5;
                        }
                        case '\\': {
                            if (literal.charAt(++i) == 's') {
                                seenEscape = true;
                                continue block5;
                            }
                        }
                        default: {
                            if (!seenEscape) continue block5;
                            return this.describeMatch(tree);
                        }
                    }
                }
                if (!seenEscape || isBlockLiteral) continue;
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }
}

