/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Conversion from long to float may lose precision; use an explicit cast to float if this was intentional", severity=BugPattern.SeverityLevel.WARNING)
public class LongFloatConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (ExpressionTree expressionTree : tree.getArguments()) {
            TargetType targetType;
            if (!ASTHelpers.getType((Tree)expressionTree).getKind().equals((Object)TypeKind.LONG) || (targetType = TargetType.targetType((VisitorState)state.withPath(new TreePath(state.getPath(), expressionTree)))) == null || !targetType.type().getKind().equals((Object)TypeKind.FLOAT)) continue;
            state.reportMatch(this.describeMatch(expressionTree, (Fix)SuggestedFix.prefixWith((Tree)expressionTree, (String)"(float) ")));
        }
        return Description.NO_MATCH;
    }
}

