/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Labels should only be used on loops.", severity=BugPattern.SeverityLevel.ERROR)
public class LabelledBreakTarget
extends BugChecker
implements BugChecker.LabeledStatementTreeMatcher {
    public Description matchLabeledStatement(LabeledStatementTree tree, VisitorState state) {
        return switch (tree.getStatement().getKind()) {
            case Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP -> Description.NO_MATCH;
            default -> this.describeMatch(tree);
        };
    }
}

