/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

@BugPattern(summary="Empty JUnit4 @Before, @After, @BeforeClass, and @AfterClass methods are unnecessary and should be deleted.", severity=BugPattern.SeverityLevel.WARNING)
public final class JUnit4EmptyMethods
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> JUNIT_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"org.junit.BeforeClass"), Matchers.hasAnnotation((String)"org.junit.AfterClass"), Matchers.hasAnnotation((String)"org.junit.Before"), Matchers.hasAnnotation((String)"org.junit.After")});

    public Description matchMethod(MethodTree method, VisitorState state) {
        List<Type> types = state.getTypes().closure(ASTHelpers.getSymbol((MethodTree)method).owner.type);
        if (types.size() != 2) {
            return Description.NO_MATCH;
        }
        if (method.getBody() != null && method.getBody().getStatements().isEmpty() && JUNIT_METHODS.matches((Tree)method, state) && !ASTHelpers.containsComments((Tree)method, (VisitorState)state)) {
            return this.describeMatch(method, (Fix)SuggestedFix.delete((Tree)method));
        }
        return Description.NO_MATCH;
    }
}

