/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="This method calls itself unconditionally; it will throw StackOverflowError", severity=BugPattern.SeverityLevel.ERROR)
public class InfiniteRecursion
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree declaration, VisitorState state) {
        if (declaration.getBody() == null) {
            return Description.NO_MATCH;
        }
        final Symbol.MethodSymbol declaredSymbol = ASTHelpers.getSymbol((MethodTree)declaration);
        new BugChecker.SuppressibleTreePathScanner<Void, Boolean>(this, state){
            boolean mayHaveReturned;
            final /* synthetic */ InfiniteRecursion this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitReturn(ReturnTree tree, Boolean underConditional) {
                super.visitReturn(tree, (Object)underConditional);
                this.mayHaveReturned = true;
                return null;
            }

            public Void visitBinary(BinaryTree tree, Boolean underConditional) {
                this.scan(tree.getLeftOperand(), underConditional);
                if (tree.getKind() != Tree.Kind.CONDITIONAL_AND && tree.getKind() != Tree.Kind.CONDITIONAL_OR) {
                    this.scan(tree.getRightOperand(), underConditional);
                }
                return null;
            }

            public Void visitCase(CaseTree tree, Boolean underConditional) {
                return (Void)super.visitCase(tree, (Object)true);
            }

            public Void visitConditionalExpression(ConditionalExpressionTree tree, Boolean underConditional) {
                this.scan(tree.getCondition(), underConditional);
                return null;
            }

            public Void visitEnhancedForLoop(EnhancedForLoopTree tree, Boolean underConditional) {
                this.scan(tree.getExpression(), underConditional);
                this.scan(tree.getStatement(), true);
                return null;
            }

            public Void visitForLoop(ForLoopTree tree, Boolean underConditional) {
                this.scan(tree.getInitializer(), underConditional);
                this.scan(tree.getCondition(), underConditional);
                this.scan(tree.getStatement(), true);
                return null;
            }

            public Void visitIf(IfTree tree, Boolean underConditional) {
                this.scan(tree.getCondition(), underConditional);
                this.scan(tree.getThenStatement(), true);
                this.scan(tree.getElseStatement(), true);
                return null;
            }

            public Void visitWhileLoop(WhileLoopTree tree, Boolean underConditional) {
                this.scan(tree.getCondition(), underConditional);
                this.scan(tree.getStatement(), true);
                return null;
            }

            public Void visitCatch(CatchTree tree, Boolean underConditional) {
                return null;
            }

            public Void visitClass(ClassTree tree, Boolean underConditional) {
                return null;
            }

            public Void visitLambdaExpression(LambdaExpressionTree tree, Boolean underConditional) {
                return null;
            }

            public Void visitMethodInvocation(MethodInvocationTree tree, Boolean underConditional) {
                this.checkInvocation(tree, underConditional);
                return (Void)super.visitMethodInvocation(tree, (Object)underConditional);
            }

            void checkInvocation(MethodInvocationTree invocation, boolean underConditional) {
                if (this.mayHaveReturned || underConditional) {
                    return;
                }
                if (!declaredSymbol.equals(ASTHelpers.getSymbol((MethodInvocationTree)invocation))) {
                    return;
                }
                if (!ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)declaredSymbol) || InfiniteRecursion.isCallOnThisObject(invocation)) {
                    this.state.reportMatch(this.this$0.describeMatch(invocation));
                }
            }
        }.scan(new TreePath(state.getPath(), declaration.getBody()), (Object)false);
        return Description.NO_MATCH;
    }

    private static boolean isCallOnThisObject(MethodInvocationTree invocation) {
        ExpressionTree select = invocation.getMethodSelect();
        return select instanceof IdentifierTree || InfiniteRecursion.isThis(((MemberSelectTree)select).getExpression());
    }

    private static boolean isThis(ExpressionTree input) {
        return (Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitMemberSelect(MemberSelectTree tree, Void unused) {
                return tree.getIdentifier().contentEquals("this");
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return tree.getName().contentEquals("this");
            }

            @Override
            protected Boolean defaultAction(Tree tree, Void unused) {
                return false;
            }
        }.visit(input, null);
    }
}

