/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This value cannot be null, and comparing it to null may be misleading.", name="ImpossibleNullComparison", altNames={"ProtoFieldNullComparison"}, severity=BugPattern.SeverityLevel.ERROR)
public final class ImpossibleNullComparison
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> CHECK_NOT_NULL = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.base.Verify").named("verifyNotNull"), Matchers.staticMethod().onClass("java.util.Objects").named("requireNonNull")});
    private static final Matcher<ExpressionTree> ASSERT_NOT_NULL = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("junit.framework.Assert").named("assertNotNull"), Matchers.staticMethod().onClass("org.junit.Assert").named("assertNotNull")});
    private static final Matcher<MethodInvocationTree> TRUTH_NOT_NULL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("isNotNull"), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().anyClass().namedAnyOf(new String[]{"assertThat"}), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))});
    private static final Matcher<Tree> RETURNS_LIST = Matchers.isSubtypeOf((String)"java.util.List");
    private static final ImmutableSet<Tree.Kind> COMPARISON_OPERATORS = Sets.immutableEnumSet((Enum)Tree.Kind.EQUAL_TO, (Enum[])new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO});
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_FIX = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters("com.google.protobuf.ExtensionLite", new String[0]);
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_NO_FIX = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getRepeatedField").withParameters("com.google.protobuf.Descriptors.FieldDescriptor", new String[]{"int"}), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters("com.google.protobuf.ExtensionLite", new String[]{"int"}), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getField").withParameters("com.google.protobuf.Descriptors.FieldDescriptor", new String[0])});
    private static final Matcher<ExpressionTree> OF_NULLABLE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Optional").named("ofNullable"), Matchers.staticMethod().onClass("com.google.common.base.Optional").named("fromNullable")});
    private static final Matcher<ExpressionTree> PROTO_RECEIVER = Matchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.protobuf.GeneratedMessageLite", "com.google.protobuf.GeneratedMessage"});
    private final boolean matchTestAssertions;
    private final boolean checkPrimitives;
    private final boolean checkValueOf;
    private static final Matcher<ExpressionTree> OPTIONAL_GET_MATCHER = Matchers.instanceMethod().onExactClass("java.util.Optional").namedAnyOf(new String[]{"get", "orElseThrow"});
    private static final Matcher<ExpressionTree> GUAVA_OPTIONAL_GET_MATCHER = Matchers.instanceMethod().onExactClass("com.google.common.base.Optional").named("get");
    private static final Matcher<ExpressionTree> MULTIMAP_GET_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.collect.Multimap").named("get");
    private static final Matcher<ExpressionTree> TABLE_ROW_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.collect.Table").named("row");
    private static final Matcher<ExpressionTree> TABLE_COLUMN_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.collect.Table").named("column");
    private static final Matcher<ExpressionTree> NON_NULL_VALUE_OF = Matchers.staticMethod().onDescendantOfAny(new String[]{"java.lang.Enum", "java.lang.Number"}).named("valueOf").withParameters("java.lang.String", new String[0]);
    private static final Supplier<Symbol> COM_GOOGLE_PROTOBUF_EXTENSIONLITE = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("com.google.protobuf.ExtensionLite"));

    private static boolean isNull(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    @Inject
    ImpossibleNullComparison(ErrorProneFlags flags) {
        this.matchTestAssertions = flags.getBoolean("ProtoFieldNullComparison:MatchTestAssertions").orElse(true);
        this.checkPrimitives = flags.getBoolean("ImmutableNullComparison:CheckPrimitives").orElse(true);
        this.checkValueOf = flags.getBoolean("ImpossibleNullComparison:CheckValueOf").orElse(true);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        NullComparisonScanner scanner = new NullComparisonScanner(state);
        scanner.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static String getMethodName(ExpressionTree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ExpressionTree expressionTree = method.getMethodSelect();
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
        return access.sym.getQualifiedName().toString();
    }

    private static String replaceLast(String text, String pattern, String replacement) {
        StringBuilder builder = new StringBuilder(text);
        int lastIndexOf = builder.lastIndexOf(pattern);
        return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
    }

    private class NullComparisonScanner
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, ExpressionTree> effectivelyFinalValues = new HashMap<Symbol, ExpressionTree>();
        private final VisitorState state;

        private NullComparisonScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitMethod(MethodTree method, Void unused) {
            return ImpossibleNullComparison.this.isSuppressed(method, this.state) ? null : (Void)super.visitMethod(method, null);
        }

        @Override
        public Void visitClass(ClassTree clazz, Void unused) {
            return ImpossibleNullComparison.this.isSuppressed(clazz, this.state) ? null : (Void)super.visitClass(clazz, null);
        }

        @Override
        public Void visitVariable(VariableTree variable, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variable);
            if (variable.getInitializer() != null && ASTHelpers.isConsideredFinal((Symbol)symbol)) {
                this.getInitializer(variable.getInitializer()).ifPresent(e -> this.effectivelyFinalValues.put(symbol, (ExpressionTree)e));
            }
            return ImpossibleNullComparison.this.isSuppressed(variable, this.state) ? null : (Void)super.visitVariable(variable, null);
        }

        private Optional<ExpressionTree> getInitializer(ExpressionTree tree) {
            return Optional.ofNullable((ExpressionTree)new SimpleTreeVisitor<ExpressionTree, Void>(){

                @Override
                public @Nullable ExpressionTree visitMethodInvocation(MethodInvocationTree node, Void unused) {
                    return PROTO_RECEIVER.matches((Tree)node, NullComparisonScanner.this.state) ? node : null;
                }

                @Override
                public ExpressionTree visitParenthesized(ParenthesizedTree node, Void unused) {
                    return (ExpressionTree)this.visit(node.getExpression(), null);
                }

                @Override
                public ExpressionTree visitTypeCast(TypeCastTree node, Void unused) {
                    return (ExpressionTree)this.visit(node.getExpression(), null);
                }
            }.visit(tree, null));
        }

        @Override
        public Void visitSwitch(SwitchTree tree, Void unused) {
            this.handleSwitch(tree.getExpression(), tree.getCases());
            return (Void)super.visitSwitch(tree, null);
        }

        @Override
        public Void visitSwitchExpression(SwitchExpressionTree tree, Void unused) {
            this.handleSwitch(tree.getExpression(), tree.getCases());
            return (Void)super.visitSwitchExpression(tree, null);
        }

        private void handleSwitch(ExpressionTree expression, List<? extends CaseTree> cases) {
            ExpressionTree withoutParens = ASTHelpers.stripParentheses((ExpressionTree)expression);
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            for (CaseTree caseTree : cases) {
                caseTree.getExpressions().stream().filter(e -> ImpossibleNullComparison.isNull(e)).findFirst().filter(unused -> this.getFixer(withoutParens, subState).isPresent()).ifPresent(e -> this.state.reportMatch(ImpossibleNullComparison.this.describeMatch(caseTree, (Fix)SuggestedFix.delete((Tree)caseTree))));
            }
        }

        @Override
        public Void visitBinary(BinaryTree binary, Void unused) {
            if (!COMPARISON_OPERATORS.contains((Object)binary.getKind())) {
                return (Void)super.visitBinary(binary, null);
            }
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            Optional<Fixer> fixer = Optional.empty();
            if (ImpossibleNullComparison.isNull(binary.getLeftOperand())) {
                fixer = this.getFixer(binary.getRightOperand(), subState);
            }
            if (ImpossibleNullComparison.isNull(binary.getRightOperand())) {
                fixer = this.getFixer(binary.getLeftOperand(), subState);
            }
            fixer.map(f -> ImpossibleNullComparison.this.describeMatch(binary, (Fix)ProblemUsage.COMPARISON.fix((Fixer)f, binary, subState))).ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
            return (Void)super.visitBinary(binary, null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            ProblemUsage problemType;
            ExpressionTree argument;
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            if (CHECK_NOT_NULL.matches((Tree)node, subState)) {
                argument = node.getArguments().get(0);
                problemType = ProblemUsage.CHECK_NOT_NULL;
            } else if (ImpossibleNullComparison.this.matchTestAssertions && ASSERT_NOT_NULL.matches((Tree)node, subState)) {
                argument = (ExpressionTree)Iterables.getLast(node.getArguments());
                problemType = ProblemUsage.JUNIT;
            } else if (OF_NULLABLE.matches((Tree)node, subState)) {
                argument = (ExpressionTree)Iterables.getOnlyElement(node.getArguments());
                problemType = ProblemUsage.OPTIONAL;
            } else if (ImpossibleNullComparison.this.matchTestAssertions && TRUTH_NOT_NULL.matches((Tree)node, subState)) {
                argument = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)node)).getArguments());
                problemType = ProblemUsage.TRUTH;
            } else {
                return (Void)super.visitMethodInvocation(node, null);
            }
            this.getFixer(argument, subState).map(f -> ImpossibleNullComparison.this.describeMatch(node, (Fix)problemType.fix((Fixer)f, node, subState))).ifPresent(arg_0 -> ((VisitorState)this.state).reportMatch(arg_0));
            return (Void)super.visitMethodInvocation(node, null);
        }

        private Optional<Fixer> getFixer(ExpressionTree tree, VisitorState state) {
            ExpressionTree resolvedTree = this.getEffectiveTree(tree);
            if (resolvedTree == null) {
                return Optional.empty();
            }
            return Arrays.stream(GetterTypes.values()).filter(gt -> !gt.equals((Object)GetterTypes.PRIMITIVE) || ImpossibleNullComparison.this.checkPrimitives).filter(gt -> !gt.equals((Object)GetterTypes.VALUE_OF) || ImpossibleNullComparison.this.checkValueOf).map(type -> type.match(resolvedTree, state)).filter(Objects::nonNull).findFirst();
        }

        private @Nullable ExpressionTree getEffectiveTree(ExpressionTree tree) {
            return tree instanceof IdentifierTree ? this.effectivelyFinalValues.getOrDefault(ASTHelpers.getSymbol((Tree)tree), tree) : tree;
        }
    }

    private static enum ProblemUsage {
        COMPARISON{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                Optional<String> replacement = fixer.getReplacement(tree.getKind() == Tree.Kind.EQUAL_TO, state);
                return replacement.map(r -> SuggestedFix.replace((Tree)tree, (String)r)).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        TRUTH{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                return fixer.getReplacement(false, state).map(r -> {
                    MethodInvocationTree receiver = (MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree);
                    return SuggestedFix.replace((Tree)tree, (String)String.format("%s(%s).isTrue()", state.getSourceForNode((Tree)receiver.getMethodSelect()), r));
                }).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        JUNIT{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                return fixer.getReplacement(false, state).map(r -> {
                    int startPos = ASTHelpers.getStartPosition((Tree)methodInvocationTree);
                    return SuggestedFix.builder().replace((Tree)Iterables.getLast(methodInvocationTree.getArguments()), r).replace(startPos, startPos + "assertNotNull".length(), "assertTrue").build();
                }).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        CHECK_NOT_NULL{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                Tree parent = state.getPath().getParentPath().getLeaf();
                return parent instanceof ExpressionStatementTree ? SuggestedFix.delete((Tree)parent) : SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)methodInvocationTree.getArguments().get(0)));
            }
        }
        ,
        OPTIONAL{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                return SuggestedFixes.renameMethodInvocation((MethodInvocationTree)methodInvocationTree, (String)"of", (VisitorState)state);
            }
        };


        abstract SuggestedFix fix(Fixer var1, ExpressionTree var2, VisitorState var3);
    }

    private static enum GetterTypes {
        OPTIONAL_GET{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!OPTIONAL_GET_MATCHER.matches((Tree)tree, state)) {
                    return null;
                }
                return (n, s) -> Optional.of(s.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)) + (n ? ".isEmpty()" : ".isPresent()"));
            }
        }
        ,
        GUAVA_OPTIONAL_GET{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!GUAVA_OPTIONAL_GET_MATCHER.matches((Tree)tree, state)) {
                    return null;
                }
                return (n, s) -> Optional.of((n ? "!" : "") + s.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)) + ".isPresent()");
            }
        }
        ,
        MULTIMAP_GET{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!MULTIMAP_GET_MATCHER.matches((Tree)tree, state)) {
                    return null;
                }
                return (n, s) -> Optional.of(String.format("%s%s.containsKey(%s)", n ? "!" : "", s.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), s.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)tree).getArguments()))));
            }
        }
        ,
        TABLE_ROW_GET{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!TABLE_ROW_MATCHER.matches((Tree)tree, state)) {
                    return null;
                }
                return (n, s) -> Optional.of(String.format("%s%s.containsRow(%s)", n ? "!" : "", s.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), s.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)tree).getArguments()))));
            }
        }
        ,
        TABLE_COLUMN_GET{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!TABLE_COLUMN_MATCHER.matches((Tree)tree, state)) {
                    return null;
                }
                return (n, s) -> Optional.of(String.format("%s%s.containsColumn(%s)", n ? "!" : "", s.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), s.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)tree).getArguments()))));
            }
        }
        ,
        PRIMITIVE{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                Type type = ASTHelpers.getType((Tree)tree);
                return type != null && type.isPrimitive() ? GetterTypes::emptyFix : null;
            }
        }
        ,
        VALUE_OF{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!NON_NULL_VALUE_OF.matches((Tree)tree, state)) {
                    return null;
                }
                return GetterTypes::emptyFix;
            }
        }
        ,
        SCALAR{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!PROTO_RECEIVER.matches((Tree)tree, state)) {
                    return null;
                }
                if (!(tree instanceof MethodInvocationTree)) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (RETURNS_LIST.matches((Tree)method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (n, s) -> this.generateFix(method, n, s) : null;
            }

            private Optional<String> generateFix(MethodInvocationTree methodInvocation, boolean negated, VisitorState state) {
                String methodName = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocation).getQualifiedName().toString();
                String hasMethod = methodName.replaceFirst("get", "has");
                ImmutableSet hasMethods = ASTHelpers.findMatchingMethods((Name)state.getName(hasMethod), ms -> ms.params().isEmpty(), (Type)ASTHelpers.getType((Tree)ASTHelpers.getReceiver((ExpressionTree)methodInvocation)), (Types)state.getTypes());
                if (hasMethods.isEmpty()) {
                    return Optional.empty();
                }
                String replacement = this.replaceLast(state.getSourceForNode((Tree)methodInvocation), methodName, hasMethod);
                return Optional.of(negated ? "!" + replacement : replacement);
            }

            private String replaceLast(String text, String pattern, String replacement) {
                StringBuilder builder = new StringBuilder(text);
                int lastIndexOf = builder.lastIndexOf(pattern);
                return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
            }
        }
        ,
        VECTOR_INDEXED{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!PROTO_RECEIVER.matches((Tree)tree, state)) {
                    return null;
                }
                if (!(tree instanceof MethodInvocationTree)) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (method.getArguments().size() != 1 || !GetterTypes.isGetter(method.getMethodSelect())) {
                    return null;
                }
                if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(method.getArguments()))), (Type)state.getSymtab().intType, (VisitorState)state)) {
                    return null;
                }
                return (n, s) -> Optional.of(this.generateFix(method, n, state));
            }

            private String generateFix(MethodInvocationTree methodInvocation, boolean negated, VisitorState visitorState) {
                String methodName = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocation).getQualifiedName().toString();
                String countMethod = methodName + "Count";
                return String.format("%s.%s() %s %s", visitorState.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)methodInvocation)), countMethod, negated ? "<=" : ">", visitorState.getSourceForNode((Tree)Iterables.getOnlyElement(methodInvocation.getArguments())));
            }
        }
        ,
        VECTOR{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!PROTO_RECEIVER.matches((Tree)tree, state)) {
                    return null;
                }
                if (!(tree instanceof MethodInvocationTree)) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (!RETURNS_LIST.matches((Tree)method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (n, s) -> Optional.of(this.generateFix(n, method, state)) : null;
            }

            private String generateFix(boolean negated, ExpressionTree methodInvocation, VisitorState state) {
                String replacement = state.getSourceForNode((Tree)methodInvocation) + ".isEmpty()";
                return negated ? replacement : "!" + replacement;
            }
        }
        ,
        EXTENSION_METHOD{

            @Override
            @Nullable Fixer match(ExpressionTree tree, VisitorState state) {
                if (!PROTO_RECEIVER.matches((Tree)tree, state)) {
                    return null;
                }
                if (EXTENSION_METHODS_WITH_NO_FIX.matches((Tree)tree, state)) {
                    return GetterTypes::emptyFix;
                }
                if (EXTENSION_METHODS_WITH_FIX.matches((Tree)tree, state)) {
                    MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
                    Type argumentType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(methodInvocation.getArguments())));
                    Symbol extension = (Symbol)COM_GOOGLE_PROTOBUF_EXTENSIONLITE.get(state);
                    Type genericsArgument = state.getTypes().asSuper(argumentType, extension);
                    if (genericsArgument.getTypeArguments().size() != 2) {
                        return GetterTypes::emptyFix;
                    }
                    if (ASTHelpers.isSubtype((Type)genericsArgument.getTypeArguments().get(1), (Type)state.getSymtab().listType, (VisitorState)state)) {
                        return GetterTypes::emptyFix;
                    }
                    return this.generateFix(methodInvocation);
                }
                return null;
            }

            private Fixer generateFix(MethodInvocationTree methodInvocation) {
                return (negated, state) -> {
                    String methodName = ImpossibleNullComparison.getMethodName(methodInvocation);
                    String hasMethod = methodName.replaceFirst("get", "has");
                    String replacement = ImpossibleNullComparison.replaceLast(state.getSourceForNode((Tree)methodInvocation), methodName, hasMethod);
                    return Optional.of(negated ? "!" + replacement : replacement);
                };
            }
        };


        private static Optional<String> emptyFix(boolean n, VisitorState s) {
            return Optional.empty();
        }

        private static boolean isGetter(ExpressionTree expressionTree) {
            if (!(expressionTree instanceof JCTree.JCFieldAccess)) {
                return false;
            }
            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
            String methodName = access.sym.getQualifiedName().toString();
            return methodName.startsWith("get");
        }

        abstract Fixer match(ExpressionTree var1, VisitorState var2);
    }

    private static interface Fixer {
        public Optional<String> getReplacement(boolean var1, VisitorState var2);
    }
}

