/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This private static ImmutableList is only used for contains, containsAll or isEmpty checks; prefer ImmutableSet.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ImmutableSetForContains
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> PRIVATE_STATIC_IMMUTABLE_LIST_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isStatic(), Matchers.hasModifier((Modifier)Modifier.PRIVATE), Matchers.hasModifier((Modifier)Modifier.FINAL), Matchers.isSameType(ImmutableList.class)});
    private static final Matcher<Tree> EXCLUSIONS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotationWithSimpleName((String)"Bind"), Matchers.hasAnnotationWithSimpleName((String)"Inject")});
    private static final Matcher<ExpressionTree> IMMUTABLE_LIST_FACTORIES = Matchers.staticMethod().onClass(ImmutableList.class.getName()).namedAnyOf(new String[]{"of", "copyOf"});
    private static final Matcher<ExpressionTree> IMMUTABLE_LIST_BUILD = Matchers.instanceMethod().onExactClass(ImmutableList.Builder.class.getName()).namedAnyOf(new String[]{"build"});
    private static final Matcher<ExpressionTree> IMMUTABLE_COLLECTION = Matchers.instanceMethod().onExactClass(Stream.class.getName()).named("collect");
    private static final Matcher<ExpressionTree> IMMUTABLE_BUILDER_METHODS = Matchers.instanceMethod().onExactClass(ImmutableList.Builder.class.getName()).namedAnyOf(new String[]{"add", "addAll"});
    private final WellKnownKeep wellKnownKeep;

    @Inject
    ImmutableSetForContains(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableSet immutableListVar = (ImmutableSet)tree.getMembers().stream().filter(member -> member instanceof VariableTree).map(VariableTree.class::cast).filter(member -> PRIVATE_STATIC_IMMUTABLE_LIST_MATCHER.matches((Tree)member, state) && !this.wellKnownKeep.shouldKeep((VariableTree)member) && !EXCLUSIONS.matches((Tree)member, state)).collect(ImmutableSet.toImmutableSet());
        if (immutableListVar.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableVarUsageScanner usageScanner = new ImmutableVarUsageScanner((ImmutableSet<VariableTree>)immutableListVar);
        TreePath cuPath = state.findPathToEnclosing(new Class[]{CompilationUnitTree.class});
        usageScanner.scan(cuPath.getLeaf(), state.withPath(cuPath));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Optional<VariableTree> firstReplacement = Optional.empty();
        for (VariableTree var : immutableListVar) {
            if (this.isSuppressed(var, state) || !usageScanner.varUsages.get(ASTHelpers.getSymbol((VariableTree)var)).shouldReport()) continue;
            firstReplacement = Optional.of(var);
            fix.merge(ImmutableSetForContains.convertListToSetInit(var, state));
        }
        return firstReplacement.map(fr -> this.describeMatch((Tree)fr, (Fix)fix.build())).orElse(Description.NO_MATCH);
    }

    private static SuggestedFix convertListToSetInit(VariableTree var, VisitorState state) {
        Optional<ExpressionTree> rootExpr;
        SuggestedFix.Builder fix = SuggestedFix.builder().addImport(ImmutableSet.class.getName()).replace(ImmutableSetForContains.stripParameters(var.getType()), "ImmutableSet");
        if (IMMUTABLE_LIST_FACTORIES.matches((Tree)var.getInitializer(), state)) {
            fix.replace((Tree)ASTHelpers.getReceiver((ExpressionTree)var.getInitializer()), "ImmutableSet");
            return fix.build();
        }
        if (IMMUTABLE_COLLECTION.matches((Tree)var.getInitializer(), state)) {
            fix.addStaticImport("com.google.common.collect.ImmutableSet.toImmutableSet").replace((Tree)Iterables.getOnlyElement(((MethodInvocationTree)var.getInitializer()).getArguments()), "toImmutableSet()");
            return fix.build();
        }
        if (IMMUTABLE_LIST_BUILD.matches((Tree)var.getInitializer(), state) && (rootExpr = ImmutableSetForContains.getRootMethod((MethodInvocationTree)var.getInitializer(), state)).isPresent()) {
            ExpressionTree expressionTree = rootExpr.get();
            if (expressionTree instanceof MethodInvocationTree) {
                MethodInvocationTree methodTree = (MethodInvocationTree)expressionTree;
                fix.replace((Tree)ASTHelpers.getReceiver((ExpressionTree)methodTree), "ImmutableSet");
                return fix.build();
            }
            expressionTree = rootExpr.get();
            if (expressionTree instanceof NewClassTree) {
                NewClassTree ctorTree = (NewClassTree)expressionTree;
                fix.replace(ImmutableSetForContains.stripParameters(ctorTree.getIdentifier()), "ImmutableSet.Builder");
            }
            return fix.build();
        }
        return fix.replace((Tree)var.getInitializer(), "ImmutableSet.copyOf(" + state.getSourceForNode((Tree)var.getInitializer()) + ")").build();
    }

    private static Tree stripParameters(Tree tree) {
        Tree tree2;
        if (tree instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree;
            tree2 = parameterizedTypeTree.getType();
        } else {
            tree2 = tree;
        }
        return tree2;
    }

    private static Optional<ExpressionTree> getRootMethod(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return ASTHelpers.streamReceivers((ExpressionTree)methodInvocationTree).filter(t -> !IMMUTABLE_BUILDER_METHODS.matches((Tree)t, state)).findFirst();
    }

    private static final class ImmutableVarUsageScanner
    extends TreeScanner<Void, VisitorState> {
        private static final Matcher<ExpressionTree> ALLOWED_FUNCTIONS_ON_LIST = Matchers.instanceMethod().onExactClass(ImmutableList.class.getName()).namedAnyOf(new String[]{"contains", "containsAll", "isEmpty"});
        private final Map<Symbol, UsageState> varUsages;

        private ImmutableVarUsageScanner(ImmutableSet<VariableTree> immutableListVar) {
            this.varUsages = immutableListVar.stream().map(ASTHelpers::getSymbol).collect(Collectors.toMap(x -> x, x -> UsageState.NEVER_USED));
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
            methodInvocationTree.getArguments().forEach(tree -> this.scan((Tree)tree, state));
            methodInvocationTree.getTypeArguments().forEach(tree -> this.scan((Tree)tree, state));
            if (!this.allowedFuncOnImmutableVar(methodInvocationTree, state)) {
                this.scan(methodInvocationTree.getMethodSelect(), state);
            }
            return null;
        }

        private boolean allowedFuncOnImmutableVar(MethodInvocationTree methodTree, VisitorState state) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodTree);
            if (receiver == null) {
                return false;
            }
            if (!this.varUsages.containsKey(ASTHelpers.getSymbol((Tree)receiver))) {
                return false;
            }
            boolean allowed = ALLOWED_FUNCTIONS_ON_LIST.matches((Tree)methodTree, state);
            if (allowed) {
                this.varUsages.computeIfPresent(ASTHelpers.getSymbol((Tree)receiver), (sym, oldVal) -> oldVal.markAllowedUsageDetected());
            }
            return allowed;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, VisitorState visitorState) {
            this.recordDisallowedUsage(ASTHelpers.getSymbol((Tree)identifierTree));
            return (Void)super.visitIdentifier(identifierTree, visitorState);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, VisitorState visitorState) {
            this.recordDisallowedUsage(ASTHelpers.getSymbol((Tree)memberSelectTree));
            return (Void)super.visitMemberSelect(memberSelectTree, visitorState);
        }

        private void recordDisallowedUsage(Symbol symbol) {
            this.varUsages.computeIfPresent(symbol, (sym, oldVal) -> oldVal.markDisallowedUsageDetected());
        }
    }

    static enum UsageState {
        NEVER_USED,
        ONLY_ALLOWED_USAGE,
        DISALLOWED_USAGE;


        UsageState markAllowedUsageDetected() {
            if (this == DISALLOWED_USAGE) {
                return DISALLOWED_USAGE;
            }
            return ONLY_ALLOWED_USAGE;
        }

        UsageState markDisallowedUsageDetected() {
            return DISALLOWED_USAGE;
        }

        boolean shouldReport() {
            return this == ONLY_ALLOWED_USAGE;
        }
    }
}

