/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.Reachability;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.PatternTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import org.jspecify.annotations.Nullable;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This if-chain may be converted into a switch")
public final class IfChainToSwitch
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final ImmutableSet<Tree.Kind> KINDS_CONVERTIBLE_WITHOUT_BRACES = ImmutableSet.of((Object)((Object)Tree.Kind.THROW), (Object)((Object)Tree.Kind.EXPRESSION_STATEMENT));
    private static final Matcher<ExpressionTree> COMPILE_TIME_CONSTANT_MATCHER = CompileTimeConstantExpressionMatcher.instance();
    private final boolean enableMain;
    private final int maxChainLength;

    @Inject
    IfChainToSwitch(ErrorProneFlags flags) {
        this.enableMain = flags.getBoolean("IfChainToSwitch:EnableMain").orElse(false);
        this.maxChainLength = flags.getInteger("IfChainToSwitch:MaxChainLength").orElse(50);
    }

    public Description matchIf(IfTree ifTree, VisitorState visitorState) {
        if (!this.enableMain) {
            return Description.NO_MATCH;
        }
        if (!SourceVersion.supportsPatternMatchingSwitch((Context)visitorState.context)) {
            return Description.NO_MATCH;
        }
        return this.analyzeIfTree(ifTree, visitorState);
    }

    private Description analyzeIfTree(IfTree ifTree, VisitorState state) {
        for (Tree tree : state.getPath().getParentPath()) {
            if (!(tree instanceof IfTree)) continue;
            return Description.NO_MATCH;
        }
        Range<Integer> ifTreeSourceRange = IfChainToSwitch.computeIfTreeSourceRange(ifTree, state);
        IfChainAnalysisState ifChainAnalysisState = new IfChainAnalysisState(Optional.empty(), 1, Validity.MAYBE_VALID, ifTree, true, (ImmutableSet<String>)ImmutableSet.of());
        ArrayList<CaseIr> cases = new ArrayList<CaseIr>();
        int iteration = 0;
        while (ifChainAnalysisState.validity().equals((Object)Validity.MAYBE_VALID)) {
            ifChainAnalysisState = IfChainToSwitch.analyzeIfStatement(ifChainAnalysisState, ifChainAnalysisState.at().getCondition(), ifChainAnalysisState.at().getThenStatement(), ifChainAnalysisState.at().getElseStatement(), cases, state, ifTreeSourceRange);
            if (iteration > this.maxChainLength) {
                return Description.NO_MATCH;
            }
            ++iteration;
        }
        if (!ifChainAnalysisState.validity().equals((Object)Validity.VALID) || ifChainAnalysisState.depth() < 3) {
            return Description.NO_MATCH;
        }
        java.util.List<SuggestedFix> suggestedFixes = IfChainToSwitch.deepAnalysisOfIfChain(cases, ifChainAnalysisState, ifTree, state, ifTreeSourceRange);
        return suggestedFixes.isEmpty() ? Description.NO_MATCH : this.buildDescription(ifTree).addAllFixes(suggestedFixes).build();
    }

    private static Range<Integer> computeIfTreeSourceRange(IfTree ifTree, VisitorState state) {
        ImmutableList<StatementTree> subsequentIfStatements = IfChainToSwitch.getSubsequentStatementsInBlock(state);
        if (subsequentIfStatements.isEmpty()) {
            return Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)ifTree)), (Comparable)Integer.valueOf(state.getEndPosition((Tree)ifTree)));
        }
        return Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)ifTree)), (Comparable)Integer.valueOf(state.getEndPosition((Tree)subsequentIfStatements.get(0))));
    }

    private static StatementTree stripUnnecessaryBracesForArrowRhs(StatementTree statementTree) {
        BlockTree blockTree;
        StatementTree at = statementTree;
        while (at instanceof BlockTree && (blockTree = (BlockTree)at).getStatements().size() == 1) {
            StatementTree firstStatement = blockTree.getStatements().get(0);
            Tree.Kind firstStatementKind = firstStatement.getKind();
            if (KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)firstStatementKind)) {
                at = firstStatement;
                break;
            }
            if (!(firstStatement instanceof BlockTree)) break;
            at = firstStatement;
        }
        return at;
    }

    public static boolean needsBracesForArrowRhs(StatementTree statementTree) {
        Tree.Kind statementTreeKind = statementTree.getKind();
        if (statementTree instanceof BlockTree) {
            return false;
        }
        return !KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)statementTreeKind);
    }

    private static String prettyPrint(java.util.List<CaseIr> cases, ExpressionTree subject, VisitorState state, SuggestedFix.Builder suggestedFixBuilder, Range<Integer> ifTreeSourceRange, ImmutableList<ErrorProneComment> allComments) {
        StringBuilder sb = new StringBuilder();
        sb.append("switch (").append(state.getSourceForNode((Tree)subject)).append(") {\n");
        for (CaseIr caseIr : cases) {
            if (caseIr.hasCaseNull()) {
                sb.append("case null");
            } else if (caseIr.hasDefault()) {
                sb.append("default");
            } else if (caseIr.expressionsOptional().isPresent()) {
                sb.append("case ");
                sb.append(caseIr.expressionsOptional().get().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(",")));
                sb.append(" ");
            } else if (caseIr.instanceOfOptional().isPresent()) {
                InstanceOfIr instanceOfIr = caseIr.instanceOfOptional().get();
                sb.append("case ");
                if (instanceOfIr.patternVariable() != null) {
                    sb.append(IfChainToSwitch.printRawTypesAsWildcards(ASTHelpers.getType((Tree)instanceOfIr.patternVariable()), state, suggestedFixBuilder));
                    Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)instanceOfIr.patternVariable());
                    sb.append(" ").append(((Symbol)sym).getSimpleName()).append(" ");
                } else if (instanceOfIr.type() != null && instanceOfIr.expression() != null) {
                    sb.append(IfChainToSwitch.printRawTypesAsWildcards(ASTHelpers.getType((Tree)instanceOfIr.type()), state, suggestedFixBuilder));
                    sb.append(" unused ");
                }
                if (caseIr.guardOptional().isPresent()) {
                    sb.append("when ").append(state.getSourceForNode((Tree)caseIr.guardOptional().get()));
                }
            }
            sb.append(" -> ");
            int ifTreeStart = (Integer)ifTreeSourceRange.lowerEndpoint();
            if (caseIr.arrowRhsOptional().isEmpty()) {
                sb.append("{}");
            } else {
                String renderedOrphans;
                StatementTree stripped = IfChainToSwitch.stripUnnecessaryBracesForArrowRhs(caseIr.arrowRhsOptional().get());
                Range printedRange = Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)stripped)), (Comparable)Integer.valueOf(state.getEndPosition((Tree)stripped)));
                ImmutableList orphanedComments = (ImmutableList)allComments.stream().filter(comment -> caseIr.caseSourceCodeRange().encloses(IfChainToSwitch.buildCommentRange(comment, ifTreeStart))).filter(comment -> !IfChainToSwitch.buildCommentRange(comment, ifTreeStart).isConnected(printedRange)).collect(ImmutableList.toImmutableList());
                boolean needsBraces = IfChainToSwitch.needsBracesForArrowRhs(stripped);
                if (needsBraces) {
                    sb.append("{");
                }
                if (!(renderedOrphans = IfChainToSwitch.renderComments((ImmutableList<ErrorProneComment>)orphanedComments)).isEmpty()) {
                    sb.append("\n").append(renderedOrphans).append("\n");
                }
                sb.append(state.getSourceForNode((Tree)stripped));
                if (needsBraces) {
                    sb.append("}");
                }
            }
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static Range<Integer> buildCommentRange(ErrorProneComment comment, int ifTreeStart) {
        return Range.closedOpen((Comparable)Integer.valueOf(comment.getPos() + ifTreeStart), (Comparable)Integer.valueOf(comment.getEndPos() + ifTreeStart));
    }

    private static String renderComments(ImmutableList<ErrorProneComment> comments) {
        return comments.stream().map(ErrorProneComment::getText).filter(commentText -> !commentText.isEmpty()).collect(Collectors.joining("\n"));
    }

    private static String printRawTypesAsWildcards(Type type, VisitorState state, SuggestedFix.Builder suggestedFixBuilder) {
        StringBuilder sb = new StringBuilder();
        List<Symbol.TypeVariableSymbol> typeParameters = type.tsym.getTypeParameters();
        List<Type> typeArguments = type.getTypeArguments();
        Types types = state.getTypes();
        if (types.isArray(type)) {
            Type at = type;
            StringBuilder suffix = new StringBuilder();
            while (types.isArray(at)) {
                suffix.append("[]");
                at = types.elemtype(at);
            }
            sb.append(at.isPrimitive() ? SuggestedFixes.prettyType((Type)at, (VisitorState)state) : SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)suggestedFixBuilder, (Symbol)at.tsym));
            sb.append((CharSequence)suffix);
        } else {
            sb.append(SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)suggestedFixBuilder, (Symbol)type.tsym));
        }
        if (!typeParameters.isEmpty()) {
            if (typeArguments.isEmpty()) {
                sb.append("<");
                sb.repeat("?,", Math.max(0, typeParameters.size() - 1)).repeat("?", Math.min(1, typeParameters.size()));
                sb.append(">");
            } else {
                sb.append("<");
                sb.append(typeArguments.stream().map(t -> SuggestedFixes.prettyType((Type)t, (VisitorState)state)).collect(Collectors.joining(",")));
                sb.append(">");
            }
        }
        return sb.toString();
    }

    private static Optional<java.util.List<CaseIr>> maybeFixDefaultAndUnconditional(java.util.List<CaseIr> cases, ExpressionTree subject, StatementTree ifTree, VisitorState state, Optional<SuggestedFix.Builder> suggestedFixBuilder, int numberPulledUp, Set<String> handledEnumValues, Type switchType, Range<Integer> ifTreeSourceRange) {
        long canCompleteNormallyBlockCount;
        long emptyRhsBlockCount;
        boolean allEnumValuesPresent;
        boolean hasDefault = cases.stream().anyMatch(CaseIr::hasDefault);
        long unconditionalCount = cases.stream().filter(caseIr -> caseIr.instanceOfOptional().isPresent() && caseIr.guardOptional().isEmpty() && ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)subject), (Type)ASTHelpers.getType((Tree)caseIr.instanceOfOptional().get().type()), (VisitorState)state)).count();
        boolean hasUnconditional = unconditionalCount > 0L;
        boolean hasMultipleUnconditional = unconditionalCount > 1L;
        boolean hasPattern = cases.stream().anyMatch(x -> x.instanceOfOptional().isPresent());
        boolean bl = allEnumValuesPresent = IfChainToSwitch.isEnum(subject, state) && handledEnumValues.containsAll(ASTHelpers.enumValues((Symbol.TypeSymbol)switchType.asElement()));
        if (hasDefault && hasUnconditional) {
            return Optional.empty();
        }
        if (hasMultipleUnconditional) {
            return Optional.empty();
        }
        if (hasPattern && !hasDefault && !hasUnconditional) {
            return Optional.empty();
        }
        if (!(hasPattern || hasDefault || allEnumValuesPresent)) {
            ArrayList<CaseIr> casesCopy = new ArrayList<CaseIr>(cases);
            int previousCaseEndPosition = cases.stream().map(CaseIr::caseSourceCodeRange).mapToInt(Range::upperEndpoint).max().orElse((Integer)ifTreeSourceRange.lowerEndpoint());
            casesCopy.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(previousCaseEndPosition))));
            cases = casesCopy;
        }
        if (suggestedFixBuilder.isPresent() && (emptyRhsBlockCount = cases.stream().filter(caseIr -> caseIr.arrowRhsOptional().isEmpty()).count()) + (canCompleteNormallyBlockCount = cases.stream().filter(caseIr -> caseIr.arrowRhsOptional().isPresent() && Reachability.canCompleteNormally((StatementTree)caseIr.arrowRhsOptional().get(), (ImmutableMap)ImmutableMap.of())).count()) == 0L) {
            StatementTree cannotCompleteNormallyTree = ifTree;
            Tree prev = state.getPath().getLeaf();
            for (Tree tree : state.getPath().getParentPath()) {
                if (tree instanceof BlockTree) {
                    BlockTree blockTree = (BlockTree)tree;
                    java.util.List<? extends StatementTree> statements = blockTree.getStatements();
                    int indexInBlock = statements.indexOf(prev);
                    boolean nextStatementReachable = Reachability.canCompleteNormally((StatementTree)statements.get(indexInBlock), (ImmutableMap)ImmutableMap.of((Object)cannotCompleteNormallyTree, (Object)false));
                    cannotCompleteNormallyTree = blockTree;
                    if (nextStatementReachable) break;
                    if (indexInBlock + numberPulledUp < statements.size() - 1) {
                        String deletedRegion = state.getSourceCode().subSequence(state.getEndPosition((Tree)statements.get(indexInBlock + numberPulledUp)), state.getEndPosition((Tree)blockTree)).toString();
                        if (deletedRegion.contains("LINT.")) {
                            statements.subList(indexInBlock + 1, statements.size()).forEach(arg_0 -> ((SuggestedFix.Builder)suggestedFixBuilder.get()).delete(arg_0));
                        } else {
                            suggestedFixBuilder.get().replace(state.getEndPosition((Tree)statements.get(indexInBlock)), state.getEndPosition((Tree)blockTree), "}");
                        }
                    }
                }
                numberPulledUp = 0;
                prev = tree;
            }
        }
        return Optional.of(cases);
    }

    private static Optional<java.util.List<CaseIr>> maybePullUp(java.util.List<CaseIr> cases, VisitorState state, IfChainAnalysisState ifChainAnalysisState, Optional<SuggestedFix.Builder> suggestedFixBuilder, Range<Integer> ifTreeRange) {
        if (ifChainAnalysisState.subjectOptional().isEmpty()) {
            return Optional.empty();
        }
        ArrayList<CaseIr> casesCopy = new ArrayList<CaseIr>(cases);
        if (ifChainAnalysisState.at().getElseStatement() == null && ifChainAnalysisState.allConditionalBlocksReturnOrThrow()) {
            ImmutableList<StatementTree> subsequentIfStatements = IfChainToSwitch.getSubsequentStatementsInBlock(state);
            int subsequentStatementsLimit = 1;
            if (subsequentIfStatements.size() <= subsequentStatementsLimit) {
                StatementTree statement;
                UnmodifiableIterator unmodifiableIterator = subsequentIfStatements.iterator();
                while (unmodifiableIterator.hasNext() && !IfChainToSwitch.hasBreakOrYieldInTree(statement = (StatementTree)unmodifiableIterator.next())) {
                    int startPos = casesCopy.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)((CaseIr)casesCopy.getLast()).caseSourceCodeRange().upperEndpoint();
                    int endPos = state.getEndPosition((Tree)statement);
                    casesCopy.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(statement), (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(startPos), (Comparable)Integer.valueOf(endPos))));
                    if (!suggestedFixBuilder.isPresent()) continue;
                    suggestedFixBuilder.get().delete((Tree)statement);
                }
            }
        }
        return Optional.of(casesCopy);
    }

    private static Optional<java.util.List<CaseIr>> maybeDetectDuplicateConstants(java.util.List<CaseIr> cases) {
        HashSet<Object> seenConstants = new HashSet<Object>();
        for (CaseIr caseIr : cases) {
            if (!caseIr.expressionsOptional().isPresent()) continue;
            for (ExpressionTree expression : caseIr.expressionsOptional().get()) {
                Symbol sym;
                Object constant = ASTHelpers.constValue((Tree)expression);
                if (constant != null) {
                    if (seenConstants.contains(constant)) {
                        return Optional.empty();
                    }
                    seenConstants.add(constant);
                }
                if ((sym = ASTHelpers.getSymbol((Tree)expression)) == null || sym.getKind() != ElementKind.ENUM_CONSTANT) continue;
                if (seenConstants.contains(sym)) {
                    return Optional.empty();
                }
                seenConstants.add(sym);
            }
        }
        return Optional.of(cases);
    }

    private static Optional<java.util.List<CaseIr>> maybeFixDominance(java.util.List<CaseIr> cases, VisitorState state, ExpressionTree subject) {
        ArrayList<CaseIr> casesCopy = new ArrayList<CaseIr>(cases);
        ArrayList<CaseIr> casesToInsert = new ArrayList<CaseIr>();
        for (int insert = 0; insert < casesCopy.size(); ++insert) {
            casesToInsert.add((CaseIr)casesCopy.get(insert));
            if (!IfChainToSwitch.hasDominanceViolation(casesToInsert, state, subject)) continue;
            casesToInsert.remove(casesToInsert.size() - 1);
            ArrayList<CaseIr> temp = new ArrayList<CaseIr>();
            boolean cleanedUp = false;
            for (int insertPos = casesToInsert.size() - 1; insertPos >= 0; --insertPos) {
                temp.clear();
                int readIndex = 0;
                for (int i = 0; i < insertPos; ++i) {
                    temp.add((CaseIr)casesToInsert.get(readIndex++));
                }
                temp.add((CaseIr)casesCopy.get(insert));
                while (readIndex < casesToInsert.size()) {
                    temp.add((CaseIr)casesToInsert.get(readIndex));
                    ++readIndex;
                }
                if (IfChainToSwitch.hasDominanceViolation(temp, state, subject)) continue;
                cleanedUp = true;
                break;
            }
            if (cleanedUp) {
                casesToInsert = temp;
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(casesToInsert);
    }

    private static boolean hasDominanceViolation(java.util.List<CaseIr> cases, VisitorState state, ExpressionTree subject) {
        ArrayList<CaseIr> casesCopy = new ArrayList<CaseIr>(cases);
        for (int r = 1; r < casesCopy.size(); ++r) {
            for (int l = 0; l < r; ++l) {
                CaseIr caseR = (CaseIr)casesCopy.get(r);
                CaseIr caseL = (CaseIr)casesCopy.get(l);
                boolean violation = IfChainToSwitch.isDominatedBy(caseL, caseR, state, subject);
                if (!violation) continue;
                return true;
            }
        }
        return false;
    }

    private static IfChainAnalysisState analyzeIfStatement(IfChainAnalysisState ifChainAnalysisState, ExpressionTree condition, StatementTree conditionalBlock, StatementTree elseStatement, java.util.List<CaseIr> cases, VisitorState state, Range<Integer> ifTreeRange) {
        if (ifChainAnalysisState.validity().equals((Object)Validity.INVALID)) {
            return ifChainAnalysisState;
        }
        boolean conditionalBlockCanCompleteNormally = conditionalBlock == null || Reachability.canCompleteNormally((StatementTree)conditionalBlock);
        HashSet<String> handledEnumValues = new HashSet<String>((Collection<String>)ifChainAnalysisState.handledEnumValues());
        int caseStartPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
        Optional<ExpressionTree> newSubjectOptional = IfChainToSwitch.validatePredicateForSubject(condition, ifChainAnalysisState.subjectOptional(), state, false, cases, Optional.ofNullable(elseStatement), Optional.ofNullable(conditionalBlock), handledEnumValues, ifTreeRange, caseStartPosition);
        if (newSubjectOptional.isEmpty()) {
            return new IfChainAnalysisState(Optional.empty(), ifChainAnalysisState.depth() + 1, Validity.INVALID, ifChainAnalysisState.at(), ifChainAnalysisState.allConditionalBlocksReturnOrThrow() && !conditionalBlockCanCompleteNormally, (ImmutableSet<String>)ImmutableSet.copyOf(handledEnumValues));
        }
        if (!(elseStatement instanceof IfTree)) {
            return new IfChainAnalysisState(ifChainAnalysisState.subjectOptional(), ifChainAnalysisState.depth(), Validity.VALID, ifChainAnalysisState.at(), ifChainAnalysisState.allConditionalBlocksReturnOrThrow() && !conditionalBlockCanCompleteNormally, (ImmutableSet<String>)ImmutableSet.copyOf(handledEnumValues));
        }
        IfTree elseStatementIfTree = (IfTree)elseStatement;
        return new IfChainAnalysisState(newSubjectOptional, ifChainAnalysisState.depth() + 1, ifChainAnalysisState.validity(), elseStatementIfTree, ifChainAnalysisState.allConditionalBlocksReturnOrThrow() && !conditionalBlockCanCompleteNormally, (ImmutableSet<String>)ImmutableSet.copyOf(handledEnumValues));
    }

    private static boolean isEnum(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().enumSym.type, (VisitorState)state);
    }

    private static boolean hasBreakOrYieldInTree(Tree tree) {
        Boolean result = (Boolean)new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitBreak(BreakTree breakTree, Void unused) {
                return true;
            }

            @Override
            public Boolean visitYield(YieldTree continueTree, Void unused) {
                return true;
            }

            @Override
            public Boolean reduce(@Nullable Boolean left, @Nullable Boolean right) {
                return Objects.equals(left, true) || Objects.equals(right, true);
            }
        }.scan(tree, null);
        return result != null && result != false;
    }

    private static Optional<ExpressionTree> validatePredicateForSubject(ExpressionTree predicate, Optional<ExpressionTree> subject, VisitorState state, boolean mustBeInstanceOf, java.util.List<CaseIr> cases, Optional<StatementTree> elseOptional, Optional<StatementTree> arrowRhsOptional, Set<String> handledEnumValues, Range<Integer> ifTreeRange, int caseStartPosition) {
        int caseEndPosition = elseOptional.isPresent() ? ASTHelpers.getStartPosition((Tree)elseOptional.get()) : (arrowRhsOptional.isPresent() ? state.getEndPosition((Tree)arrowRhsOptional.get()) : state.getEndPosition((Tree)predicate));
        boolean hasElse = elseOptional.isPresent();
        boolean hasElseIf = hasElse && elseOptional.get() instanceof IfTree;
        ExpressionTree at = ASTHelpers.stripParentheses((ExpressionTree)predicate);
        InstanceOfTree instanceOfTree = null;
        if (at instanceof InstanceOfTree) {
            InstanceOfTree iot;
            instanceOfTree = iot = (InstanceOfTree)at;
            at = iot.getExpression();
        }
        if (at instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)at;
            ExpressionTree lhs = binaryTree.getLeftOperand();
            ExpressionTree rhs = binaryTree.getRightOperand();
            boolean predicateIsEquality = binaryTree.getKind().equals((Object)Tree.Kind.EQUAL_TO);
            boolean predicateIsConditionalAnd = binaryTree.getKind().equals((Object)Tree.Kind.CONDITIONAL_AND);
            if (!mustBeInstanceOf && predicateIsEquality) {
                if (COMPILE_TIME_CONSTANT_MATCHER.matches((Tree)lhs, state) || COMPILE_TIME_CONSTANT_MATCHER.matches((Tree)rhs, state)) {
                    return IfChainToSwitch.validateCompileTimeConstantForSubject(lhs, rhs, subject, state, cases, elseOptional, arrowRhsOptional, ifTreeRange, caseEndPosition, hasElse, hasElseIf);
                }
                if (IfChainToSwitch.isEnum(lhs, state) || IfChainToSwitch.isEnum(rhs, state)) {
                    return IfChainToSwitch.validateEnumPredicateForSubject(lhs, rhs, subject, state, cases, elseOptional, arrowRhsOptional, handledEnumValues, ifTreeRange, caseEndPosition, hasElse, hasElseIf);
                }
                return Optional.empty();
            }
            if (predicateIsConditionalAnd && !mustBeInstanceOf && binaryTree.getKind().equals((Object)Tree.Kind.CONDITIONAL_AND)) {
                int currentCasesSize = cases.size();
                Optional<ExpressionTree> rv = IfChainToSwitch.validatePredicateForSubject(binaryTree.getLeftOperand(), subject, state, true, cases, elseOptional, arrowRhsOptional, handledEnumValues, ifTreeRange, caseStartPosition);
                if (rv.isPresent()) {
                    CaseIr oldLastCase = cases.get(currentCasesSize);
                    cases.set(currentCasesSize, new CaseIr(oldLastCase.hasCaseNull(), oldLastCase.hasDefault(), oldLastCase.instanceOfOptional(), Optional.of(binaryTree.getRightOperand()), oldLastCase.expressionsOptional(), oldLastCase.arrowRhsOptional(), oldLastCase.caseSourceCodeRange()));
                    return rv;
                }
            }
        }
        if (instanceOfTree != null) {
            return IfChainToSwitch.validateInstanceofForSubject(at, instanceOfTree, subject, state, cases, elseOptional, arrowRhsOptional, ifTreeRange, caseEndPosition, hasElse, hasElseIf);
        }
        return Optional.empty();
    }

    private static Optional<ExpressionTree> validateInstanceofForSubject(ExpressionTree at, InstanceOfTree instanceOfTree, Optional<ExpressionTree> subject, VisitorState state, java.util.List<CaseIr> cases, Optional<StatementTree> elseOptional, Optional<StatementTree> arrowRhsOptional, Range<Integer> ifTreeRange, int caseEndPosition, boolean hasElse, boolean hasElseIf) {
        ExpressionTree expression = at;
        if (subject.isPresent() && !ASTHelpers.sameVariable((ExpressionTree)subject.get(), (ExpressionTree)expression) && !subject.get().equals(expression) && !IfChainToSwitch.expressionSourceMatches(subject, expression, state)) {
            return Optional.empty();
        }
        PatternTree patternTree = instanceOfTree.getPattern();
        if (patternTree instanceof BindingPatternTree) {
            BindingPatternTree bpt = (BindingPatternTree)patternTree;
            boolean addDefault = hasElse && !hasElseIf;
            int previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
            cases.add(new CaseIr(false, false, Optional.of(new InstanceOfIr(instanceOfTree.getExpression(), bpt.getVariable(), instanceOfTree.getType())), Optional.empty(), Optional.empty(), arrowRhsOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(caseEndPosition))));
            if (addDefault) {
                previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
                cases.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), elseOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(caseEndPosition), (Comparable)Integer.valueOf(elseOptional.isPresent() ? ASTHelpers.getStartPosition((Tree)elseOptional.get()) : caseEndPosition))));
            }
        } else if (instanceOfTree.getType() != null) {
            boolean addDefault = hasElse && !hasElseIf;
            int previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
            cases.add(new CaseIr(false, false, Optional.of(new InstanceOfIr(instanceOfTree.getExpression(), null, instanceOfTree.getType())), Optional.empty(), Optional.empty(), arrowRhsOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(caseEndPosition))));
            if (addDefault) {
                cases.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), elseOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(caseEndPosition), (Comparable)Integer.valueOf(elseOptional.isPresent() ? state.getEndPosition((Tree)elseOptional.get()) : caseEndPosition))));
            }
        } else {
            return Optional.empty();
        }
        return Optional.of(expression);
    }

    private static Optional<ExpressionTree> validateCompileTimeConstantForSubject(ExpressionTree lhs, ExpressionTree rhs, Optional<ExpressionTree> subject, VisitorState state, java.util.List<CaseIr> cases, Optional<StatementTree> elseOptional, Optional<StatementTree> arrowRhsOptional, Range<Integer> ifTreeRange, int caseEndPosition, boolean hasElse, boolean hasElseIf) {
        ExpressionTree compileTimeConstant;
        boolean compileTimeConstantOnLhs = COMPILE_TIME_CONSTANT_MATCHER.matches((Tree)lhs, state);
        ExpressionTree testExpression = compileTimeConstantOnLhs ? rhs : lhs;
        ExpressionTree expressionTree = compileTimeConstant = compileTimeConstantOnLhs ? lhs : rhs;
        if (subject.isPresent() && !ASTHelpers.sameVariable((ExpressionTree)subject.get(), (ExpressionTree)testExpression) && !subject.get().equals(testExpression) && !IfChainToSwitch.expressionSourceMatches(subject, testExpression, state)) {
            return Optional.empty();
        }
        if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)testExpression), (Type)((Type)Suppliers.JAVA_LANG_BOOLEAN_TYPE.get(state)), (VisitorState)state)) {
            return Optional.empty();
        }
        if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)testExpression), (Type)state.getSymtab().stringType, (VisitorState)state)) {
            return Optional.empty();
        }
        if (state.getTypes().isSameType(ASTHelpers.getType((Tree)testExpression), state.getSymtab().longType)) {
            return Optional.empty();
        }
        boolean addDefault = hasElse && !hasElseIf;
        int previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
        cases.add(new CaseIr(compileTimeConstant.getKind() == Tree.Kind.NULL_LITERAL, false, Optional.empty(), Optional.empty(), Optional.of(ImmutableList.of((Object)compileTimeConstant)), arrowRhsOptional, (Range<Integer>)Range.openClosed((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(caseEndPosition))));
        if (addDefault) {
            previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
            cases.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), elseOptional, (Range<Integer>)Range.openClosed((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(elseOptional.isPresent() ? ASTHelpers.getStartPosition((Tree)elseOptional.get()) : caseEndPosition))));
        }
        return Optional.of(testExpression);
    }

    private static Optional<ExpressionTree> validateEnumPredicateForSubject(ExpressionTree lhs, ExpressionTree rhs, Optional<ExpressionTree> subject, VisitorState state, java.util.List<CaseIr> cases, Optional<StatementTree> elseOptional, Optional<StatementTree> arrowRhsOptional, Set<String> handledEnumValues, Range<Integer> ifTreeRange, int caseEndPosition, boolean hasElse, boolean hasElseIf) {
        ExpressionTree testExpression;
        boolean rhsIsEnumConstant;
        boolean lhsIsEnumConstant = IfChainToSwitch.isEnum(lhs, state) && ASTHelpers.getSymbol((Tree)lhs) != null && ASTHelpers.getSymbol((Tree)lhs).getKind() == ElementKind.ENUM_CONSTANT;
        boolean bl = rhsIsEnumConstant = IfChainToSwitch.isEnum(rhs, state) && ASTHelpers.getSymbol((Tree)rhs) != null && ASTHelpers.getSymbol((Tree)rhs).getKind() == ElementKind.ENUM_CONSTANT;
        if (lhsIsEnumConstant && rhsIsEnumConstant) {
            return Optional.empty();
        }
        if (!lhsIsEnumConstant && !rhsIsEnumConstant) {
            return Optional.empty();
        }
        ExpressionTree compileTimeConstant = lhsIsEnumConstant ? lhs : rhs;
        ExpressionTree expressionTree = testExpression = lhsIsEnumConstant ? rhs : lhs;
        if (subject.isPresent() && !ASTHelpers.sameVariable((ExpressionTree)subject.get(), (ExpressionTree)testExpression) && !subject.get().equals(testExpression) && !IfChainToSwitch.expressionSourceMatches(subject, testExpression, state)) {
            return Optional.empty();
        }
        handledEnumValues.addAll((Collection)Stream.of(compileTimeConstant).map(ASTHelpers::getSymbol).filter(x -> x != null).map(symbol -> symbol.getSimpleName().toString()).collect(ImmutableSet.toImmutableSet()));
        boolean addDefault = hasElse && !hasElseIf;
        int previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
        cases.add(new CaseIr(false, false, Optional.empty(), Optional.empty(), Optional.of(ImmutableList.of((Object)compileTimeConstant)), arrowRhsOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(previousCaseEndPosition), (Comparable)Integer.valueOf(caseEndPosition))));
        if (addDefault) {
            previousCaseEndPosition = cases.isEmpty() ? (Integer)ifTreeRange.lowerEndpoint() : (Integer)cases.getLast().caseSourceCodeRange().upperEndpoint();
            cases.add(new CaseIr(false, true, Optional.empty(), Optional.empty(), Optional.empty(), elseOptional, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(caseEndPosition), (Comparable)Integer.valueOf(elseOptional.isPresent() ? state.getEndPosition((Tree)elseOptional.get()) : caseEndPosition))));
        }
        return Optional.of(testExpression);
    }

    private static boolean expressionSourceMatches(Optional<ExpressionTree> subject, ExpressionTree expression, VisitorState state) {
        return subject.isPresent() && state.getSourceForNode((Tree)subject.get()).equals(state.getSourceForNode((Tree)expression));
    }

    private static ImmutableList<StatementTree> getSubsequentStatementsInBlock(VisitorState state) {
        TreePath path = state.getPath();
        Tree tree = path.getParentPath().getLeaf();
        if (!(tree instanceof BlockTree)) {
            return ImmutableList.of();
        }
        BlockTree blockTree = (BlockTree)tree;
        java.util.List<? extends StatementTree> statements = blockTree.getStatements();
        return ImmutableList.copyOf(statements.subList(statements.indexOf(path.getLeaf()) + 1, statements.size()));
    }

    private static Optional<Type> unboxed(Tree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null || !type.isReference()) {
            return Optional.empty();
        }
        Type unboxed = state.getTypes().unboxedType(type);
        if (unboxed == null || unboxed.getTag() == TypeTag.NONE || unboxed.getTag() == TypeTag.VOID) {
            return Optional.empty();
        }
        return Optional.of(unboxed);
    }

    public static @Nullable Type intersectTypes(Type type1, Type type2, VisitorState state) {
        Type lower = null;
        if (ASTHelpers.isSubtype((Type)type1, (Type)type2, (VisitorState)state)) {
            lower = type1;
        }
        if (ASTHelpers.isSubtype((Type)type2, (Type)type1, (VisitorState)state)) {
            lower = type2;
        }
        return lower;
    }

    private static java.util.List<SuggestedFix> deepAnalysisOfIfChain(java.util.List<CaseIr> cases, IfChainAnalysisState finalIfChainAnalysisState, IfTree ifTree, VisitorState state, Range<Integer> ifTreeSourceRange) {
        if (IfChainToSwitch.hasBreakOrYieldInTree(ifTree)) {
            return new ArrayList<SuggestedFix>();
        }
        ExpressionTree subject = finalIfChainAnalysisState.subjectOptional().get();
        SuggestedFix.Builder suggestedFixBuilderWithPullupEnabled = SuggestedFix.builder();
        Optional casesWithPullupMaybeApplied = Optional.of(cases).flatMap(caseList -> IfChainToSwitch.maybePullUp(caseList, state, finalIfChainAnalysisState, Optional.of(suggestedFixBuilderWithPullupEnabled), ifTreeSourceRange));
        int numberPulledUp = casesWithPullupMaybeApplied.isEmpty() ? 0 : ((java.util.List)casesWithPullupMaybeApplied.get()).size() - cases.size();
        Type switchType = ASTHelpers.getType((Tree)finalIfChainAnalysisState.subjectOptional().get());
        Optional<java.util.List<CaseIr>> fixedCasesOptional = casesWithPullupMaybeApplied.flatMap(caseList -> IfChainToSwitch.maybeDetectDuplicateConstants(caseList)).flatMap(caseList -> IfChainToSwitch.maybeFixDominance(caseList, state, subject)).flatMap(x -> IfChainToSwitch.maybeFixDefaultAndUnconditional(x, subject, ifTree, state, Optional.of(suggestedFixBuilderWithPullupEnabled), numberPulledUp, finalIfChainAnalysisState.handledEnumValues(), switchType, ifTreeSourceRange));
        SuggestedFix.Builder suggestedFixBuilderWithoutPullup = SuggestedFix.builder();
        boolean pullupDisabled = false;
        if (fixedCasesOptional.isEmpty()) {
            pullupDisabled = true;
            fixedCasesOptional = Optional.of(cases).flatMap(caseList -> IfChainToSwitch.maybeDetectDuplicateConstants(caseList)).flatMap(caseList -> IfChainToSwitch.maybeFixDominance(caseList, state, subject)).flatMap(caseList -> IfChainToSwitch.maybeFixDefaultAndUnconditional(caseList, subject, ifTree, state, Optional.of(suggestedFixBuilderWithoutPullup), 0, finalIfChainAnalysisState.handledEnumValues(), switchType, ifTreeSourceRange));
        }
        ArrayList<SuggestedFix> suggestedFixes = new ArrayList<SuggestedFix>();
        IfChainToSwitch.maybeBuildAndAddSuggestedFix(fixedCasesOptional, pullupDisabled ? suggestedFixBuilderWithoutPullup : suggestedFixBuilderWithPullupEnabled, finalIfChainAnalysisState, ifTree, state, ifTreeSourceRange, suggestedFixes);
        return suggestedFixes;
    }

    private static void maybeBuildAndAddSuggestedFix(Optional<java.util.List<CaseIr>> fixedCasesOptional, SuggestedFix.Builder suggestedFixBuilder, IfChainAnalysisState ifChainAnalysisState, IfTree ifTree, VisitorState state, Range<Integer> ifTreeSourceRange, java.util.List<SuggestedFix> suggestedFixes) {
        if (fixedCasesOptional.isPresent()) {
            java.util.List<CaseIr> fixedCases = fixedCasesOptional.get();
            ImmutableList allComments = (ImmutableList)state.getTokensForNode((Tree)ifTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
            suggestedFixBuilder.replace((Tree)ifTree, IfChainToSwitch.prettyPrint(fixedCases, ifChainAnalysisState.subjectOptional().get(), state, suggestedFixBuilder, ifTreeSourceRange, (ImmutableList<ErrorProneComment>)allComments));
            suggestedFixes.add(suggestedFixBuilder.build());
        }
    }

    public static boolean isDominatedBy(CaseIr lhs, CaseIr rhs, VisitorState state, ExpressionTree subject) {
        if (rhs.hasDefault()) {
            return false;
        }
        if (rhs.hasCaseNull()) {
            return lhs.hasDefault();
        }
        if (rhs.instanceOfOptional().isEmpty()) {
            for (ExpressionTree constantExpression : rhs.expressionsOptional().get()) {
                InstanceOfIr instanceOfIr;
                boolean isPrimitive = ASTHelpers.getType((Tree)constantExpression).isPrimitive();
                if (isPrimitive) {
                    if (lhs.guardOptional().isPresent() || !lhs.instanceOfOptional().isPresent()) continue;
                    InstanceOfIr instanceOfIr2 = lhs.instanceOfOptional().get();
                    if (instanceOfIr2.type() != null) {
                        Optional<Type> unboxedInstanceOfType = IfChainToSwitch.unboxed(instanceOfIr2.type(), state);
                        if (unboxedInstanceOfType.isPresent()) {
                            if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)constantExpression), (Type)unboxedInstanceOfType.get(), (VisitorState)state)) continue;
                            return true;
                        }
                        return true;
                    }
                    if (instanceOfIr2.patternVariable() == null) continue;
                    VariableTree patternVariable = instanceOfIr2.patternVariable();
                    Type patternType = ASTHelpers.getType((Tree)patternVariable);
                    if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)constantExpression), (Type)patternType, (VisitorState)state)) continue;
                    return true;
                }
                boolean isEnum = IfChainToSwitch.isEnum(constantExpression, state);
                if (isEnum) {
                    if (lhs.guardOptional().isPresent() || !lhs.instanceOfOptional().isPresent()) continue;
                    instanceOfIr = lhs.instanceOfOptional().get();
                    if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)constantExpression), (Type)ASTHelpers.getType((Tree)instanceOfIr.type()), (VisitorState)state)) continue;
                    return true;
                }
                if (lhs.guardOptional().isPresent() || !lhs.instanceOfOptional().isPresent()) continue;
                instanceOfIr = lhs.instanceOfOptional().get();
                Type subjectType = ASTHelpers.getType((Tree)subject);
                if (instanceOfIr.type() == null) continue;
                Tree instanceOfType = instanceOfIr.type();
                if (!ASTHelpers.isSubtype((Type)IfChainToSwitch.intersectTypes(ASTHelpers.getType((Tree)constantExpression), subjectType, state), (Type)IfChainToSwitch.intersectTypes(ASTHelpers.getType((Tree)instanceOfType), subjectType, state), (VisitorState)state)) continue;
                return true;
            }
            return false;
        }
        if (lhs.hasDefault() || lhs.hasCaseNull()) {
            return true;
        }
        if (lhs.guardOptional().isPresent()) {
            return false;
        }
        if (lhs.instanceOfOptional().isPresent()) {
            Type rhsType;
            Type lhsType = lhs.instanceOfOptional().get().type() != null ? ASTHelpers.getType((Tree)lhs.instanceOfOptional().get().type()) : ASTHelpers.getType((Tree)lhs.instanceOfOptional().get().patternVariable().getType());
            InstanceOfIr rhsInstanceOf = rhs.instanceOfOptional().get();
            Type type = rhsType = rhsInstanceOf.type() != null ? ASTHelpers.getType((Tree)rhsInstanceOf.type()) : ASTHelpers.getType((Tree)rhsInstanceOf.patternVariable().getType());
            if (ASTHelpers.isSubtype((Type)rhsType, (Type)lhsType, (VisitorState)state)) {
                return true;
            }
        }
        return false;
    }

    record IfChainAnalysisState(Optional<ExpressionTree> subjectOptional, int depth, Validity validity, IfTree at, boolean allConditionalBlocksReturnOrThrow, ImmutableSet<String> handledEnumValues) {
    }

    static enum Validity {
        MAYBE_VALID,
        INVALID,
        VALID;

    }

    record CaseIr(boolean hasCaseNull, boolean hasDefault, Optional<InstanceOfIr> instanceOfOptional, Optional<ExpressionTree> guardOptional, Optional<java.util.List<ExpressionTree>> expressionsOptional, Optional<StatementTree> arrowRhsOptional, Range<Integer> caseSourceCodeRange) {
        CaseIr {
            Preconditions.checkArgument((hasCaseNull || hasDefault || instanceOfOptional.isPresent() || expressionsOptional.isPresent() && !expressionsOptional.get().isEmpty() ? 1 : 0) != 0, (Object)"CaseIr must have at least one of case null, default, instanceof, or expressions");
            Preconditions.checkArgument((!hasDefault || !instanceOfOptional.isPresent() && !expressionsOptional.isPresent() ? 1 : 0) != 0, (Object)"Default and instanceof/expressions cannot both be present");
        }
    }

    record InstanceOfIr(@Nullable ExpressionTree expression, @Nullable VariableTree patternVariable, Tree type) {
        InstanceOfIr(@Nullable ExpressionTree expression, @Nullable VariableTree patternVariable, Tree type) {
            Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        }
    }
}

