/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.errorprone.ErrorProneFlags;
import java.util.regex.Pattern;
import javax.inject.Inject;

final class IdentifierNames {
    private final boolean allowInitialismsInTypeName;
    private static final Pattern PROBABLE_INITIALISM = Pattern.compile("([A-Z]{2,})([A-Z][^A-Z]|$)");

    @Inject
    IdentifierNames(ErrorProneFlags flags) {
        this.allowInitialismsInTypeName = flags.getBoolean("IdentifierName:AllowInitialismsInTypeName").orElse(false);
    }

    static boolean isConformantLowerCamelName(String name) {
        return IdentifierNames.underscoresAreFlankedByDigits(name) && !Ascii.isUpperCase((char)name.charAt(0)) && !PROBABLE_INITIALISM.matcher(name).find();
    }

    boolean isConformantTypeName(String name) {
        return IdentifierNames.underscoresAreFlankedByDigits(name) && Ascii.isUpperCase((char)name.charAt(0)) && (this.allowInitialismsInTypeName || !PROBABLE_INITIALISM.matcher(name).find());
    }

    private static boolean underscoresAreFlankedByDigits(String name) {
        if (name.startsWith("_") || name.endsWith("_")) {
            return false;
        }
        for (int i = 1; i < name.length() - 1; ++i) {
            boolean flankedByDigits;
            if (name.charAt(i) != '_') continue;
            boolean bl = flankedByDigits = Character.isDigit(name.charAt(i - 1)) && Character.isDigit(name.charAt(i + 1));
            if (flankedByDigits) continue;
            return false;
        }
        return true;
    }

    String fixInitialismsIfNeeded(String input) {
        return this.allowInitialismsInTypeName ? input : IdentifierNames.fixInitialisms(input);
    }

    static String fixInitialisms(String input) {
        return PROBABLE_INITIALISM.matcher(input).replaceAll(r -> IdentifierNames.titleCase(r.group(1)) + r.group(2));
    }

    private static String titleCase(String input) {
        String lower = Ascii.toLowerCase((String)input);
        return Ascii.toUpperCase((char)lower.charAt(0)) + lower.substring(1);
    }
}

