/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Collections;
import java.util.stream.Collectors;

@BugPattern(summary="Avoid explicit array creation for varargs", severity=BugPattern.SeverityLevel.WARNING)
public final class ExplicitArrayForVarargs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.handle(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.handle(tree, ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
    }

    private Description handle(Tree tree, Symbol.MethodSymbol symbol, java.util.List<? extends ExpressionTree> args, VisitorState state) {
        if (!symbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        if (args.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (Streams.stream((Iterable)state.getPath().getParentPath()).anyMatch(t -> {
            Symbol patt0$temp = ASTHelpers.getSymbol((Tree)t);
            if (!(patt0$temp instanceof Symbol.MethodSymbol)) return false;
            Symbol.MethodSymbol ms = (Symbol.MethodSymbol)patt0$temp;
            if (!ms.owner.equals(symbol.owner)) return false;
            if (!ms.name.contentEquals(symbol.name)) return false;
            return true;
        })) {
            return Description.NO_MATCH;
        }
        if (args.size() != ((List)symbol.getParameters()).size()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = args.getLast();
        if (!(expressionTree instanceof NewArrayTree)) {
            return Description.NO_MATCH;
        }
        NewArrayTree newArrayTree = (NewArrayTree)expressionTree;
        if (((Type.ArrayType)ASTHelpers.getType((Tree)newArrayTree)).getComponentType() instanceof Type.ArrayType) {
            return Description.NO_MATCH;
        }
        java.util.List<? extends ExpressionTree> initializers = newArrayTree.getInitializers();
        if (initializers == null) {
            java.util.List<? extends ExpressionTree> dimensions = newArrayTree.getDimensions();
            if (dimensions == null || dimensions.size() != 1) {
                return Description.NO_MATCH;
            }
            Object object = ASTHelpers.constValue((Tree)((Tree)Iterables.getOnlyElement(dimensions)));
            if (!(object instanceof Integer)) {
                return Description.NO_MATCH;
            }
            Integer dimension = (Integer)object;
            String replacement = Collections.nCopies(dimension, "null").stream().collect(Collectors.joining(", "));
            return this.describeMatch(newArrayTree, (Fix)SuggestedFix.replace((Tree)newArrayTree, (String)replacement));
        }
        SuggestedFix fix = initializers.isEmpty() ? SuggestedFixes.removeElement((Tree)newArrayTree, args, (VisitorState)state) : SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)newArrayTree), ASTHelpers.getStartPosition((Tree)initializers.getFirst()), "").replace(state.getEndPosition((Tree)newArrayTree.getInitializers().get(initializers.size() - 1)), state.getEndPosition((Tree)newArrayTree), "").build();
        return this.describeMatch(tree, (Fix)fix);
    }
}

