/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Comparing different pairs of fields/getters in an equals implementation is probably a mistake.", severity=BugPattern.SeverityLevel.ERROR)
public final class EqualsWrongThing
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodInvocationTree> COMPARISON_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Arrays").named("equals"), Matchers.staticEqualsInvocation()});
    private static final ImmutableSet<ElementKind> FIELD_TYPES = Sets.immutableEnumSet((Enum)ElementKind.FIELD, (Enum[])new ElementKind[]{ElementKind.METHOD});

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!Matchers.equalsMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((MethodTree)tree).enclClass();
        final HashSet suspiciousComparisons = new HashSet();
        new TreeScanner<Void, Void>(this){

            @Override
            public Void visitBinary(BinaryTree node, Void unused) {
                block3: {
                    block2: {
                        if (node.getKind() == Tree.Kind.EQUAL_TO) break block2;
                        if (node.getKind() != Tree.Kind.NOT_EQUAL_TO) break block3;
                    }
                    EqualsWrongThing.getDubiousComparison(classSymbol, node, node.getLeftOperand(), node.getRightOperand()).ifPresent(suspiciousComparisons::add);
                }
                return (Void)super.visitBinary(node, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                block4: {
                    ExpressionTree receiver;
                    List<? extends ExpressionTree> args;
                    block5: {
                        args = node.getArguments();
                        if (COMPARISON_METHOD.matches((Tree)node, state)) {
                            EqualsWrongThing.getDubiousComparison(classSymbol, node, args.getFirst(), args.get(args.size() / 2)).ifPresent(suspiciousComparisons::add);
                        }
                        if (!Matchers.instanceEqualsInvocation().matches((Tree)node, state) || (receiver = ASTHelpers.getReceiver((ExpressionTree)node)) == null) break block4;
                        if (!(receiver instanceof IdentifierTree)) break block5;
                        IdentifierTree identifierTree = (IdentifierTree)receiver;
                        if (identifierTree.getName().contentEquals("super")) break block4;
                    }
                    EqualsWrongThing.getDubiousComparison(classSymbol, node, receiver, args.getFirst()).ifPresent(suspiciousComparisons::add);
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }.scan(tree, null);
        if (suspiciousComparisons.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableSet suspiciousPairs = (ImmutableSet)suspiciousComparisons.stream().map(ComparisonSite::pair).collect(ImmutableSet.toImmutableSet());
        suspiciousComparisons.stream().filter(p -> !suspiciousPairs.contains((Object)p.pair().reversed())).map(c -> this.buildDescription(c.tree()).setMessage(String.format("Suspicious comparison between `%s` and `%s`", c.pair().lhs(), c.pair().rhs())).build()).forEach(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        return Description.NO_MATCH;
    }

    private static Optional<ComparisonSite> getDubiousComparison(Symbol.ClassSymbol encl, Tree tree, ExpressionTree lhs, ExpressionTree rhs) {
        Symbol lhsSymbol = ASTHelpers.getSymbol((Tree)lhs);
        Symbol rhsSymbol = ASTHelpers.getSymbol((Tree)rhs);
        if (lhsSymbol == null || rhsSymbol == null || lhsSymbol.equals(rhsSymbol)) {
            return Optional.empty();
        }
        if (ASTHelpers.isStatic((Symbol)lhsSymbol) || ASTHelpers.isStatic((Symbol)rhsSymbol)) {
            return Optional.empty();
        }
        if (!encl.equals(lhsSymbol.enclClass()) || !encl.equals(rhsSymbol.enclClass())) {
            return Optional.empty();
        }
        if (!FIELD_TYPES.contains((Object)lhsSymbol.getKind()) || !FIELD_TYPES.contains((Object)rhsSymbol.getKind())) {
            return Optional.empty();
        }
        if (EqualsWrongThing.getKind(lhs) != EqualsWrongThing.getKind(rhs)) {
            return Optional.empty();
        }
        return Optional.of(ComparisonSite.of(tree, lhsSymbol, rhsSymbol));
    }

    private static Tree.Kind getKind(Tree tree) {
        Tree.Kind kind = tree.getKind();
        return kind == Tree.Kind.IDENTIFIER ? Tree.Kind.MEMBER_SELECT : kind;
    }

    private record ComparisonSite(Tree tree, ComparisonPair pair) {
        private static ComparisonSite of(Tree tree, Symbol lhs, Symbol rhs) {
            return new ComparisonSite(tree, ComparisonPair.of(lhs, rhs));
        }
    }

    private record ComparisonPair(Symbol lhs, Symbol rhs) {
        final ComparisonPair reversed() {
            return ComparisonPair.of(this.rhs(), this.lhs());
        }

        private static ComparisonPair of(Symbol lhs, Symbol rhs) {
            return new ComparisonPair(lhs, rhs);
        }
    }
}

