/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="You should almost never invoke the Enum.ordinal() method or depend on the enum values by index.", severity=BugPattern.SeverityLevel.WARNING)
public final class EnumOrdinal
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.ArrayAccessTreeMatcher {
    private static final Matcher<ExpressionTree> ORDINAL = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Enum").named("ordinal");
    private static final Matcher<ExpressionTree> VALUES = MethodMatchers.staticMethod().onDescendantOf("java.lang.Enum").named("values");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ORDINAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchArrayAccess(ArrayAccessTree tree, VisitorState state) {
        ExpressionTree expressionTree = tree.getExpression();
        if (!(expressionTree instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree mit = (MethodInvocationTree)expressionTree;
        if (!VALUES.matches((Tree)tree.getExpression(), state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodInvocationSymbol = ASTHelpers.getSymbol((MethodInvocationTree)mit);
        Symbol.ClassSymbol enclosingClassSymbol = ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})));
        if (methodInvocationSymbol.isEnclosedBy(enclosingClassSymbol)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

