/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;

@BugPattern(summary="Methods should not be directly invoked on mocks. Should this be part of a verify(..) call?", severity=BugPattern.SeverityLevel.WARNING)
public final class DirectInvocationOnMock
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> MOCK = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("org.mockito.Mockito").named("mock").withParameters("java.lang.Class", new String[0]), Matchers.staticMethod().onClass("org.mockito.Mockito").named("mock").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.OBJECT_TYPE_ARRAY))});
    private static final Matcher<MethodInvocationTree> DO_CALL_REAL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), Matchers.receiverOfInvocation((Matcher)Matchers.staticMethod().onClass("org.mockito.Mockito").named("doCallRealMethod"))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.mockito.BDDMockito.BDDStubber").named("given"), Matchers.receiverOfInvocation((Matcher)Matchers.staticMethod().onClass("org.mockito.BDDMockito").named("willCallRealMethod"))})});
    private static final Matcher<ExpressionTree> WHEN = Matchers.anyMethod().anyClass().namedAnyOf(new String[]{"when", "given"});
    private static final Matcher<ExpressionTree> THEN_CALL_REAL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.OngoingStubbing").named("thenCallRealMethod"), Matchers.instanceMethod().onDescendantOf("org.mockito.BDDMockito.BDDMyOngoingStubbing").named("willCallRealMethod")});

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final ImmutableSet<Symbol.VarSymbol> mocks = this.findMocks(state);
        final HashSet methodsCallingRealImplementations = new HashSet();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ DirectInvocationOnMock this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                ExpressionTree expressionTree;
                if (THEN_CALL_REAL_METHOD.matches((Tree)tree, this.state)) {
                    ExpressionTree firstArgument;
                    Symbol symbol;
                    ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
                    if (receiver != null && WHEN.matches((Tree)receiver, this.state) && (symbol = ASTHelpers.getSymbol((Tree)(firstArgument = ((MethodInvocationTree)receiver).getArguments().getFirst()))) instanceof Symbol.MethodSymbol) {
                        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                        methodsCallingRealImplementations.add(methodSymbol);
                    }
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if (DO_CALL_REAL_METHOD.matches((Tree)tree, this.state)) {
                    Symbol firstArgument = ASTHelpers.getSymbol((Tree)this.getCurrentPath().getParentPath().getParentPath().getLeaf());
                    if (firstArgument instanceof Symbol.MethodSymbol) {
                        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)firstArgument;
                        methodsCallingRealImplementations.add(methodSymbol);
                    }
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if (methodsCallingRealImplementations.contains(ASTHelpers.getSymbol((MethodInvocationTree)tree))) {
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if ((ASTHelpers.getSymbol((MethodInvocationTree)tree).flags() & 0x10L) != 0L) {
                    return null;
                }
                Tree parent = Streams.stream((Iterable)this.getCurrentPath()).skip(1L).filter(t -> !(t instanceof TypeCastTree)).findFirst().get();
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
                if (!(!this.isMock(receiver) || parent instanceof ExpressionTree && WHEN.matches((Tree)(expressionTree = (ExpressionTree)parent), this.state))) {
                    Description.Builder description = this.this$0.buildDescription(tree).setMessage(String.format("Methods should not be directly invoked on the mock `%s`. Should this be part of a verify(..) call?", ASTHelpers.getSymbol((Tree)receiver).getSimpleName()));
                    if (this.getCurrentPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
                        SuggestedFix.Builder fix = SuggestedFix.builder();
                        String verify = SuggestedFixes.qualifyStaticImport((String)"org.mockito.Mockito.verify", (SuggestedFix.Builder)fix, (VisitorState)this.state);
                        description.addFix((Fix)fix.replace((Tree)receiver, String.format("%s(%s)", verify, this.state.getSourceForNode((Tree)receiver))).setShortDescription("turn into verify() call").build());
                        description.addFix((Fix)SuggestedFix.builder().delete((Tree)tree).setShortDescription("delete redundant invocation").build());
                    }
                    this.state.reportMatch(description.build());
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private boolean isMock(ExpressionTree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                return symbol != null && (mocks.contains((Object)symbol) || symbol.getAnnotationMirrors().stream().filter(am -> am.type.tsym.getQualifiedName().contentEquals("org.mockito.Mock")).findFirst().filter(am -> MoreAnnotations.getAnnotationValue((Attribute.Compound)am, (String)"answer").isEmpty()).isPresent());
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private ImmutableSet<Symbol.VarSymbol> findMocks(final VisitorState state) {
        final ImmutableSet.Builder mocks = ImmutableSet.builder();
        new TreeScanner<Void, Void>(this){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (tree.getInitializer() != null && MOCK.matches((Tree)tree.getInitializer(), state)) {
                    mocks.add((Object)ASTHelpers.getSymbol((VariableTree)tree));
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol;
                if (MOCK.matches((Tree)tree.getExpression(), state) && (symbol = ASTHelpers.getSymbol((Tree)tree.getVariable())) instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    mocks.add((Object)varSymbol);
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return mocks.build();
    }
}

