/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import javax.inject.Inject;

@BugPattern(summary="Implicit use of the platform default charset, which can result in differing behaviour between JVM executions or incorrect behavior if the encoding of the data source doesn't match expectations.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class DefaultCharset
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> FILE_WRITER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters("java.io.File", new String[0]), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters("java.io.File", new String[]{"boolean"}), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters("java.lang.String", new String[0]), MethodMatchers.constructor().forClass(FileWriter.class.getName()).withParameters("java.lang.String", new String[]{"boolean"})});
    private static final Matcher<Tree> BUFFERED_WRITER = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.constructor().forClass(BufferedWriter.class.getName()));
    private static final Matcher<ExpressionTree> FILE_READER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(FileReader.class.getName()).withParameters("java.io.File", new String[0]), MethodMatchers.constructor().forClass(FileReader.class.getName()).withParameters("java.lang.String", new String[0])});
    private static final Matcher<Tree> BUFFERED_READER = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.constructor().forClass(BufferedReader.class.getName()));
    private static final Matcher<ExpressionTree> CTOR = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(String.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.BYTE_TYPE))), MethodMatchers.constructor().forClass(String.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.BYTE_TYPE), (Object)Suppliers.INT_TYPE, (Object)Suppliers.INT_TYPE)), MethodMatchers.constructor().forClass(OutputStreamWriter.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.typeFromClass(OutputStream.class))), MethodMatchers.constructor().forClass(InputStreamReader.class.getName()).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.typeFromClass(InputStream.class)))});
    private static final Matcher<ExpressionTree> BYTESTRING_COPY_FROM = MethodMatchers.staticMethod().onClass("com.google.protobuf.ByteString").named("copyFrom");
    private static final Matcher<ExpressionTree> STRING_GET_BYTES = MethodMatchers.instanceMethod().onExactClass(String.class.getName()).named("getBytes").withNoParameters();
    private static final Matcher<ExpressionTree> BYTE_ARRAY_OUTPUT_STREAM_TO_STRING = MethodMatchers.instanceMethod().onDescendantOf(ByteArrayOutputStream.class.getName()).named("toString").withNoParameters();
    private static final Matcher<ExpressionTree> FILE_NEW_WRITER = MethodMatchers.staticMethod().onClass(Files.class.getName()).named("newWriter").withParameters("java.lang.String", new String[0]);
    private static final Matcher<ExpressionTree> PRINT_WRITER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(File.class.getName(), new String[0]), MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(String.class.getName(), new String[0])});
    private static final Matcher<ExpressionTree> PRINT_WRITER_OUTPUTSTREAM = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(OutputStream.class.getName(), new String[0]), MethodMatchers.constructor().forClass(PrintWriter.class.getName()).withParameters(OutputStream.class.getName(), new String[]{"boolean"})});
    private static final Matcher<ExpressionTree> SCANNER_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(InputStream.class.getName(), new String[0]), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(File.class.getName(), new String[0]), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(Path.class.getName(), new String[0]), MethodMatchers.constructor().forClass(Scanner.class.getName()).withParameters(ReadableByteChannel.class.getName(), new String[0])});
    private final boolean byteArrayOutputStreamToString;
    private static final Supplier<Type> JAVA_IO_FILE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.io.File"));

    @Inject
    DefaultCharset(ErrorProneFlags flags) {
        this.byteArrayOutputStreamToString = flags.getBoolean("DefaultCharset:ByteArrayOutputStreamToString").orElse(true);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (STRING_GET_BYTES.matches((Tree)tree, state)) {
            ExpressionTree expressionTree;
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof ExpressionTree && BYTESTRING_COPY_FROM.matches((Tree)(expressionTree = (ExpressionTree)parent), state)) {
                return this.byteStringFixes(tree, expressionTree, state);
            }
            return this.appendCharsets(tree, tree.getMethodSelect(), tree.getArguments(), state);
        }
        if (FILE_NEW_WRITER.matches((Tree)tree, state)) {
            return this.appendCharsets(tree, tree.getMethodSelect(), tree.getArguments(), state);
        }
        if (this.byteArrayOutputStreamToString && BYTE_ARRAY_OUTPUT_STREAM_TO_STRING.matches((Tree)tree, state)) {
            return this.appendCharsets(tree, tree.getMethodSelect(), tree.getArguments(), state);
        }
        return Description.NO_MATCH;
    }

    private Description byteStringFixes(MethodInvocationTree tree, ExpressionTree parent, VisitorState state) {
        SuggestedFix.Builder builder = DefaultCharset.byteStringFix(tree, parent, state, "copyFrom(", ", " + CharsetFix.DEFAULT_CHARSET_FIX.replacement());
        CharsetFix.DEFAULT_CHARSET_FIX.addImport(builder);
        return this.buildDescription(tree).addFix((Fix)DefaultCharset.byteStringFix(tree, parent, state, "copyFromUtf8(", "").build()).addFix((Fix)builder.build()).build();
    }

    private static SuggestedFix.Builder byteStringFix(MethodInvocationTree tree, ExpressionTree parent, VisitorState state, String prefix, String suffix) {
        ExpressionTree parentReceiver = ASTHelpers.getReceiver((ExpressionTree)parent);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (parentReceiver != null) {
            fix.replace(state.getEndPosition((Tree)parentReceiver), ASTHelpers.getStartPosition((Tree)tree), "." + prefix);
        } else {
            fix.replace(ASTHelpers.getStartPosition((Tree)parent), ASTHelpers.getStartPosition((Tree)tree), prefix);
        }
        fix.replace(state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), state.getEndPosition((Tree)tree), suffix);
        return fix;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (CTOR.matches((Tree)tree, state)) {
            return this.appendCharsets(tree, tree.getIdentifier(), tree.getArguments(), state);
        }
        if (FILE_READER.matches((Tree)tree, state)) {
            return this.handleFileReader(tree, state);
        }
        if (FILE_WRITER.matches((Tree)tree, state)) {
            return this.handleFileWriter(tree, state);
        }
        if (PRINT_WRITER.matches((Tree)tree, state)) {
            return this.handlePrintWriter(tree);
        }
        if (PRINT_WRITER_OUTPUTSTREAM.matches((Tree)tree, state)) {
            return this.handlePrintWriterOutputStream(tree);
        }
        if (SCANNER_MATCHER.matches((Tree)tree, state)) {
            return this.handleScanner(tree);
        }
        return Description.NO_MATCH;
    }

    private Description handleScanner(NewClassTree tree) {
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(tree.getArguments()), String.format(", %s", charsetFix.replacement()));
            charsetFix.addImport(fix);
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    boolean shouldUseGuava(VisitorState state) {
        for (ImportTree importTree : state.getPath().getCompilationUnit().getImports()) {
            Symbol sym = ASTHelpers.getSymbol((Tree)importTree.getQualifiedIdentifier());
            if (sym == null || !sym.getQualifiedName().contentEquals("com.google.common.io.Files")) continue;
            return true;
        }
        return false;
    }

    private Description handleFileReader(NewClassTree tree, VisitorState state) {
        Tree arg = (Tree)Iterables.getOnlyElement(tree.getArguments());
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree toReplace = BUFFERED_READER.matches(parent, state) ? parent : tree;
        Description.Builder description = this.buildDescription(tree);
        this.fileReaderFix(description, state, arg, toReplace);
        return description.build();
    }

    private void fileReaderFix(Description.Builder description, VisitorState state, Tree arg, Tree toReplace) {
        for (CharsetFix charset : CharsetFix.values()) {
            if (this.shouldUseGuava(state)) {
                description.addFix(DefaultCharset.guavaFileReaderFix(state, arg, toReplace, charset));
                continue;
            }
            description.addFix(DefaultCharset.nioFileReaderFix(state, arg, toReplace, charset));
        }
    }

    private static Fix nioFileReaderFix(VisitorState state, Tree arg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newBufferedReader(%s, %s)", DefaultCharset.toPath(state, arg, fix), charset.replacement()));
        fix.addImport("java.nio.file.Files");
        charset.addImport(fix);
        DefaultCharset.variableTypeFix(fix, state, FileReader.class, Reader.class);
        return fix.build();
    }

    private static Fix guavaFileReaderFix(VisitorState state, Tree fileArg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newReader(%s, %s)", DefaultCharset.toFile(state, fileArg, fix), charset.replacement()));
        fix.addImport("com.google.common.io.Files");
        charset.addImport(fix);
        DefaultCharset.variableTypeFix(fix, state, FileReader.class, Reader.class);
        return fix.build();
    }

    private static void variableTypeFix(final SuggestedFix.Builder fix, final VisitorState state, Class<?> original, final Class<?> replacement) {
        Symbol sym;
        Tree parent;
        Tree tree = parent = state.getPath().getParentPath().getLeaf();
        Objects.requireNonNull(tree);
        Tree tree2 = tree;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableTree.class, AssignmentTree.class}, (Object)tree2, n)) {
            case 0: {
                VariableTree variableTree = (VariableTree)tree2;
                sym = ASTHelpers.getSymbol((VariableTree)variableTree);
                break;
            }
            case 1: {
                AssignmentTree assignmentTree = (AssignmentTree)tree2;
                sym = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable());
                break;
            }
            default: {
                return;
            }
        }
        if (!ASTHelpers.isSameType((Type)sym.type, (Type)state.getTypeFromString(original.getCanonicalName()), (VisitorState)state)) {
            return;
        }
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                if (!sym.equals(ASTHelpers.getSymbol((VariableTree)node))) {
                    return null;
                }
                if (ASTHelpers.hasImplicitType((VariableTree)node, (VisitorState)state)) {
                    return null;
                }
                fix.replace(node.getType(), replacement.getSimpleName()).addImport(replacement.getCanonicalName());
                return null;
            }
        }.scan(state.getPath().getCompilationUnit(), null);
    }

    private Description handleFileWriter(NewClassTree tree, VisitorState state) {
        Iterator<? extends ExpressionTree> it = tree.getArguments().iterator();
        Tree fileArg = it.next();
        Tree appendMode = it.hasNext() ? (Tree)it.next() : null;
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree toReplace = BUFFERED_WRITER.matches(parent, state) ? parent : tree;
        Description.Builder description = this.buildDescription(tree);
        boolean useGuava = this.shouldUseGuava(state);
        for (CharsetFix charset : CharsetFix.values()) {
            if (appendMode == null && useGuava) {
                description.addFix(DefaultCharset.guavaFileWriterFix(state, fileArg, toReplace, charset));
                continue;
            }
            description.addFix(DefaultCharset.nioFileWriterFix(state, appendMode, fileArg, toReplace, charset, useGuava));
        }
        return description.build();
    }

    private static Fix guavaFileWriterFix(VisitorState state, Tree fileArg, Tree toReplace, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(toReplace, String.format("Files.newWriter(%s, %s)", DefaultCharset.toFile(state, fileArg, fix), charset.replacement()));
        fix.addImport("com.google.common.io.Files");
        charset.addImport(fix);
        DefaultCharset.variableTypeFix(fix, state, FileWriter.class, Writer.class);
        return fix.build();
    }

    private static Fix nioFileWriterFix(VisitorState state, Tree appendTree, Tree fileArg, Tree toReplace, CharsetFix charset, boolean qualify) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder sb = new StringBuilder();
        if (qualify) {
            sb.append("java.nio.file.Files");
        } else {
            sb.append("Files");
            fix.addImport("java.nio.file.Files");
        }
        sb.append(".newBufferedWriter(");
        sb.append(DefaultCharset.toPath(state, fileArg, fix));
        sb.append(", ").append(charset.replacement());
        charset.addImport(fix);
        if (appendTree != null) {
            sb.append(DefaultCharset.toAppendMode(fix, appendTree, state));
        }
        sb.append(")");
        fix.replace(toReplace, sb.toString());
        DefaultCharset.variableTypeFix(fix, state, FileWriter.class, Writer.class);
        return fix.build();
    }

    private static String toAppendMode(SuggestedFix.Builder fix, Tree appendArg, VisitorState state) {
        Boolean value = (Boolean)ASTHelpers.constValue((Tree)appendArg, Boolean.class);
        if (value != null) {
            if (value.booleanValue()) {
                fix.addStaticImport("java.nio.file.StandardOpenOption.APPEND");
                fix.addStaticImport("java.nio.file.StandardOpenOption.CREATE");
                return ", CREATE, APPEND";
            }
            return "";
        }
        fix.addImport("java.nio.file.StandardOpenOption");
        fix.addStaticImport("java.nio.file.StandardOpenOption.APPEND");
        fix.addStaticImport("java.nio.file.StandardOpenOption.CREATE");
        return String.format(", %s ? new StandardOpenOption[] {CREATE, APPEND} : new StandardOpenOption[] {CREATE}", state.getSourceForNode(appendArg));
    }

    private static Object toFile(VisitorState state, Tree fileArg, SuggestedFix.Builder fix) {
        Type type = ASTHelpers.getType((Tree)fileArg);
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            fix.addImport("java.io.File");
            return String.format("new File(%s)", state.getSourceForNode(fileArg));
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)((Type)JAVA_IO_FILE.get(state)), (VisitorState)state)) {
            return state.getSourceForNode(fileArg);
        }
        throw new AssertionError((Object)("unexpected type: " + String.valueOf(type)));
    }

    private static String toPath(VisitorState state, Tree fileArg, SuggestedFix.Builder fix) {
        Type type = ASTHelpers.getType((Tree)fileArg);
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().stringType, (VisitorState)state)) {
            fix.addImport("java.nio.file.Paths");
            return String.format("Paths.get(%s)", state.getSourceForNode(fileArg));
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)((Type)JAVA_IO_FILE.get(state)), (VisitorState)state)) {
            return String.format("%s.toPath()", state.getSourceForNode(fileArg));
        }
        throw new AssertionError((Object)("unexpected type: " + String.valueOf(type)));
    }

    private Description appendCharsets(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state) {
        return this.buildDescription(tree).addFix(DefaultCharset.appendCharset(tree, select, arguments, state, CharsetFix.UTF_8_FIX)).addFix(DefaultCharset.appendCharset(tree, select, arguments, state, CharsetFix.DEFAULT_CHARSET_FIX)).build();
    }

    private static Fix appendCharset(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, CharsetFix charset) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (arguments.isEmpty()) {
            fix.replace(state.getEndPosition(select), state.getEndPosition(tree), String.format("(%s)", charset.replacement()));
        } else {
            fix.postfixWith((Tree)Iterables.getLast(arguments), ", " + charset.replacement());
        }
        charset.addImport(fix);
        fix.setShortDescription(charset.title);
        return fix.build();
    }

    private Description handlePrintWriter(NewClassTree tree) {
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(tree.getArguments()), String.format(", %s", charsetFix.replacement()));
            charsetFix.addImport(fix);
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    private Description handlePrintWriterOutputStream(NewClassTree tree) {
        Tree outputStream = tree.getArguments().getFirst();
        Description.Builder description = this.buildDescription(tree);
        for (CharsetFix charsetFix : CharsetFix.values()) {
            SuggestedFix.Builder fix = SuggestedFix.builder().prefixWith(outputStream, "new BufferedWriter(new OutputStreamWriter(").postfixWith(outputStream, String.format(", %s))", charsetFix.replacement()));
            charsetFix.addImport(fix);
            fix.addImport("java.io.BufferedWriter");
            fix.addImport("java.io.OutputStreamWriter");
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    static enum CharsetFix {
        UTF_8_FIX("UTF_8", "Specify UTF-8"){

            @Override
            void addImport(SuggestedFix.Builder fix) {
                fix.addStaticImport("java.nio.charset.StandardCharsets.UTF_8");
            }
        }
        ,
        DEFAULT_CHARSET_FIX("Charset.defaultCharset()", "Specify default charset"){

            @Override
            void addImport(SuggestedFix.Builder fix) {
                fix.addImport("java.nio.charset.Charset");
            }
        };

        final String replacement;
        final String title;

        private CharsetFix(String replacement, String title) {
            this.replacement = replacement;
            this.title = title;
        }

        String replacement() {
            return this.replacement;
        }

        abstract void addImport(SuggestedFix.Builder var1);
    }
}

