/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Variables initialized with Pattern#compile calls on constants can be constants", severity=BugPattern.SeverityLevel.WARNING)
public final class ConstantPatternCompile
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableList<String> PATTERN_CLASSES = ImmutableList.of((Object)"java.util.regex.Pattern", (Object)"com.google.re2j.Pattern");
    private static final Matcher<ExpressionTree> PATTERN_COMPILE_CHECK = Matchers.staticMethod().onClassAny(PATTERN_CLASSES).named("compile");
    private static final Matcher<ExpressionTree> MATCHER_MATCHER = Matchers.instanceMethod().onExactClassAny(PATTERN_CLASSES).named("matcher");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        final NameUniquifier nameUniquifier = new NameUniquifier();
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        final Tree[] firstHit = new Tree[1];
        for (Tree tree : classTree.getMembers()) {
            new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){

                public Void visitClass(ClassTree node, Void unused) {
                    return null;
                }

                public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                    this.tryFix(tree, this.state.withPath(this.getCurrentPath()), nameUniquifier).ifPresent(other -> {
                        fixBuilder.merge(other);
                        if (firstHit[0] == null) {
                            firstHit2[0] = tree;
                        }
                    });
                    return (Void)super.visitMethodInvocation(tree, null);
                }

                private Optional<SuggestedFix> tryFix(MethodInvocationTree tree, VisitorState state, NameUniquifier nameUniquifier2) {
                    if (!PATTERN_COMPILE_CHECK.matches((Tree)tree, state)) {
                        return Optional.empty();
                    }
                    if (!tree.getArguments().stream().allMatch(ConstantPatternCompile::isArgStaticAndConstant)) {
                        return Optional.empty();
                    }
                    if (state.errorProneOptions().isTestOnlyTarget()) {
                        return Optional.empty();
                    }
                    if (ASTHelpers.isInStaticInitializer((VisitorState)state)) {
                        return Optional.empty();
                    }
                    Tree parent = state.getPath().getParentPath().getLeaf();
                    if (parent instanceof VariableTree) {
                        VariableTree variableTree = (VariableTree)parent;
                        return ConstantPatternCompile.handleVariable(variableTree, state);
                    }
                    return Optional.of(ConstantPatternCompile.handleInlineExpression(tree, state, nameUniquifier2));
                }
            }.scan(new TreePath(state.getPath(), tree), null);
        }
        if (firstHit[0] == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(firstHit[0], (Fix)fixBuilder.build());
    }

    private static SuggestedFix handleInlineExpression(MethodInvocationTree tree, VisitorState state, NameUniquifier nameUniquifier) {
        String nameSuggestion = nameUniquifier.uniquify(Optional.ofNullable(ConstantPatternCompile.findNameFromMatcherArgument(state, state.getPath())).orElse("PATTERN"));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return fix.replace((Tree)tree, nameSuggestion).merge(SuggestedFixes.addMembers((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})), (VisitorState)state, (String)String.format("private static final %s %s = %s;", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)ASTHelpers.getSymbol((MethodInvocationTree)tree).getReturnType().tsym), nameSuggestion, state.getSourceForNode((Tree)tree)), (String[])new String[0])).build();
    }

    private static Optional<SuggestedFix> handleVariable(VariableTree tree, VisitorState state) {
        MethodTree outerMethodTree = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (outerMethodTree == null) {
            return Optional.empty();
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        return switch (sym.getKind()) {
            case ElementKind.RESOURCE_VARIABLE -> Optional.of(SuggestedFix.emptyFix());
            case ElementKind.LOCAL_VARIABLE -> Optional.of(ConstantPatternCompile.fixLocal(tree, outerMethodTree, state));
            default -> Optional.empty();
        };
    }

    private static SuggestedFix fixLocal(VariableTree tree, MethodTree outerMethodTree, VisitorState state) {
        SuggestedFix fix = ConstantPatternCompile.replaceRegexConstant(tree, state);
        if (!fix.isEmpty()) {
            return fix;
        }
        String name = ConstantPatternCompile.inferName(tree, state);
        if (name == null) {
            return SuggestedFix.emptyFix();
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)outerMethodTree);
        boolean canUseStatic = ASTHelpers.enclosingClass((Symbol)methodSymbol).getNestingKind() == NestingKind.TOP_LEVEL || outerMethodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        String replacement = String.format("private %s final %s %s = %s;", canUseStatic ? "static " : "", state.getSourceForNode(tree.getType()), name, state.getSourceForNode((Tree)tree.getInitializer()));
        return SuggestedFixes.renameVariableUsages((VariableTree)tree, (String)name, (VisitorState)state).toBuilder().postfixWith((Tree)outerMethodTree, replacement).delete((Tree)tree).build();
    }

    private static SuggestedFix replaceRegexConstant(VariableTree tree, VisitorState state) {
        ExpressionTree regex = ((MethodInvocationTree)tree.getInitializer()).getArguments().getFirst();
        final Symbol regexSym = ASTHelpers.getSymbol((Tree)regex);
        if (!(regexSym != null && regexSym.getKind().equals((Object)ElementKind.FIELD) && ASTHelpers.isStatic((Symbol)regexSym) && regexSym.getModifiers().contains((Object)Modifier.FINAL) && ASTHelpers.canBeRemoved((Symbol.VarSymbol)((Symbol.VarSymbol)regexSym)))) {
            return SuggestedFix.emptyFix();
        }
        final VariableTree[] defs = new VariableTree[]{null};
        final int[] uses = new int[]{0};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((VariableTree)tree))) {
                    defs[0] = tree;
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    uses[0] = uses[0] + 1;
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    uses[0] = uses[0] + 1;
                }
                return (Void)super.visitMemberSelect(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (uses[0] != 1) {
            return SuggestedFix.emptyFix();
        }
        VariableTree def = defs[0];
        return SuggestedFix.builder().replace(def.getType(), state.getSourceForNode(tree.getType())).prefixWith((Tree)def.getInitializer(), state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree.getInitializer()), ASTHelpers.getStartPosition((Tree)regex)).toString()).postfixWith((Tree)def.getInitializer(), ")").merge(SuggestedFixes.renameVariableUsages((VariableTree)tree, (String)def.getName().toString(), (VisitorState)state)).delete((Tree)tree).build();
    }

    private static @Nullable String inferName(VariableTree tree, VisitorState state) {
        String name = ConstantPatternCompile.fromName(tree);
        if (name != null) {
            return name;
        }
        name = ConstantPatternCompile.fromInitializer(tree);
        if (name != null) {
            return name;
        }
        name = ConstantPatternCompile.fromUse(tree, state);
        if (name != null) {
            return name;
        }
        return null;
    }

    private static @Nullable String fromName(VariableTree tree) {
        String name = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, tree.getName().toString());
        if (name.length() > 1 && !name.equals("PATTERN")) {
            return name;
        }
        return null;
    }

    private static @Nullable String fromInitializer(VariableTree tree) {
        ExpressionTree regex = ((MethodInvocationTree)tree.getInitializer()).getArguments().getFirst();
        if (!(regex instanceof IdentifierTree)) {
            return null;
        }
        IdentifierTree identifierTree = (IdentifierTree)regex;
        String name = identifierTree.getName().toString();
        if (name.endsWith("_REGEX")) {
            name = name.substring(0, name.length() - "_REGEX".length());
        }
        if (name.endsWith("_PATTERN")) {
            return null;
        }
        return name + "_PATTERN";
    }

    private static @Nullable String fromUse(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        final ImmutableList.Builder usesBuilder = ImmutableList.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    usesBuilder.add((Object)this.getCurrentPath());
                }
                return null;
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        ImmutableList uses = usesBuilder.build();
        if (uses.size() != 1) {
            return null;
        }
        TreePath use = (TreePath)Iterables.getOnlyElement((Iterable)uses);
        return ConstantPatternCompile.findNameFromMatcherArgument(state, use);
    }

    private static @Nullable String findNameFromMatcherArgument(VisitorState state, TreePath use) {
        Tree grandParent = use.getParentPath().getParentPath().getLeaf();
        if (!(grandParent instanceof ExpressionTree)) {
            return null;
        }
        ExpressionTree expressionTree = (ExpressionTree)grandParent;
        if (!MATCHER_MATCHER.matches((Tree)expressionTree, state)) {
            return null;
        }
        ExpressionTree matchTree = ((MethodInvocationTree)grandParent).getArguments().getFirst();
        if (matchTree instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)matchTree;
            return ConstantPatternCompile.convertToConstantName(identifierTree.getName().toString());
        }
        if (matchTree instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)matchTree;
            return ConstantPatternCompile.convertToConstantName(((Name)ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getSimpleName()).toString());
        }
        return null;
    }

    private static String convertToConstantName(String variableName) {
        String root = variableName.equals(Ascii.toUpperCase((String)variableName)) ? variableName : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, variableName);
        return root + "_PATTERN";
    }

    private static boolean isArgStaticAndConstant(ExpressionTree arg) {
        if (ASTHelpers.constValue((Tree)arg) == null) {
            return false;
        }
        Symbol argSymbol = ASTHelpers.getSymbol((Tree)arg);
        if (argSymbol == null) {
            return true;
        }
        return (argSymbol.flags() & 8L) != 0L;
    }

    private static final class NameUniquifier {
        final Multiset<String> assignmentCounts = HashMultiset.create();

        private NameUniquifier() {
        }

        String uniquify(String name) {
            int numPreviousUses = this.assignmentCounts.add((Object)name, 1);
            if (numPreviousUses == 0) {
                return name;
            }
            return name + (numPreviousUses + 1);
        }
    }
}

