/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="instanceof used in a way that is equivalent to a null check.", severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
public final class BadInstanceof
extends BugChecker
implements BugChecker.InstanceOfTreeMatcher {
    public Description matchInstanceOf(InstanceOfTree tree, VisitorState state) {
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree.getExpression()), (Type)ASTHelpers.getType((Tree)tree.getType()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String subType = SuggestedFixes.prettyType((Type)ASTHelpers.getType((Tree)tree.getExpression()), (VisitorState)state);
        String expression = state.getSourceForNode((Tree)tree.getExpression());
        String superType = state.getSourceForNode(tree.getType());
        if (Matchers.isNonNullUsingDataflow().matches((Tree)tree.getExpression(), state)) {
            return this.buildDescription(tree).setMessage(String.format("`%s` is a non-null instance of %s which is a subtype of %s, so this check is always true.", expression, subType, superType)).build();
        }
        return this.buildDescription(tree).setMessage(String.format("`%s` is an instance of %s which is a subtype of %s, so this is equivalent to a null check.", expression, subType, superType)).addFix((Fix)BadInstanceof.getFix(tree, state)).build();
    }

    private static SuggestedFix getFix(InstanceOfTree tree, VisitorState state) {
        if (tree.getPattern() != null) {
            return SuggestedFix.emptyFix();
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree grandParent = state.getPath().getParentPath().getParentPath().getLeaf();
        if (parent instanceof ParenthesizedTree && grandParent.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
            return SuggestedFix.replace((Tree)grandParent, (String)(state.getSourceForNode((Tree)tree.getExpression()) + " == null"));
        }
        return SuggestedFix.replace((Tree)tree, (String)(state.getSourceForNode((Tree)tree.getExpression()) + " != null"));
    }
}

