// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/api/http.proto
// Protobuf Java Version: 4.33.4

package com.google.api;

/**
 * <pre>
 * gRPC Transcoding
 *
 * gRPC Transcoding is a feature for mapping between a gRPC method and one or
 * more HTTP REST endpoints. It allows developers to build a single API service
 * that supports both gRPC APIs and REST APIs. Many systems, including [Google
 * APIs](https://github.com/googleapis/googleapis),
 * [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC
 * Gateway](https://github.com/grpc-ecosystem/grpc-gateway),
 * and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature
 * and use it for large scale production services.
 *
 * `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies
 * how different portions of the gRPC request message are mapped to the URL
 * path, URL query parameters, and HTTP request body. It also controls how the
 * gRPC response message is mapped to the HTTP response body. `HttpRule` is
 * typically specified as an `google.api.http` annotation on the gRPC method.
 *
 * Each mapping specifies a URL path template and an HTTP method. The path
 * template may refer to one or more fields in the gRPC request message, as long
 * as each field is a non-repeated field with a primitive (non-message) type.
 * The path template controls how fields of the request message are mapped to
 * the URL path.
 *
 * Example:
 *
 * service Messaging {
 * rpc GetMessage(GetMessageRequest) returns (Message) {
 * option (google.api.http) = {
 * get: "/v1/{name=messages/&#42;}"
 * };
 * }
 * }
 * message GetMessageRequest {
 * string name = 1; // Mapped to URL path.
 * }
 * message Message {
 * string text = 1; // The resource content.
 * }
 *
 * This enables an HTTP REST to gRPC mapping as below:
 *
 * - HTTP: `GET /v1/messages/123456`
 * - gRPC: `GetMessage(name: "messages/123456")`
 *
 * Any fields in the request message which are not bound by the path template
 * automatically become HTTP query parameters if there is no HTTP request body.
 * For example:
 *
 * service Messaging {
 * rpc GetMessage(GetMessageRequest) returns (Message) {
 * option (google.api.http) = {
 * get:"/v1/messages/{message_id}"
 * };
 * }
 * }
 * message GetMessageRequest {
 * message SubMessage {
 * string subfield = 1;
 * }
 * string message_id = 1; // Mapped to URL path.
 * int64 revision = 2;    // Mapped to URL query parameter `revision`.
 * SubMessage sub = 3;    // Mapped to URL query parameter `sub.subfield`.
 * }
 *
 * This enables a HTTP JSON to RPC mapping as below:
 *
 * - HTTP: `GET /v1/messages/123456?revision=2&amp;sub.subfield=foo`
 * - gRPC: `GetMessage(message_id: "123456" revision: 2 sub:
 * SubMessage(subfield: "foo"))`
 *
 * Note that fields which are mapped to URL query parameters must have a
 * primitive type or a repeated primitive type or a non-repeated message type.
 * In the case of a repeated type, the parameter can be repeated in the URL
 * as `...?param=A&amp;param=B`. In the case of a message type, each field of the
 * message is mapped to a separate parameter, such as
 * `...?foo.a=A&amp;foo.b=B&amp;foo.c=C`.
 *
 * For HTTP methods that allow a request body, the `body` field
 * specifies the mapping. Consider a REST update method on the
 * message resource collection:
 *
 * service Messaging {
 * rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
 * option (google.api.http) = {
 * patch: "/v1/messages/{message_id}"
 * body: "message"
 * };
 * }
 * }
 * message UpdateMessageRequest {
 * string message_id = 1; // mapped to the URL
 * Message message = 2;   // mapped to the body
 * }
 *
 * The following HTTP JSON to RPC mapping is enabled, where the
 * representation of the JSON in the request body is determined by
 * protos JSON encoding:
 *
 * - HTTP: `PATCH /v1/messages/123456 { "text": "Hi!" }`
 * - gRPC: `UpdateMessage(message_id: "123456" message { text: "Hi!" })`
 *
 * The special name `*` can be used in the body mapping to define that
 * every field not bound by the path template should be mapped to the
 * request body.  This enables the following alternative definition of
 * the update method:
 *
 * service Messaging {
 * rpc UpdateMessage(Message) returns (Message) {
 * option (google.api.http) = {
 * patch: "/v1/messages/{message_id}"
 * body: "*"
 * };
 * }
 * }
 * message Message {
 * string message_id = 1;
 * string text = 2;
 * }
 *
 *
 * The following HTTP JSON to RPC mapping is enabled:
 *
 * - HTTP: `PATCH /v1/messages/123456 { "text": "Hi!" }`
 * - gRPC: `UpdateMessage(message_id: "123456" text: "Hi!")`
 *
 * Note that when using `*` in the body mapping, it is not possible to
 * have HTTP parameters, as all fields not bound by the path end in
 * the body. This makes this option more rarely used in practice when
 * defining REST APIs. The common usage of `*` is in custom methods
 * which don't use the URL at all for transferring data.
 *
 * It is possible to define multiple HTTP methods for one RPC by using
 * the `additional_bindings` option. Example:
 *
 * service Messaging {
 * rpc GetMessage(GetMessageRequest) returns (Message) {
 * option (google.api.http) = {
 * get: "/v1/messages/{message_id}"
 * additional_bindings {
 * get: "/v1/users/{user_id}/messages/{message_id}"
 * }
 * };
 * }
 * }
 * message GetMessageRequest {
 * string message_id = 1;
 * string user_id = 2;
 * }
 *
 * This enables the following two alternative HTTP JSON to RPC mappings:
 *
 * - HTTP: `GET /v1/messages/123456`
 * - gRPC: `GetMessage(message_id: "123456")`
 *
 * - HTTP: `GET /v1/users/me/messages/123456`
 * - gRPC: `GetMessage(user_id: "me" message_id: "123456")`
 *
 * Rules for HTTP mapping
 *
 * 1. Leaf request fields (recursive expansion nested messages in the request
 * message) are classified into three categories:
 * - Fields referred by the path template. They are passed via the URL path.
 * - Fields referred by the [HttpRule.body][google.api.HttpRule.body]. They
 * are passed via the HTTP
 * request body.
 * - All other fields are passed via the URL query parameters, and the
 * parameter name is the field path in the request message. A repeated
 * field can be represented as multiple query parameters under the same
 * name.
 * 2. If [HttpRule.body][google.api.HttpRule.body] is "*", there is no URL
 * query parameter, all fields
 * are passed via URL path and HTTP request body.
 * 3. If [HttpRule.body][google.api.HttpRule.body] is omitted, there is no HTTP
 * request body, all
 * fields are passed via URL path and URL query parameters.
 *
 * Path template syntax
 *
 * Template = "/" Segments [ Verb ] ;
 * Segments = Segment { "/" Segment } ;
 * Segment  = "*" | "**" | LITERAL | Variable ;
 * Variable = "{" FieldPath [ "=" Segments ] "}" ;
 * FieldPath = IDENT { "." IDENT } ;
 * Verb     = ":" LITERAL ;
 *
 * The syntax `*` matches a single URL path segment. The syntax `**` matches
 * zero or more URL path segments, which must be the last part of the URL path
 * except the `Verb`.
 *
 * The syntax `Variable` matches part of the URL path as specified by its
 * template. A variable template must not contain other variables. If a variable
 * matches a single path segment, its template may be omitted, e.g. `{var}`
 * is equivalent to `{var=*}`.
 *
 * The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL`
 * contains any reserved character, such characters should be percent-encoded
 * before the matching.
 *
 * If a variable contains exactly one path segment, such as `"{var}"` or
 * `"{var=*}"`, when such a variable is expanded into a URL path on the client
 * side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The
 * server side does the reverse decoding. Such variables show up in the
 * [Discovery
 * Document](https://developers.google.com/discovery/v1/reference/apis) as
 * `{var}`.
 *
 * If a variable contains multiple path segments, such as `"{var=foo/&#42;}"`
 * or `"{var=**}"`, when such a variable is expanded into a URL path on the
 * client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded.
 * The server side does the reverse decoding, except "%2F" and "%2f" are left
 * unchanged. Such variables show up in the
 * [Discovery
 * Document](https://developers.google.com/discovery/v1/reference/apis) as
 * `{+var}`.
 *
 * Using gRPC API Service Configuration
 *
 * gRPC API Service Configuration (service config) is a configuration language
 * for configuring a gRPC service to become a user-facing product. The
 * service config is simply the YAML representation of the `google.api.Service`
 * proto message.
 *
 * As an alternative to annotating your proto file, you can configure gRPC
 * transcoding in your service config YAML files. You do this by specifying a
 * `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same
 * effect as the proto annotation. This can be particularly useful if you
 * have a proto that is reused in multiple services. Note that any transcoding
 * specified in the service config will override any matching transcoding
 * configuration in the proto.
 *
 * The following example selects a gRPC method and applies an `HttpRule` to it:
 *
 * http:
 * rules:
 * - selector: example.v1.Messaging.GetMessage
 * get: /v1/messages/{message_id}/{sub.subfield}
 *
 * Special notes
 *
 * When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the
 * proto to JSON conversion must follow the [proto3
 * specification](https://developers.google.com/protocol-buffers/docs/proto3#json).
 *
 * While the single segment variable follows the semantics of
 * [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
 * Expansion, the multi segment variable **does not** follow RFC 6570 Section
 * 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion
 * does not expand special characters like `?` and `#`, which would lead
 * to invalid URLs. As the result, gRPC Transcoding uses a custom encoding
 * for multi segment variables.
 *
 * The path variables **must not** refer to any repeated or mapped field,
 * because client libraries are not capable of handling such variable expansion.
 *
 * The path variables **must not** capture the leading "/" character. The reason
 * is that the most common use case "{var}" does not capture the leading "/"
 * character. For consistency, all path variables must share the same behavior.
 *
 * Repeated message fields must not be mapped to URL query parameters, because
 * no client library can support such complicated mapping.
 *
 * If an API needs to use a JSON array for request or response body, it can map
 * the request or response body to a repeated field. However, some gRPC
 * Transcoding implementations may not support this feature.
 * </pre>
 *
 * Protobuf type {@code google.api.HttpRule}
 */
@com.google.protobuf.Generated
public final class HttpRule extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.api.HttpRule)
    HttpRuleOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 33,
      /* patch= */ 4,
      /* suffix= */ "",
      "HttpRule");
  }
  // Use HttpRule.newBuilder() to construct.
  private HttpRule(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private HttpRule() {
    selector_ = "";
    body_ = "";
    responseBody_ = "";
    additionalBindings_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.HttpProto.internal_static_google_api_HttpRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.HttpRule.class, com.google.api.HttpRule.Builder.class);
  }

  private int patternCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object pattern_;
  public enum PatternCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GET(2),
    PUT(3),
    POST(4),
    DELETE(5),
    PATCH(6),
    CUSTOM(8),
    PATTERN_NOT_SET(0);
    private final int value;
    private PatternCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PatternCase valueOf(int value) {
      return forNumber(value);
    }

    public static PatternCase forNumber(int value) {
      switch (value) {
        case 2: return GET;
        case 3: return PUT;
        case 4: return POST;
        case 5: return DELETE;
        case 6: return PATCH;
        case 8: return CUSTOM;
        case 0: return PATTERN_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PatternCase
  getPatternCase() {
    return PatternCase.forNumber(
        patternCase_);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object selector_ = "";
  /**
   * <pre>
   * Selects a method to which this rule applies.
   *
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax
   * details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   * @return The selector.
   */
  @java.lang.Override
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Selects a method to which this rule applies.
   *
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax
   * details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   * @return The bytes for selector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GET_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Maps to HTTP GET. Used for listing and getting information about
   * resources.
   * </pre>
   *
   * <code>string get = 2;</code>
   * @return Whether the get field is set.
   */
  public boolean hasGet() {
    return patternCase_ == 2;
  }
  /**
   * <pre>
   * Maps to HTTP GET. Used for listing and getting information about
   * resources.
   * </pre>
   *
   * <code>string get = 2;</code>
   * @return The get.
   */
  public java.lang.String getGet() {
    java.lang.Object ref = "";
    if (patternCase_ == 2) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 2) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Maps to HTTP GET. Used for listing and getting information about
   * resources.
   * </pre>
   *
   * <code>string get = 2;</code>
   * @return The bytes for get.
   */
  public com.google.protobuf.ByteString
      getGetBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 2) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 2) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUT_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Maps to HTTP PUT. Used for replacing a resource.
   * </pre>
   *
   * <code>string put = 3;</code>
   * @return Whether the put field is set.
   */
  public boolean hasPut() {
    return patternCase_ == 3;
  }
  /**
   * <pre>
   * Maps to HTTP PUT. Used for replacing a resource.
   * </pre>
   *
   * <code>string put = 3;</code>
   * @return The put.
   */
  public java.lang.String getPut() {
    java.lang.Object ref = "";
    if (patternCase_ == 3) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 3) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Maps to HTTP PUT. Used for replacing a resource.
   * </pre>
   *
   * <code>string put = 3;</code>
   * @return The bytes for put.
   */
  public com.google.protobuf.ByteString
      getPutBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 3) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 3) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POST_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Maps to HTTP POST. Used for creating a resource or performing an action.
   * </pre>
   *
   * <code>string post = 4;</code>
   * @return Whether the post field is set.
   */
  public boolean hasPost() {
    return patternCase_ == 4;
  }
  /**
   * <pre>
   * Maps to HTTP POST. Used for creating a resource or performing an action.
   * </pre>
   *
   * <code>string post = 4;</code>
   * @return The post.
   */
  public java.lang.String getPost() {
    java.lang.Object ref = "";
    if (patternCase_ == 4) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 4) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Maps to HTTP POST. Used for creating a resource or performing an action.
   * </pre>
   *
   * <code>string post = 4;</code>
   * @return The bytes for post.
   */
  public com.google.protobuf.ByteString
      getPostBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 4) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 4) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Maps to HTTP DELETE. Used for deleting a resource.
   * </pre>
   *
   * <code>string delete = 5;</code>
   * @return Whether the delete field is set.
   */
  public boolean hasDelete() {
    return patternCase_ == 5;
  }
  /**
   * <pre>
   * Maps to HTTP DELETE. Used for deleting a resource.
   * </pre>
   *
   * <code>string delete = 5;</code>
   * @return The delete.
   */
  public java.lang.String getDelete() {
    java.lang.Object ref = "";
    if (patternCase_ == 5) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 5) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Maps to HTTP DELETE. Used for deleting a resource.
   * </pre>
   *
   * <code>string delete = 5;</code>
   * @return The bytes for delete.
   */
  public com.google.protobuf.ByteString
      getDeleteBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 5) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 5) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATCH_FIELD_NUMBER = 6;
  /**
   * <pre>
   * Maps to HTTP PATCH. Used for updating a resource.
   * </pre>
   *
   * <code>string patch = 6;</code>
   * @return Whether the patch field is set.
   */
  public boolean hasPatch() {
    return patternCase_ == 6;
  }
  /**
   * <pre>
   * Maps to HTTP PATCH. Used for updating a resource.
   * </pre>
   *
   * <code>string patch = 6;</code>
   * @return The patch.
   */
  public java.lang.String getPatch() {
    java.lang.Object ref = "";
    if (patternCase_ == 6) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (patternCase_ == 6) {
        pattern_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Maps to HTTP PATCH. Used for updating a resource.
   * </pre>
   *
   * <code>string patch = 6;</code>
   * @return The bytes for patch.
   */
  public com.google.protobuf.ByteString
      getPatchBytes() {
    java.lang.Object ref = "";
    if (patternCase_ == 6) {
      ref = pattern_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (patternCase_ == 6) {
        pattern_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_FIELD_NUMBER = 8;
  /**
   * <pre>
   * The custom pattern is used for specifying an HTTP method that is not
   * included in the `pattern` field, such as HEAD, or "*" to leave the
   * HTTP method unspecified for this rule. The wild-card rule is useful
   * for services that provide content to Web (HTML) clients.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   * @return Whether the custom field is set.
   */
  @java.lang.Override
  public boolean hasCustom() {
    return patternCase_ == 8;
  }
  /**
   * <pre>
   * The custom pattern is used for specifying an HTTP method that is not
   * included in the `pattern` field, such as HEAD, or "*" to leave the
   * HTTP method unspecified for this rule. The wild-card rule is useful
   * for services that provide content to Web (HTML) clients.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   * @return The custom.
   */
  @java.lang.Override
  public com.google.api.CustomHttpPattern getCustom() {
    if (patternCase_ == 8) {
       return (com.google.api.CustomHttpPattern) pattern_;
    }
    return com.google.api.CustomHttpPattern.getDefaultInstance();
  }
  /**
   * <pre>
   * The custom pattern is used for specifying an HTTP method that is not
   * included in the `pattern` field, such as HEAD, or "*" to leave the
   * HTTP method unspecified for this rule. The wild-card rule is useful
   * for services that provide content to Web (HTML) clients.
   * </pre>
   *
   * <code>.google.api.CustomHttpPattern custom = 8;</code>
   */
  @java.lang.Override
  public com.google.api.CustomHttpPatternOrBuilder getCustomOrBuilder() {
    if (patternCase_ == 8) {
       return (com.google.api.CustomHttpPattern) pattern_;
    }
    return com.google.api.CustomHttpPattern.getDefaultInstance();
  }

  public static final int BODY_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private volatile java.lang.Object body_ = "";
  /**
   * <pre>
   * The name of the request field whose value is mapped to the HTTP request
   * body, or `*` for mapping all request fields not captured by the path
   * pattern to the HTTP body, or omitted for not having any HTTP request body.
   *
   * NOTE: the referred field must be present at the top-level of the request
   * message type.
   * </pre>
   *
   * <code>string body = 7;</code>
   * @return The body.
   */
  @java.lang.Override
  public java.lang.String getBody() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      body_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The name of the request field whose value is mapped to the HTTP request
   * body, or `*` for mapping all request fields not captured by the path
   * pattern to the HTTP body, or omitted for not having any HTTP request body.
   *
   * NOTE: the referred field must be present at the top-level of the request
   * message type.
   * </pre>
   *
   * <code>string body = 7;</code>
   * @return The bytes for body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getBodyBytes() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      body_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESPONSE_BODY_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private volatile java.lang.Object responseBody_ = "";
  /**
   * <pre>
   * Optional. The name of the response field whose value is mapped to the HTTP
   * response body. When omitted, the entire response message will be used
   * as the HTTP response body.
   *
   * NOTE: The referred field must be present at the top-level of the response
   * message type.
   * </pre>
   *
   * <code>string response_body = 12;</code>
   * @return The responseBody.
   */
  @java.lang.Override
  public java.lang.String getResponseBody() {
    java.lang.Object ref = responseBody_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseBody_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. The name of the response field whose value is mapped to the HTTP
   * response body. When omitted, the entire response message will be used
   * as the HTTP response body.
   *
   * NOTE: The referred field must be present at the top-level of the response
   * message type.
   * </pre>
   *
   * <code>string response_body = 12;</code>
   * @return The bytes for responseBody.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResponseBodyBytes() {
    java.lang.Object ref = responseBody_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      responseBody_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDITIONAL_BINDINGS_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private java.util.List<com.google.api.HttpRule> additionalBindings_;
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.HttpRule> getAdditionalBindingsList() {
    return additionalBindings_;
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.HttpRuleOrBuilder> 
      getAdditionalBindingsOrBuilderList() {
    return additionalBindings_;
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  @java.lang.Override
  public int getAdditionalBindingsCount() {
    return additionalBindings_.size();
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  @java.lang.Override
  public com.google.api.HttpRule getAdditionalBindings(int index) {
    return additionalBindings_.get(index);
  }
  /**
   * <pre>
   * Additional HTTP bindings for the selector. Nested bindings must
   * not contain an `additional_bindings` field themselves (that is,
   * the nesting may only be one level deep).
   * </pre>
   *
   * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
   */
  @java.lang.Override
  public com.google.api.HttpRuleOrBuilder getAdditionalBindingsOrBuilder(
      int index) {
    return additionalBindings_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(selector_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, selector_);
    }
    if (patternCase_ == 2) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, pattern_);
    }
    if (patternCase_ == 3) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, pattern_);
    }
    if (patternCase_ == 4) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, pattern_);
    }
    if (patternCase_ == 5) {
      com.google.protobuf.GeneratedMessage.writeString(output, 5, pattern_);
    }
    if (patternCase_ == 6) {
      com.google.protobuf.GeneratedMessage.writeString(output, 6, pattern_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(body_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 7, body_);
    }
    if (patternCase_ == 8) {
      output.writeMessage(8, (com.google.api.CustomHttpPattern) pattern_);
    }
    for (int i = 0; i < additionalBindings_.size(); i++) {
      output.writeMessage(11, additionalBindings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(responseBody_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 12, responseBody_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(selector_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, selector_);
    }
    if (patternCase_ == 2) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, pattern_);
    }
    if (patternCase_ == 3) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, pattern_);
    }
    if (patternCase_ == 4) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, pattern_);
    }
    if (patternCase_ == 5) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(5, pattern_);
    }
    if (patternCase_ == 6) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(6, pattern_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(body_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(7, body_);
    }
    if (patternCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.api.CustomHttpPattern) pattern_);
    }
    for (int i = 0; i < additionalBindings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, additionalBindings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(responseBody_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(12, responseBody_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.HttpRule)) {
      return super.equals(obj);
    }
    com.google.api.HttpRule other = (com.google.api.HttpRule) obj;

    if (!getSelector()
        .equals(other.getSelector())) return false;
    if (!getBody()
        .equals(other.getBody())) return false;
    if (!getResponseBody()
        .equals(other.getResponseBody())) return false;
    if (!getAdditionalBindingsList()
        .equals(other.getAdditionalBindingsList())) return false;
    if (!getPatternCase().equals(other.getPatternCase())) return false;
    switch (patternCase_) {
      case 2:
        if (!getGet()
            .equals(other.getGet())) return false;
        break;
      case 3:
        if (!getPut()
            .equals(other.getPut())) return false;
        break;
      case 4:
        if (!getPost()
            .equals(other.getPost())) return false;
        break;
      case 5:
        if (!getDelete()
            .equals(other.getDelete())) return false;
        break;
      case 6:
        if (!getPatch()
            .equals(other.getPatch())) return false;
        break;
      case 8:
        if (!getCustom()
            .equals(other.getCustom())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    hash = (37 * hash) + RESPONSE_BODY_FIELD_NUMBER;
    hash = (53 * hash) + getResponseBody().hashCode();
    if (getAdditionalBindingsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalBindingsList().hashCode();
    }
    switch (patternCase_) {
      case 2:
        hash = (37 * hash) + GET_FIELD_NUMBER;
        hash = (53 * hash) + getGet().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PUT_FIELD_NUMBER;
        hash = (53 * hash) + getPut().hashCode();
        break;
      case 4:
        hash = (37 * hash) + POST_FIELD_NUMBER;
        hash = (53 * hash) + getPost().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 6:
        hash = (37 * hash) + PATCH_FIELD_NUMBER;
        hash = (53 * hash) + getPatch().hashCode();
        break;
      case 8:
        hash = (37 * hash) + CUSTOM_FIELD_NUMBER;
        hash = (53 * hash) + getCustom().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.HttpRule parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.HttpRule parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.HttpRule parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.api.HttpRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.HttpRule parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.HttpRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.HttpRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * gRPC Transcoding
   *
   * gRPC Transcoding is a feature for mapping between a gRPC method and one or
   * more HTTP REST endpoints. It allows developers to build a single API service
   * that supports both gRPC APIs and REST APIs. Many systems, including [Google
   * APIs](https://github.com/googleapis/googleapis),
   * [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC
   * Gateway](https://github.com/grpc-ecosystem/grpc-gateway),
   * and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature
   * and use it for large scale production services.
   *
   * `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies
   * how different portions of the gRPC request message are mapped to the URL
   * path, URL query parameters, and HTTP request body. It also controls how the
   * gRPC response message is mapped to the HTTP response body. `HttpRule` is
   * typically specified as an `google.api.http` annotation on the gRPC method.
   *
   * Each mapping specifies a URL path template and an HTTP method. The path
   * template may refer to one or more fields in the gRPC request message, as long
   * as each field is a non-repeated field with a primitive (non-message) type.
   * The path template controls how fields of the request message are mapped to
   * the URL path.
   *
   * Example:
   *
   * service Messaging {
   * rpc GetMessage(GetMessageRequest) returns (Message) {
   * option (google.api.http) = {
   * get: "/v1/{name=messages/&#42;}"
   * };
   * }
   * }
   * message GetMessageRequest {
   * string name = 1; // Mapped to URL path.
   * }
   * message Message {
   * string text = 1; // The resource content.
   * }
   *
   * This enables an HTTP REST to gRPC mapping as below:
   *
   * - HTTP: `GET /v1/messages/123456`
   * - gRPC: `GetMessage(name: "messages/123456")`
   *
   * Any fields in the request message which are not bound by the path template
   * automatically become HTTP query parameters if there is no HTTP request body.
   * For example:
   *
   * service Messaging {
   * rpc GetMessage(GetMessageRequest) returns (Message) {
   * option (google.api.http) = {
   * get:"/v1/messages/{message_id}"
   * };
   * }
   * }
   * message GetMessageRequest {
   * message SubMessage {
   * string subfield = 1;
   * }
   * string message_id = 1; // Mapped to URL path.
   * int64 revision = 2;    // Mapped to URL query parameter `revision`.
   * SubMessage sub = 3;    // Mapped to URL query parameter `sub.subfield`.
   * }
   *
   * This enables a HTTP JSON to RPC mapping as below:
   *
   * - HTTP: `GET /v1/messages/123456?revision=2&amp;sub.subfield=foo`
   * - gRPC: `GetMessage(message_id: "123456" revision: 2 sub:
   * SubMessage(subfield: "foo"))`
   *
   * Note that fields which are mapped to URL query parameters must have a
   * primitive type or a repeated primitive type or a non-repeated message type.
   * In the case of a repeated type, the parameter can be repeated in the URL
   * as `...?param=A&amp;param=B`. In the case of a message type, each field of the
   * message is mapped to a separate parameter, such as
   * `...?foo.a=A&amp;foo.b=B&amp;foo.c=C`.
   *
   * For HTTP methods that allow a request body, the `body` field
   * specifies the mapping. Consider a REST update method on the
   * message resource collection:
   *
   * service Messaging {
   * rpc UpdateMessage(UpdateMessageRequest) returns (Message) {
   * option (google.api.http) = {
   * patch: "/v1/messages/{message_id}"
   * body: "message"
   * };
   * }
   * }
   * message UpdateMessageRequest {
   * string message_id = 1; // mapped to the URL
   * Message message = 2;   // mapped to the body
   * }
   *
   * The following HTTP JSON to RPC mapping is enabled, where the
   * representation of the JSON in the request body is determined by
   * protos JSON encoding:
   *
   * - HTTP: `PATCH /v1/messages/123456 { "text": "Hi!" }`
   * - gRPC: `UpdateMessage(message_id: "123456" message { text: "Hi!" })`
   *
   * The special name `*` can be used in the body mapping to define that
   * every field not bound by the path template should be mapped to the
   * request body.  This enables the following alternative definition of
   * the update method:
   *
   * service Messaging {
   * rpc UpdateMessage(Message) returns (Message) {
   * option (google.api.http) = {
   * patch: "/v1/messages/{message_id}"
   * body: "*"
   * };
   * }
   * }
   * message Message {
   * string message_id = 1;
   * string text = 2;
   * }
   *
   *
   * The following HTTP JSON to RPC mapping is enabled:
   *
   * - HTTP: `PATCH /v1/messages/123456 { "text": "Hi!" }`
   * - gRPC: `UpdateMessage(message_id: "123456" text: "Hi!")`
   *
   * Note that when using `*` in the body mapping, it is not possible to
   * have HTTP parameters, as all fields not bound by the path end in
   * the body. This makes this option more rarely used in practice when
   * defining REST APIs. The common usage of `*` is in custom methods
   * which don't use the URL at all for transferring data.
   *
   * It is possible to define multiple HTTP methods for one RPC by using
   * the `additional_bindings` option. Example:
   *
   * service Messaging {
   * rpc GetMessage(GetMessageRequest) returns (Message) {
   * option (google.api.http) = {
   * get: "/v1/messages/{message_id}"
   * additional_bindings {
   * get: "/v1/users/{user_id}/messages/{message_id}"
   * }
   * };
   * }
   * }
   * message GetMessageRequest {
   * string message_id = 1;
   * string user_id = 2;
   * }
   *
   * This enables the following two alternative HTTP JSON to RPC mappings:
   *
   * - HTTP: `GET /v1/messages/123456`
   * - gRPC: `GetMessage(message_id: "123456")`
   *
   * - HTTP: `GET /v1/users/me/messages/123456`
   * - gRPC: `GetMessage(user_id: "me" message_id: "123456")`
   *
   * Rules for HTTP mapping
   *
   * 1. Leaf request fields (recursive expansion nested messages in the request
   * message) are classified into three categories:
   * - Fields referred by the path template. They are passed via the URL path.
   * - Fields referred by the [HttpRule.body][google.api.HttpRule.body]. They
   * are passed via the HTTP
   * request body.
   * - All other fields are passed via the URL query parameters, and the
   * parameter name is the field path in the request message. A repeated
   * field can be represented as multiple query parameters under the same
   * name.
   * 2. If [HttpRule.body][google.api.HttpRule.body] is "*", there is no URL
   * query parameter, all fields
   * are passed via URL path and HTTP request body.
   * 3. If [HttpRule.body][google.api.HttpRule.body] is omitted, there is no HTTP
   * request body, all
   * fields are passed via URL path and URL query parameters.
   *
   * Path template syntax
   *
   * Template = "/" Segments [ Verb ] ;
   * Segments = Segment { "/" Segment } ;
   * Segment  = "*" | "**" | LITERAL | Variable ;
   * Variable = "{" FieldPath [ "=" Segments ] "}" ;
   * FieldPath = IDENT { "." IDENT } ;
   * Verb     = ":" LITERAL ;
   *
   * The syntax `*` matches a single URL path segment. The syntax `**` matches
   * zero or more URL path segments, which must be the last part of the URL path
   * except the `Verb`.
   *
   * The syntax `Variable` matches part of the URL path as specified by its
   * template. A variable template must not contain other variables. If a variable
   * matches a single path segment, its template may be omitted, e.g. `{var}`
   * is equivalent to `{var=*}`.
   *
   * The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL`
   * contains any reserved character, such characters should be percent-encoded
   * before the matching.
   *
   * If a variable contains exactly one path segment, such as `"{var}"` or
   * `"{var=*}"`, when such a variable is expanded into a URL path on the client
   * side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The
   * server side does the reverse decoding. Such variables show up in the
   * [Discovery
   * Document](https://developers.google.com/discovery/v1/reference/apis) as
   * `{var}`.
   *
   * If a variable contains multiple path segments, such as `"{var=foo/&#42;}"`
   * or `"{var=**}"`, when such a variable is expanded into a URL path on the
   * client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded.
   * The server side does the reverse decoding, except "%2F" and "%2f" are left
   * unchanged. Such variables show up in the
   * [Discovery
   * Document](https://developers.google.com/discovery/v1/reference/apis) as
   * `{+var}`.
   *
   * Using gRPC API Service Configuration
   *
   * gRPC API Service Configuration (service config) is a configuration language
   * for configuring a gRPC service to become a user-facing product. The
   * service config is simply the YAML representation of the `google.api.Service`
   * proto message.
   *
   * As an alternative to annotating your proto file, you can configure gRPC
   * transcoding in your service config YAML files. You do this by specifying a
   * `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same
   * effect as the proto annotation. This can be particularly useful if you
   * have a proto that is reused in multiple services. Note that any transcoding
   * specified in the service config will override any matching transcoding
   * configuration in the proto.
   *
   * The following example selects a gRPC method and applies an `HttpRule` to it:
   *
   * http:
   * rules:
   * - selector: example.v1.Messaging.GetMessage
   * get: /v1/messages/{message_id}/{sub.subfield}
   *
   * Special notes
   *
   * When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the
   * proto to JSON conversion must follow the [proto3
   * specification](https://developers.google.com/protocol-buffers/docs/proto3#json).
   *
   * While the single segment variable follows the semantics of
   * [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String
   * Expansion, the multi segment variable **does not** follow RFC 6570 Section
   * 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion
   * does not expand special characters like `?` and `#`, which would lead
   * to invalid URLs. As the result, gRPC Transcoding uses a custom encoding
   * for multi segment variables.
   *
   * The path variables **must not** refer to any repeated or mapped field,
   * because client libraries are not capable of handling such variable expansion.
   *
   * The path variables **must not** capture the leading "/" character. The reason
   * is that the most common use case "{var}" does not capture the leading "/"
   * character. For consistency, all path variables must share the same behavior.
   *
   * Repeated message fields must not be mapped to URL query parameters, because
   * no client library can support such complicated mapping.
   *
   * If an API needs to use a JSON array for request or response body, it can map
   * the request or response body to a repeated field. However, some gRPC
   * Transcoding implementations may not support this feature.
   * </pre>
   *
   * Protobuf type {@code google.api.HttpRule}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.HttpRule)
      com.google.api.HttpRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.HttpRule.class, com.google.api.HttpRule.Builder.class);
    }

    // Construct using com.google.api.HttpRule.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      selector_ = "";
      if (customBuilder_ != null) {
        customBuilder_.clear();
      }
      body_ = "";
      responseBody_ = "";
      if (additionalBindingsBuilder_ == null) {
        additionalBindings_ = java.util.Collections.emptyList();
      } else {
        additionalBindings_ = null;
        additionalBindingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      patternCase_ = 0;
      pattern_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.HttpProto.internal_static_google_api_HttpRule_descriptor;
    }

    @java.lang.Override
    public com.google.api.HttpRule getDefaultInstanceForType() {
      return com.google.api.HttpRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.HttpRule build() {
      com.google.api.HttpRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.HttpRule buildPartial() {
      com.google.api.HttpRule result = new com.google.api.HttpRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.HttpRule result) {
      if (additionalBindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          additionalBindings_ = java.util.Collections.unmodifiableList(additionalBindings_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.additionalBindings_ = additionalBindings_;
      } else {
        result.additionalBindings_ = additionalBindingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.HttpRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.selector_ = selector_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.body_ = body_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.responseBody_ = responseBody_;
      }
    }

    private void buildPartialOneofs(com.google.api.HttpRule result) {
      result.patternCase_ = patternCase_;
      result.pattern_ = this.pattern_;
      if (patternCase_ == 8 &&
          customBuilder_ != null) {
        result.pattern_ = customBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.HttpRule) {
        return mergeFrom((com.google.api.HttpRule)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.HttpRule other) {
      if (other == com.google.api.HttpRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBody().isEmpty()) {
        body_ = other.body_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getResponseBody().isEmpty()) {
        responseBody_ = other.responseBody_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (additionalBindingsBuilder_ == null) {
        if (!other.additionalBindings_.isEmpty()) {
          if (additionalBindings_.isEmpty()) {
            additionalBindings_ = other.additionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureAdditionalBindingsIsMutable();
            additionalBindings_.addAll(other.additionalBindings_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalBindings_.isEmpty()) {
          if (additionalBindingsBuilder_.isEmpty()) {
            additionalBindingsBuilder_.dispose();
            additionalBindingsBuilder_ = null;
            additionalBindings_ = other.additionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000200);
            additionalBindingsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 internalGetAdditionalBindingsFieldBuilder() : null;
          } else {
            additionalBindingsBuilder_.addAllMessages(other.additionalBindings_);
          }
        }
      }
      switch (other.getPatternCase()) {
        case GET: {
          patternCase_ = 2;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case PUT: {
          patternCase_ = 3;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case POST: {
          patternCase_ = 4;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case DELETE: {
          patternCase_ = 5;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case PATCH: {
          patternCase_ = 6;
          pattern_ = other.pattern_;
          onChanged();
          break;
        }
        case CUSTOM: {
          mergeCustom(other.getCustom());
          break;
        }
        case PATTERN_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              selector_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              patternCase_ = 2;
              pattern_ = s;
              break;
            } // case 18
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              patternCase_ = 3;
              pattern_ = s;
              break;
            } // case 26
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              patternCase_ = 4;
              pattern_ = s;
              break;
            } // case 34
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              patternCase_ = 5;
              pattern_ = s;
              break;
            } // case 42
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();
              patternCase_ = 6;
              pattern_ = s;
              break;
            } // case 50
            case 58: {
              body_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  internalGetCustomFieldBuilder().getBuilder(),
                  extensionRegistry);
              patternCase_ = 8;
              break;
            } // case 66
            case 90: {
              com.google.api.HttpRule m =
                  input.readMessage(
                      com.google.api.HttpRule.parser(),
                      extensionRegistry);
              if (additionalBindingsBuilder_ == null) {
                ensureAdditionalBindingsIsMutable();
                additionalBindings_.add(m);
              } else {
                additionalBindingsBuilder_.addMessage(m);
              }
              break;
            } // case 90
            case 98: {
              responseBody_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 98
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int patternCase_ = 0;
    private java.lang.Object pattern_;
    public PatternCase
        getPatternCase() {
      return PatternCase.forNumber(
          patternCase_);
    }

    public Builder clearPattern() {
      patternCase_ = 0;
      pattern_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object selector_ = "";
    /**
     * <pre>
     * Selects a method to which this rule applies.
     *
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax
     * details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Selects a method to which this rule applies.
     *
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax
     * details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return The bytes for selector.
     */
    public com.google.protobuf.ByteString
        getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Selects a method to which this rule applies.
     *
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax
     * details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      selector_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Selects a method to which this rule applies.
     *
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax
     * details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearSelector() {
      selector_ = getDefaultInstance().getSelector();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Selects a method to which this rule applies.
     *
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax
     * details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      selector_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return Whether the get field is set.
     */
    @java.lang.Override
    public boolean hasGet() {
      return patternCase_ == 2;
    }
    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return The get.
     */
    @java.lang.Override
    public java.lang.String getGet() {
      java.lang.Object ref = "";
      if (patternCase_ == 2) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 2) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return The bytes for get.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getGetBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 2) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 2) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @param value The get to set.
     * @return This builder for chaining.
     */
    public Builder setGet(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      patternCase_ = 2;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearGet() {
      if (patternCase_ == 2) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP GET. Used for listing and getting information about
     * resources.
     * </pre>
     *
     * <code>string get = 2;</code>
     * @param value The bytes for get to set.
     * @return This builder for chaining.
     */
    public Builder setGetBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      patternCase_ = 2;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return Whether the put field is set.
     */
    @java.lang.Override
    public boolean hasPut() {
      return patternCase_ == 3;
    }
    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return The put.
     */
    @java.lang.Override
    public java.lang.String getPut() {
      java.lang.Object ref = "";
      if (patternCase_ == 3) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 3) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return The bytes for put.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPutBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 3) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 3) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @param value The put to set.
     * @return This builder for chaining.
     */
    public Builder setPut(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      patternCase_ = 3;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearPut() {
      if (patternCase_ == 3) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP PUT. Used for replacing a resource.
     * </pre>
     *
     * <code>string put = 3;</code>
     * @param value The bytes for put to set.
     * @return This builder for chaining.
     */
    public Builder setPutBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      patternCase_ = 3;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return Whether the post field is set.
     */
    @java.lang.Override
    public boolean hasPost() {
      return patternCase_ == 4;
    }
    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return The post.
     */
    @java.lang.Override
    public java.lang.String getPost() {
      java.lang.Object ref = "";
      if (patternCase_ == 4) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 4) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return The bytes for post.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPostBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 4) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 4) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @param value The post to set.
     * @return This builder for chaining.
     */
    public Builder setPost(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      patternCase_ = 4;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearPost() {
      if (patternCase_ == 4) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP POST. Used for creating a resource or performing an action.
     * </pre>
     *
     * <code>string post = 4;</code>
     * @param value The bytes for post to set.
     * @return This builder for chaining.
     */
    public Builder setPostBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      patternCase_ = 4;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return Whether the delete field is set.
     */
    @java.lang.Override
    public boolean hasDelete() {
      return patternCase_ == 5;
    }
    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return The delete.
     */
    @java.lang.Override
    public java.lang.String getDelete() {
      java.lang.Object ref = "";
      if (patternCase_ == 5) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 5) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return The bytes for delete.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDeleteBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 5) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 5) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @param value The delete to set.
     * @return This builder for chaining.
     */
    public Builder setDelete(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      patternCase_ = 5;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearDelete() {
      if (patternCase_ == 5) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP DELETE. Used for deleting a resource.
     * </pre>
     *
     * <code>string delete = 5;</code>
     * @param value The bytes for delete to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      patternCase_ = 5;
      pattern_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return Whether the patch field is set.
     */
    @java.lang.Override
    public boolean hasPatch() {
      return patternCase_ == 6;
    }
    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return The patch.
     */
    @java.lang.Override
    public java.lang.String getPatch() {
      java.lang.Object ref = "";
      if (patternCase_ == 6) {
        ref = pattern_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (patternCase_ == 6) {
          pattern_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return The bytes for patch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPatchBytes() {
      java.lang.Object ref = "";
      if (patternCase_ == 6) {
        ref = pattern_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (patternCase_ == 6) {
          pattern_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @param value The patch to set.
     * @return This builder for chaining.
     */
    public Builder setPatch(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      patternCase_ = 6;
      pattern_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearPatch() {
      if (patternCase_ == 6) {
        patternCase_ = 0;
        pattern_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Maps to HTTP PATCH. Used for updating a resource.
     * </pre>
     *
     * <code>string patch = 6;</code>
     * @param value The bytes for patch to set.
     * @return This builder for chaining.
     */
    public Builder setPatchBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      patternCase_ = 6;
      pattern_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
        com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder> customBuilder_;
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     * @return Whether the custom field is set.
     */
    @java.lang.Override
    public boolean hasCustom() {
      return patternCase_ == 8;
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     * @return The custom.
     */
    @java.lang.Override
    public com.google.api.CustomHttpPattern getCustom() {
      if (customBuilder_ == null) {
        if (patternCase_ == 8) {
          return (com.google.api.CustomHttpPattern) pattern_;
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      } else {
        if (patternCase_ == 8) {
          return customBuilder_.getMessage();
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder setCustom(com.google.api.CustomHttpPattern value) {
      if (customBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pattern_ = value;
        onChanged();
      } else {
        customBuilder_.setMessage(value);
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder setCustom(
        com.google.api.CustomHttpPattern.Builder builderForValue) {
      if (customBuilder_ == null) {
        pattern_ = builderForValue.build();
        onChanged();
      } else {
        customBuilder_.setMessage(builderForValue.build());
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder mergeCustom(com.google.api.CustomHttpPattern value) {
      if (customBuilder_ == null) {
        if (patternCase_ == 8 &&
            pattern_ != com.google.api.CustomHttpPattern.getDefaultInstance()) {
          pattern_ = com.google.api.CustomHttpPattern.newBuilder((com.google.api.CustomHttpPattern) pattern_)
              .mergeFrom(value).buildPartial();
        } else {
          pattern_ = value;
        }
        onChanged();
      } else {
        if (patternCase_ == 8) {
          customBuilder_.mergeFrom(value);
        } else {
          customBuilder_.setMessage(value);
        }
      }
      patternCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public Builder clearCustom() {
      if (customBuilder_ == null) {
        if (patternCase_ == 8) {
          patternCase_ = 0;
          pattern_ = null;
          onChanged();
        }
      } else {
        if (patternCase_ == 8) {
          patternCase_ = 0;
          pattern_ = null;
        }
        customBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    public com.google.api.CustomHttpPattern.Builder getCustomBuilder() {
      return internalGetCustomFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    @java.lang.Override
    public com.google.api.CustomHttpPatternOrBuilder getCustomOrBuilder() {
      if ((patternCase_ == 8) && (customBuilder_ != null)) {
        return customBuilder_.getMessageOrBuilder();
      } else {
        if (patternCase_ == 8) {
          return (com.google.api.CustomHttpPattern) pattern_;
        }
        return com.google.api.CustomHttpPattern.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * The custom pattern is used for specifying an HTTP method that is not
     * included in the `pattern` field, such as HEAD, or "*" to leave the
     * HTTP method unspecified for this rule. The wild-card rule is useful
     * for services that provide content to Web (HTML) clients.
     * </pre>
     *
     * <code>.google.api.CustomHttpPattern custom = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder> 
        internalGetCustomFieldBuilder() {
      if (customBuilder_ == null) {
        if (!(patternCase_ == 8)) {
          pattern_ = com.google.api.CustomHttpPattern.getDefaultInstance();
        }
        customBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            com.google.api.CustomHttpPattern, com.google.api.CustomHttpPattern.Builder, com.google.api.CustomHttpPatternOrBuilder>(
                (com.google.api.CustomHttpPattern) pattern_,
                getParentForChildren(),
                isClean());
        pattern_ = null;
      }
      patternCase_ = 8;
      onChanged();
      return customBuilder_;
    }

    private java.lang.Object body_ = "";
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP request
     * body, or `*` for mapping all request fields not captured by the path
     * pattern to the HTTP body, or omitted for not having any HTTP request body.
     *
     * NOTE: the referred field must be present at the top-level of the request
     * message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return The body.
     */
    public java.lang.String getBody() {
      java.lang.Object ref = body_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        body_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP request
     * body, or `*` for mapping all request fields not captured by the path
     * pattern to the HTTP body, or omitted for not having any HTTP request body.
     *
     * NOTE: the referred field must be present at the top-level of the request
     * message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return The bytes for body.
     */
    public com.google.protobuf.ByteString
        getBodyBytes() {
      java.lang.Object ref = body_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        body_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP request
     * body, or `*` for mapping all request fields not captured by the path
     * pattern to the HTTP body, or omitted for not having any HTTP request body.
     *
     * NOTE: the referred field must be present at the top-level of the request
     * message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      body_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP request
     * body, or `*` for mapping all request fields not captured by the path
     * pattern to the HTTP body, or omitted for not having any HTTP request body.
     *
     * NOTE: the referred field must be present at the top-level of the request
     * message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      body_ = getDefaultInstance().getBody();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the request field whose value is mapped to the HTTP request
     * body, or `*` for mapping all request fields not captured by the path
     * pattern to the HTTP body, or omitted for not having any HTTP request body.
     *
     * NOTE: the referred field must be present at the top-level of the request
     * message type.
     * </pre>
     *
     * <code>string body = 7;</code>
     * @param value The bytes for body to set.
     * @return This builder for chaining.
     */
    public Builder setBodyBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      body_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object responseBody_ = "";
    /**
     * <pre>
     * Optional. The name of the response field whose value is mapped to the HTTP
     * response body. When omitted, the entire response message will be used
     * as the HTTP response body.
     *
     * NOTE: The referred field must be present at the top-level of the response
     * message type.
     * </pre>
     *
     * <code>string response_body = 12;</code>
     * @return The responseBody.
     */
    public java.lang.String getResponseBody() {
      java.lang.Object ref = responseBody_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseBody_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. The name of the response field whose value is mapped to the HTTP
     * response body. When omitted, the entire response message will be used
     * as the HTTP response body.
     *
     * NOTE: The referred field must be present at the top-level of the response
     * message type.
     * </pre>
     *
     * <code>string response_body = 12;</code>
     * @return The bytes for responseBody.
     */
    public com.google.protobuf.ByteString
        getResponseBodyBytes() {
      java.lang.Object ref = responseBody_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        responseBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. The name of the response field whose value is mapped to the HTTP
     * response body. When omitted, the entire response message will be used
     * as the HTTP response body.
     *
     * NOTE: The referred field must be present at the top-level of the response
     * message type.
     * </pre>
     *
     * <code>string response_body = 12;</code>
     * @param value The responseBody to set.
     * @return This builder for chaining.
     */
    public Builder setResponseBody(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      responseBody_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The name of the response field whose value is mapped to the HTTP
     * response body. When omitted, the entire response message will be used
     * as the HTTP response body.
     *
     * NOTE: The referred field must be present at the top-level of the response
     * message type.
     * </pre>
     *
     * <code>string response_body = 12;</code>
     * @return This builder for chaining.
     */
    public Builder clearResponseBody() {
      responseBody_ = getDefaultInstance().getResponseBody();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The name of the response field whose value is mapped to the HTTP
     * response body. When omitted, the entire response message will be used
     * as the HTTP response body.
     *
     * NOTE: The referred field must be present at the top-level of the response
     * message type.
     * </pre>
     *
     * <code>string response_body = 12;</code>
     * @param value The bytes for responseBody to set.
     * @return This builder for chaining.
     */
    public Builder setResponseBodyBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      responseBody_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.HttpRule> additionalBindings_ =
      java.util.Collections.emptyList();
    private void ensureAdditionalBindingsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        additionalBindings_ = new java.util.ArrayList<com.google.api.HttpRule>(additionalBindings_);
        bitField0_ |= 0x00000200;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder> additionalBindingsBuilder_;

    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<com.google.api.HttpRule> getAdditionalBindingsList() {
      if (additionalBindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalBindings_);
      } else {
        return additionalBindingsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public int getAdditionalBindingsCount() {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.size();
      } else {
        return additionalBindingsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule getAdditionalBindings(int index) {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.get(index);
      } else {
        return additionalBindingsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder setAdditionalBindings(
        int index, com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.set(index, value);
        onChanged();
      } else {
        additionalBindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder setAdditionalBindings(
        int index, com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(value);
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        int index, com.google.api.HttpRule value) {
      if (additionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(index, value);
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAdditionalBindings(
        int index, com.google.api.HttpRule.Builder builderForValue) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalBindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder addAllAdditionalBindings(
        java.lang.Iterable<? extends com.google.api.HttpRule> values) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, additionalBindings_);
        onChanged();
      } else {
        additionalBindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder clearAdditionalBindings() {
      if (additionalBindingsBuilder_ == null) {
        additionalBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        additionalBindingsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public Builder removeAdditionalBindings(int index) {
      if (additionalBindingsBuilder_ == null) {
        ensureAdditionalBindingsIsMutable();
        additionalBindings_.remove(index);
        onChanged();
      } else {
        additionalBindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder getAdditionalBindingsBuilder(
        int index) {
      return internalGetAdditionalBindingsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRuleOrBuilder getAdditionalBindingsOrBuilder(
        int index) {
      if (additionalBindingsBuilder_ == null) {
        return additionalBindings_.get(index);  } else {
        return additionalBindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<? extends com.google.api.HttpRuleOrBuilder> 
         getAdditionalBindingsOrBuilderList() {
      if (additionalBindingsBuilder_ != null) {
        return additionalBindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalBindings_);
      }
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder addAdditionalBindingsBuilder() {
      return internalGetAdditionalBindingsFieldBuilder().addBuilder(
          com.google.api.HttpRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public com.google.api.HttpRule.Builder addAdditionalBindingsBuilder(
        int index) {
      return internalGetAdditionalBindingsFieldBuilder().addBuilder(
          index, com.google.api.HttpRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional HTTP bindings for the selector. Nested bindings must
     * not contain an `additional_bindings` field themselves (that is,
     * the nesting may only be one level deep).
     * </pre>
     *
     * <code>repeated .google.api.HttpRule additional_bindings = 11;</code>
     */
    public java.util.List<com.google.api.HttpRule.Builder> 
         getAdditionalBindingsBuilderList() {
      return internalGetAdditionalBindingsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder> 
        internalGetAdditionalBindingsFieldBuilder() {
      if (additionalBindingsBuilder_ == null) {
        additionalBindingsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            com.google.api.HttpRule, com.google.api.HttpRule.Builder, com.google.api.HttpRuleOrBuilder>(
                additionalBindings_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        additionalBindings_ = null;
      }
      return additionalBindingsBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.api.HttpRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.HttpRule)
  private static final com.google.api.HttpRule DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.HttpRule();
  }

  public static com.google.api.HttpRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRule>
      PARSER = new com.google.protobuf.AbstractParser<HttpRule>() {
    @java.lang.Override
    public HttpRule parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<HttpRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.HttpRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

