/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.sym;

import com.google.errorprone.annotations.Immutable;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.Symbol;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Immutable
public class ParamSymbol
implements Symbol {
    private final MethodSymbol owner;
    private final String name;

    public ParamSymbol(MethodSymbol owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public MethodSymbol owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Symbol.Kind symKind() {
        return Symbol.Kind.PARAMETER;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.owner);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ParamSymbol)) {
            return false;
        }
        ParamSymbol other = (ParamSymbol)obj;
        return this.name().equals(other.name()) && this.owner().equals(other.owner());
    }

    public String toString() {
        return this.name;
    }
}

